/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.bsp.managers;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.bazelrunner.BazelCommand;
import org.jetbrains.bsp.bazel.bazelrunner.BazelProcess;
import org.jetbrains.bsp.bazel.bazelrunner.BazelRunner;
import org.jetbrains.bsp.bazel.server.bsp.managers.Language;
import org.jetbrains.bsp.bazel.server.bsp.managers.RulesetLanguage;
import org.jetbrains.bsp.protocol.FeatureFlags;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/bsp/bazel/server/bsp/managers/BazelToolchainManager;", "", "bazelRunner", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelRunner;", "featureFlags", "Lorg/jetbrains/bsp/protocol/FeatureFlags;", "<init>", "(Lorg/jetbrains/bsp/bazel/bazelrunner/BazelRunner;Lorg/jetbrains/bsp/protocol/FeatureFlags;)V", "getToolchain", "Lorg/jetbrains/bazel/label/Label;", "rulesetLanguage", "Lorg/jetbrains/bsp/bazel/server/bsp/managers/RulesetLanguage;", "cancelChecker", "Lorg/eclipse/lsp4j/jsonrpc/CancelChecker;", "getAndroidToolchain", "Companion", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bsp_managers-managers"})
public final class BazelToolchainManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BazelRunner bazelRunner;
    @NotNull
    private final FeatureFlags featureFlags;
    @NotNull
    private static final Label NATIVE_ANDROID_TOOLCHAIN = Label.Companion.parse("@bazel_tools//tools/android:sdk_toolchain_type");

    public BazelToolchainManager(@NotNull BazelRunner bazelRunner, @NotNull FeatureFlags featureFlags) {
        Intrinsics.checkNotNullParameter((Object)bazelRunner, (String)"bazelRunner");
        Intrinsics.checkNotNullParameter((Object)featureFlags, (String)"featureFlags");
        this.bazelRunner = bazelRunner;
        this.featureFlags = featureFlags;
    }

    @Nullable
    public final Label getToolchain(@NotNull RulesetLanguage rulesetLanguage, @NotNull CancelChecker cancelChecker) {
        Intrinsics.checkNotNullParameter((Object)rulesetLanguage, (String)"rulesetLanguage");
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        return switch (WhenMappings.$EnumSwitchMapping$0[rulesetLanguage.getLanguage().ordinal()]) {
            case 1 -> Label.Companion.parse("@" + rulesetLanguage.getRulesetName() + "//scala:toolchain_type");
            case 2 -> Label.Companion.parse("@bazel_tools//tools/jdk:runtime_toolchain_type");
            case 3 -> Label.Companion.parse("@" + rulesetLanguage.getRulesetName() + "//kotlin/internal:kt_toolchain_type");
            case 4 -> Label.Companion.parse("@" + rulesetLanguage.getRulesetName() + "//rust:toolchain_type");
            case 5 -> this.getAndroidToolchain(rulesetLanguage, cancelChecker);
            case 6 -> Label.Companion.parse("@" + rulesetLanguage.getRulesetName() + "//go:toolchain");
            default -> null;
        };
    }

    @Nullable
    public final Label getAndroidToolchain(@NotNull RulesetLanguage rulesetLanguage, @NotNull CancelChecker cancelChecker) {
        Intrinsics.checkNotNullParameter((Object)rulesetLanguage, (String)"rulesetLanguage");
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        if (!this.featureFlags.isAndroidSupportEnabled()) {
            return null;
        }
        if (rulesetLanguage.getRulesetName() == null) {
            return NATIVE_ANDROID_TOOLCHAIN;
        }
        Label androidToolchain = Label.Companion.parse("@" + rulesetLanguage.getRulesetName() + "//toolchains/android_sdk:toolchain_type");
        BazelRunner $this$getAndroidToolchain_u24lambda_u240 = this.bazelRunner;
        boolean bl = false;
        BazelCommand command2 = BazelRunner.buildBazelCommand$default($this$getAndroidToolchain_u24lambda_u240, null, (Function1)new Function1<BazelRunner.CommandBuilder, BazelCommand>(androidToolchain){
            final /* synthetic */ Label $androidToolchain;
            {
                this.$androidToolchain = $androidToolchain;
                super(1);
            }

            public final BazelCommand invoke(BazelRunner.CommandBuilder $this$buildBazelCommand) {
                Intrinsics.checkNotNullParameter((Object)$this$buildBazelCommand, (String)"$this$buildBazelCommand");
                return BazelRunner.CommandBuilder.query$default($this$buildBazelCommand, false, (Function1)new Function1<BazelCommand.Query, Unit>(this.$androidToolchain){
                    final /* synthetic */ Label $androidToolchain;
                    {
                        this.$androidToolchain = $androidToolchain;
                        super(1);
                    }

                    public final void invoke(BazelCommand.Query $this$query) {
                        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
                        $this$query.getTargets().add(this.$androidToolchain);
                    }
                }, 1, null);
            }
        }, 1, null);
        boolean androidToolchainExists2 = BazelProcess.waitAndGetResult$default(BazelRunner.runBazelCommand$default($this$getAndroidToolchain_u24lambda_u240, command2, null, false, null, false, 22, null), cancelChecker, false, 2, null).isSuccess();
        return androidToolchainExists2 ? androidToolchain : NATIVE_ANDROID_TOOLCHAIN;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/bsp/bazel/server/bsp/managers/BazelToolchainManager$Companion;", "", "<init>", "()V", "NATIVE_ANDROID_TOOLCHAIN", "Lorg/jetbrains/bazel/label/Label;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bsp_managers-managers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Language.values().length];
            try {
                nArray[Language.Scala.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Language.Java.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Language.Kotlin.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Language.Rust.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Language.Android.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Language.Go.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

