/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.bsp.managers;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.bazelrunner.BazelCommand;
import org.jetbrains.bsp.bazel.bazelrunner.BazelProcessResult;
import org.jetbrains.bsp.bazel.bazelrunner.BazelRunner;
import org.jetbrains.bsp.bazel.logger.BspClientLogger;
import org.jetbrains.bsp.bazel.server.bsp.managers.BazelExternalRulesetsQuery;
import org.jetbrains.bsp.bazel.server.bsp.managers.BazelExternalRulesetsQueryImpl;
import org.jetbrains.bsp.bazel.server.bsp.managers.BazelExternalRulesetsQueryKt;
import org.jetbrains.bsp.bazel.server.bsp.managers.BazelWorkspaceExternalRulesetsQueryImpl;
import org.jetbrains.bsp.bazel.server.bsp.managers.StructuredFilesUtilsKt;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/bsp/bazel/server/bsp/managers/BazelWorkspaceExternalRulesetsQueryImpl;", "Lorg/jetbrains/bsp/bazel/server/bsp/managers/BazelExternalRulesetsQuery;", "bazelRunner", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelRunner;", "isWorkspaceEnabled", "", "bspClientLogger", "Lorg/jetbrains/bsp/bazel/logger/BspClientLogger;", "<init>", "(Lorg/jetbrains/bsp/bazel/bazelrunner/BazelRunner;ZLorg/jetbrains/bsp/bazel/logger/BspClientLogger;)V", "fetchExternalRulesetNames", "", "", "cancelChecker", "Lorg/eclipse/lsp4j/jsonrpc/CancelChecker;", "calculateEligibleRules", "Lorg/w3c/dom/Document;", "Companion", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bsp_managers-managers"})
@SourceDebugExtension(value={"SMAP\nBazelExternalRulesetsQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazelExternalRulesetsQuery.kt\norg/jetbrains/bsp/bazel/server/bsp/managers/BazelWorkspaceExternalRulesetsQueryImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1#2:196\n*E\n"})
public final class BazelWorkspaceExternalRulesetsQueryImpl
implements BazelExternalRulesetsQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BazelRunner bazelRunner;
    private final boolean isWorkspaceEnabled;
    @NotNull
    private final BspClientLogger bspClientLogger;
    private static final Logger log = LogManager.getLogger(BazelExternalRulesetsQueryImpl.class);

    public BazelWorkspaceExternalRulesetsQueryImpl(@NotNull BazelRunner bazelRunner, boolean isWorkspaceEnabled, @NotNull BspClientLogger bspClientLogger) {
        Intrinsics.checkNotNullParameter((Object)bazelRunner, (String)"bazelRunner");
        Intrinsics.checkNotNullParameter((Object)bspClientLogger, (String)"bspClientLogger");
        this.bazelRunner = bazelRunner;
        this.isWorkspaceEnabled = isWorkspaceEnabled;
        this.bspClientLogger = bspClientLogger;
    }

    @Override
    @NotNull
    public List<String> fetchExternalRulesetNames(@NotNull CancelChecker cancelChecker) {
        List list;
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        if (!this.isWorkspaceEnabled) {
            list = CollectionsKt.emptyList();
        } else {
            List list2;
            BazelRunner $this$fetchExternalRulesetNames_u24lambda_u241 = this.bazelRunner;
            boolean bl = false;
            BazelCommand command2 = BazelRunner.buildBazelCommand$default($this$fetchExternalRulesetNames_u24lambda_u241, null, fetchExternalRulesetNames.1.command.1.INSTANCE, 1, null);
            BazelProcessResult result2 = BazelRunner.runBazelCommand$default($this$fetchExternalRulesetNames_u24lambda_u241, command2, null, false, null, false, 18, null).waitAndGetResult(cancelChecker, true);
            boolean bl2 = false;
            if (result2.isNotSuccess()) {
                String queryFailedMessage = BazelExternalRulesetsQueryKt.access$getQueryFailedMessage(result2);
                this.bspClientLogger.warn(queryFailedMessage);
                log.warn(queryFailedMessage);
                list2 = null;
            } else {
                Document document = StructuredFilesUtilsKt.readXML(result2.getStdout(), log);
                list2 = document != null ? this.calculateEligibleRules(document) : null;
            }
            list = list2;
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
        }
        return list;
    }

    private final List<String> calculateEligibleRules(Document $this$calculateEligibleRules) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        String expression = "/query/rule[contains(@class, 'http_archive') and (not(string[@name='generator_function']) or string[@name='generator_function' and contains(@value, 'http_archive')])]//string[@name='name']";
        Object object = xPath.evaluate(expression, $this$calculateEligibleRules, XPathConstants.NODESET);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.w3c.dom.NodeList");
        NodeList eligibleItems = (NodeList)object;
        List returnList = new ArrayList();
        int n = eligibleItems.getLength();
        for (int i = 0; i < n; ++i) {
            String string;
            Node node = eligibleItems.item(i).getAttributes().getNamedItem("value");
            if (node == null || (string = node.getNodeValue()) == null) continue;
            String it = string;
            boolean bl = false;
            returnList.add(it);
        }
        return CollectionsKt.toList((Iterable)returnList);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/bsp/bazel/server/bsp/managers/BazelWorkspaceExternalRulesetsQueryImpl$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/apache/logging/log4j/Logger;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bsp_managers-managers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

