/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.bzlmod;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bazel.label.Apparent;
import org.jetbrains.bazel.label.Canonical;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bazel.label.Main;
import org.jetbrains.bazel.label.RelativeLabel;
import org.jetbrains.bazel.label.RepoType;
import org.jetbrains.bazel.label.ResolvedLabel;
import org.jetbrains.bazel.label.SyntheticLabel;
import org.jetbrains.bsp.bazel.bazelrunner.BazelRunner;
import org.jetbrains.bsp.bazel.bazelrunner.ModuleOutputParser;
import org.jetbrains.bsp.bazel.bazelrunner.ModuleResolver;
import org.jetbrains.bsp.bazel.bazelrunner.ShowRepoResult;
import org.jetbrains.bsp.bazel.bazelrunner.utils.BazelInfo;
import org.jetbrains.bsp.bazel.logger.BspClientLogger;
import org.jetbrains.bsp.bazel.server.bzlmod.BzlmodRepoMapping;
import org.jetbrains.bsp.bazel.server.bzlmod.RepoMapping;
import org.jetbrains.bsp.bazel.server.bzlmod.RepoMappingDisabled;
import org.jetbrains.bsp.bazel.server.bzlmod.RepoMappingKt;
import org.jetbrains.bsp.bazel.workspacecontext.WorkspaceContext;
import org.jetbrains.bsp.bazel.workspacecontext.WorkspaceContextKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a&\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\"#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"canonicalize", "Lorg/jetbrains/bazel/label/Label;", "repoMapping", "Lorg/jetbrains/bsp/bazel/server/bzlmod/RepoMapping;", "canonicalizeOrNull", "rootRulesToNeededTransitiveRules", "", "", "", "getRootRulesToNeededTransitiveRules", "()Ljava/util/Map;", "calculateRepoMapping", "workspaceContext", "Lorg/jetbrains/bsp/bazel/workspacecontext/WorkspaceContext;", "bazelRunner", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelRunner;", "bazelInfo", "Lorg/jetbrains/bsp/bazel/bazelrunner/utils/BazelInfo;", "bspClientLogger", "Lorg/jetbrains/bsp/bazel/logger/BspClientLogger;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bzlmod-bzlmod"})
@SourceDebugExtension(value={"SMAP\nRepoMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepoMapping.kt\norg/jetbrains/bsp/bazel/server/bzlmod/RepoMappingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1611#2,9:129\n1863#2:138\n1864#2:140\n1620#2:141\n1557#2:142\n1628#2,3:143\n2737#2,7:146\n1#3:139\n*S KotlinDebug\n*F\n+ 1 RepoMapping.kt\norg/jetbrains/bsp/bazel/server/bzlmod/RepoMappingKt\n*L\n86#1:129,9\n86#1:138\n86#1:140\n86#1:141\n87#1:142\n87#1:143,3\n88#1:146,7\n86#1:139\n*E\n"})
public final class RepoMappingKt {
    @NotNull
    private static final Map<String, List<String>> rootRulesToNeededTransitiveRules = MapsKt.mapOf((Pair)TuplesKt.to((Object)"rules_kotlin", (Object)CollectionsKt.listOf((Object)"rules_java")));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final Label canonicalize(@NotNull Label $this$canonicalize, @NotNull RepoMapping repoMapping2) {
        Label label;
        Intrinsics.checkNotNullParameter((Object)$this$canonicalize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)repoMapping2, (String)"repoMapping");
        RepoMapping repoMapping3 = repoMapping2;
        if (repoMapping3 instanceof RepoMappingDisabled) {
            label = $this$canonicalize;
            return label;
        } else {
            if (!(repoMapping3 instanceof BzlmodRepoMapping)) throw new NoWhenBranchMatchedException();
            Label label2 = $this$canonicalize;
            if (label2 instanceof ResolvedLabel) {
                ResolvedLabel resolvedLabel;
                RepoType repoType = ((ResolvedLabel)$this$canonicalize).getRepo();
                if (repoType instanceof Main) {
                    resolvedLabel = (ResolvedLabel)$this$canonicalize;
                } else if (repoType instanceof Canonical) {
                    resolvedLabel = (ResolvedLabel)$this$canonicalize;
                } else {
                    if (!(repoType instanceof Apparent)) throw new NoWhenBranchMatchedException();
                    String apparentRepoName = ((ResolvedLabel)$this$canonicalize).getRepoName();
                    String string = ((BzlmodRepoMapping)repoMapping2).getApparentRepoNameToCanonicalName().get(apparentRepoName);
                    if (string == null) {
                        throw new IllegalStateException(("No canonical name found for " + $this$canonicalize).toString());
                    }
                    String canonicalRepoName = string;
                    resolvedLabel = ResolvedLabel.copy$default((ResolvedLabel)$this$canonicalize, new Canonical(canonicalRepoName), null, null, 6, null);
                }
                label = resolvedLabel;
                return label;
            } else {
                if (label2 instanceof RelativeLabel) {
                    throw new IllegalStateException(("Relative label " + $this$canonicalize + " cannot be canonicalized").toString());
                }
                if (!(label2 instanceof SyntheticLabel)) throw new NoWhenBranchMatchedException();
                label = $this$canonicalize;
            }
        }
        return label;
    }

    @Nullable
    public static final Label canonicalizeOrNull(@NotNull Label $this$canonicalizeOrNull, @NotNull RepoMapping repoMapping2) {
        Label label;
        Intrinsics.checkNotNullParameter((Object)$this$canonicalizeOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)repoMapping2, (String)"repoMapping");
        try {
            label = RepoMappingKt.canonicalize($this$canonicalizeOrNull, repoMapping2);
        }
        catch (Exception exception) {
            label = null;
        }
        return label;
    }

    @NotNull
    public static final Map<String, List<String>> getRootRulesToNeededTransitiveRules() {
        return rootRulesToNeededTransitiveRules;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RepoMapping calculateRepoMapping(@NotNull WorkspaceContext workspaceContext2, @NotNull BazelRunner bazelRunner, @NotNull BazelInfo bazelInfo, @NotNull BspClientLogger bspClientLogger) {
        Map map;
        Object v0;
        Iterator<String> $this$reduceOrNull$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Map<String, String> map2;
        Intrinsics.checkNotNullParameter((Object)workspaceContext2, (String)"workspaceContext");
        Intrinsics.checkNotNullParameter((Object)bazelRunner, (String)"bazelRunner");
        Intrinsics.checkNotNullParameter((Object)bazelInfo, (String)"bazelInfo");
        Intrinsics.checkNotNullParameter((Object)bspClientLogger, (String)"bspClientLogger");
        if (!bazelInfo.isBzlModEnabled()) {
            return RepoMappingDisabled.INSTANCE;
        }
        ModuleResolver moduleResolver = new ModuleResolver(bazelRunner, new ModuleOutputParser());
        Map moduleCanonicalNameToLocalPath = new LinkedHashMap();
        try {
            map2 = moduleResolver.getRepoMapping("", calculateRepoMapping.moduleApparentNameToCanonicalName.1.INSTANCE);
        }
        catch (Exception e) {
            bspClientLogger.error(e.toString());
            return RepoMappingDisabled.INSTANCE;
        }
        Map<String, String> moduleApparentNameToCanonicalName2 = map2;
        Iterable e = rootRulesToNeededTransitiveRules.keySet();
        boolean $i$f$mapNotNull = false;
        void var10_13 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (moduleApparentNameToCanonicalName2.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(moduleResolver.getRepoMapping((String)it, calculateRepoMapping.moduleApparentNameToCanonicalNameForNeededTransitiveRules.2.1.INSTANCE));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void map3;
                Map $i$f$mapTo2 = (Map)iterator$iv.next();
                Map acc = (Map)accumulator$iv;
                boolean bl = false;
                accumulator$iv = MapsKt.plus((Map)acc, (Map)map3);
            }
            v0 = accumulator$iv;
        }
        if ((map = (Map)v0) == null) {
            map = MapsKt.emptyMap();
        }
        Map moduleApparentNameToCanonicalNameForNeededTransitiveRules2 = map;
        for (String externalRepo : WorkspaceContextKt.getExternalRepositoriesTreatedAsInternal(workspaceContext2)) {
            try {
                ShowRepoResult showRepoResult2 = moduleResolver.resolveModule(externalRepo, calculateRepoMapping.showRepoResult.1.INSTANCE);
                if (showRepoResult2 instanceof ShowRepoResult.LocalRepository) {
                    String string = ((ShowRepoResult.LocalRepository)showRepoResult2).getName();
                    Path path2 = Paths.get(((ShowRepoResult.LocalRepository)showRepoResult2).getPath(), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                    moduleCanonicalNameToLocalPath.put(string, path2);
                    continue;
                }
                bspClientLogger.warn("Tried to import external module " + externalRepo + ", but it was not `local_path_override`: " + showRepoResult2);
            }
            catch (Exception e2) {
                bspClientLogger.error(e2.toString());
            }
        }
        Map moduleCanonicalNameToPath = MapsKt.toMutableMap((Map)moduleCanonicalNameToLocalPath);
        for (String canonicalName : moduleApparentNameToCanonicalName2.values()) {
            if (Intrinsics.areEqual((Object)canonicalName, (Object)"")) {
                moduleCanonicalNameToPath.put(canonicalName, bazelInfo.getWorkspaceRoot());
                continue;
            }
            Path localPath = (Path)moduleCanonicalNameToLocalPath.get(canonicalName);
            Path repoPath = localPath != null ? bazelInfo.getWorkspaceRoot().resolve(localPath) : bazelInfo.getOutputBase().resolve("external").resolve(canonicalName);
            moduleCanonicalNameToPath.put(canonicalName, repoPath);
        }
        return new BzlmodRepoMapping(moduleCanonicalNameToLocalPath, MapsKt.plus((Map)moduleApparentNameToCanonicalNameForNeededTransitiveRules2, moduleApparentNameToCanonicalName2), moduleCanonicalNameToPath);
    }
}

