/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.dependencygraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.info.BspTargetInfo;
import org.jetbrains.bsp.bazel.server.dependencygraph.DependencyGraph;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0012\u001a\u00020\u0004J4\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00030\u00100\u00062\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u001c\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00030\u00102\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\"\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010!\u001a\u00020\u0004J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010#\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\u0004H\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010!\u001a\u00020\u0004H\u0002J4\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070)R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00040\rj\b\u0012\u0004\u0012\u00020\u0004`\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00030\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/bsp/bazel/server/dependencygraph/DependencyGraph;", "", "rootTargets", "", "Lorg/jetbrains/bazel/label/Label;", "idToTargetInfo", "", "Lorg/jetbrains/bsp/bazel/info/BspTargetInfo$TargetInfo;", "<init>", "(Ljava/util/Set;Ljava/util/Map;)V", "idToDirectDependenciesIds", "", "idToReverseDependenciesIds", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "idToLazyTransitiveDependencies", "Lkotlin/Lazy;", "getReverseDependencies", "id", "createIdToLazyTransitiveDependenciesMap", "calculateLazyTransitiveDependenciesForTarget", "targetInfo", "calculateTransitiveDependenciesForTarget", "calculateStrictlyTransitiveDependencies", "dependencies", "idsToTargetInfo", "directDependenciesIds", "targetIds", "allTargetsAtDepth", "depth", "", "targets", "transitiveDependenciesWithoutRootTargets", "targetId", "getDependencies", "target", "isNotARootTarget", "", "collectTransitiveDependenciesAndAddTarget", "filterUsedLibraries", "libraries", "Lkotlin/sequences/Sequence;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_dependencygraph-dependencygraph"})
@SourceDebugExtension(value={"SMAP\nDependencyGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyGraph.kt\norg/jetbrains/bsp/bazel/server/dependencygraph/DependencyGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,123:1\n1863#2:124\n1863#2,2:125\n1864#2:127\n1246#2,4:130\n1368#2:134\n1454#2,5:135\n1611#2,9:140\n1863#2:149\n1864#2:151\n1620#2:152\n1368#2:153\n1454#2,5:154\n774#2:160\n865#2,2:161\n1368#2:163\n1454#2,5:164\n1557#2:169\n1628#2,3:170\n1557#2:173\n1628#2,3:174\n1557#2:177\n1628#2,3:178\n462#3:128\n412#3:129\n487#3,7:183\n1#4:150\n1#4:159\n1317#5,2:181\n*S KotlinDebug\n*F\n+ 1 DependencyGraph.kt\norg/jetbrains/bsp/bazel/server/dependencygraph/DependencyGraph\n*L\n15#1:124\n20#1:125,2\n15#1:127\n30#1:130,4\n46#1:134\n46#1:135,5\n50#1:140,9\n50#1:149\n50#1:151\n50#1:152\n54#1:153\n54#1:154,5\n81#1:160\n81#1:161,2\n82#1:163\n82#1:164,5\n87#1:169\n87#1:170,3\n88#1:173\n88#1:174,3\n99#1:177\n99#1:178,3\n30#1:128\n30#1:129\n120#1:183,7\n50#1:150\n108#1:181,2\n*E\n"})
public final class DependencyGraph {
    @NotNull
    private final Set<Label> rootTargets;
    @NotNull
    private final Map<Label, BspTargetInfo.TargetInfo> idToTargetInfo;
    @NotNull
    private final Map<Label, Set<Label>> idToDirectDependenciesIds;
    @NotNull
    private final Map<Label, HashSet<Label>> idToReverseDependenciesIds;
    @NotNull
    private final Map<Label, Lazy<Set<BspTargetInfo.TargetInfo>>> idToLazyTransitiveDependencies;

    public DependencyGraph(@NotNull Set<? extends Label> rootTargets2, @NotNull Map<Label, BspTargetInfo.TargetInfo> idToTargetInfo) {
        Intrinsics.checkNotNullParameter(rootTargets2, (String)"rootTargets");
        Intrinsics.checkNotNullParameter(idToTargetInfo, (String)"idToTargetInfo");
        this.rootTargets = rootTargets2;
        this.idToTargetInfo = idToTargetInfo;
        this.idToDirectDependenciesIds = new LinkedHashMap();
        this.idToReverseDependenciesIds = new LinkedHashMap();
        Iterable $this$forEach$iv = this.idToTargetInfo.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Label id = (Label)entry.getKey();
            BspTargetInfo.TargetInfo target = (BspTargetInfo.TargetInfo)entry.getValue();
            Set<Label> dependencies = this.getDependencies(target);
            this.idToDirectDependenciesIds.put(id, dependencies);
            Iterable $this$forEach$iv2 = dependencies;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Label dep = (Label)element$iv2;
                boolean bl2 = false;
                Function1 function1 = 1.1.1.INSTANCE;
                this.idToReverseDependenciesIds.computeIfAbsent(dep, new Function(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ Object apply(Object p0) {
                        return this.function.invoke(p0);
                    }
                }).add(id);
            }
        }
        this.idToLazyTransitiveDependencies = this.createIdToLazyTransitiveDependenciesMap(this.idToTargetInfo);
    }

    public /* synthetic */ DependencyGraph(Set set, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(set, map);
    }

    @NotNull
    public final Set<Label> getReverseDependencies(@NotNull Label id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Set set = this.idToReverseDependenciesIds.get(id);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Label, Lazy<Set<BspTargetInfo.TargetInfo>>> createIdToLazyTransitiveDependenciesMap(Map<Label, BspTargetInfo.TargetInfo> idToTargetInfo) {
        void $this$mapValuesTo$iv$iv;
        Map<Label, BspTargetInfo.TargetInfo> $this$mapValues$iv = idToTargetInfo;
        boolean $i$f$mapValues = false;
        Map<Label, BspTargetInfo.TargetInfo> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            BspTargetInfo.TargetInfo targetInfo = (BspTargetInfo.TargetInfo)entry2.getValue();
            Lazy<Set<BspTargetInfo.TargetInfo>> lazy = this.calculateLazyTransitiveDependenciesForTarget(targetInfo);
            map3.put(k, lazy);
        }
        return destination$iv$iv;
    }

    private final Lazy<Set<BspTargetInfo.TargetInfo>> calculateLazyTransitiveDependenciesForTarget(BspTargetInfo.TargetInfo targetInfo) {
        return LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends BspTargetInfo.TargetInfo>>(this, targetInfo){
            final /* synthetic */ DependencyGraph this$0;
            final /* synthetic */ BspTargetInfo.TargetInfo $targetInfo;
            {
                this.this$0 = $receiver;
                this.$targetInfo = $targetInfo;
                super(0);
            }

            public final Set<BspTargetInfo.TargetInfo> invoke() {
                return DependencyGraph.access$calculateTransitiveDependenciesForTarget(this.this$0, this.$targetInfo);
            }
        }));
    }

    private final Set<BspTargetInfo.TargetInfo> calculateTransitiveDependenciesForTarget(BspTargetInfo.TargetInfo targetInfo) {
        Set<Label> dependencies = this.getDependencies(targetInfo);
        Set<BspTargetInfo.TargetInfo> strictlyTransitiveDependencies = this.calculateStrictlyTransitiveDependencies(dependencies);
        Set<BspTargetInfo.TargetInfo> directDependencies = this.idsToTargetInfo(dependencies);
        return SetsKt.plus(strictlyTransitiveDependencies, (Iterable)directDependencies);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<BspTargetInfo.TargetInfo> calculateStrictlyTransitiveDependencies(Set<? extends Label> dependencies) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = dependencies;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Label it = (Label)element$iv$iv;
            boolean bl = false;
            Lazy<Set<BspTargetInfo.TargetInfo>> lazy = this.idToLazyTransitiveDependencies.get(it);
            Set set = lazy != null ? (Set)lazy.getValue() : null;
            if (set == null) {
                set = SetsKt.emptySet();
            }
            Iterable list$iv$iv = set;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<BspTargetInfo.TargetInfo> idsToTargetInfo(Set<? extends Label> dependencies) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = dependencies;
        Map<Label, BspTargetInfo.TargetInfo> map = this.idToTargetInfo;
        boolean $i$f$mapNotNull = false;
        void var5_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BspTargetInfo.TargetInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Label p0 = (Label)element$iv$iv;
            boolean bl2 = false;
            if (map.get(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Label> directDependenciesIds(Set<? extends Label> targetIds) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = targetIds;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Label it = (Label)element$iv$iv;
            boolean bl = false;
            Set set = this.idToDirectDependenciesIds.get(it);
            if (set == null) {
                set = SetsKt.emptySet();
            }
            Iterable list$iv$iv = set;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final Set<BspTargetInfo.TargetInfo> allTargetsAtDepth(int depth, @NotNull Set<? extends Label> targets2) {
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        if (depth < 0) {
            return SetsKt.plus(this.idsToTargetInfo(targets2), (Iterable)this.calculateStrictlyTransitiveDependencies(targets2));
        }
        Set searched = new LinkedHashSet();
        Set<? extends Label> currentTargets = targets2;
        for (int currentDepth = depth; currentDepth > 0; --currentDepth) {
            searched.addAll((Collection)this.idsToTargetInfo(currentTargets));
            currentTargets = this.directDependenciesIds(currentTargets);
        }
        searched.addAll((Collection)this.idsToTargetInfo(currentTargets));
        return searched;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<BspTargetInfo.TargetInfo> transitiveDependenciesWithoutRootTargets(@NotNull Label targetId) {
        void $this$flatMapTo$iv$iv;
        Label p0;
        Iterable $this$filterTo$iv$iv;
        Set<Label> set;
        Set<Label> set2;
        Object p02;
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        BspTargetInfo.TargetInfo targetInfo = this.idToTargetInfo.get(targetId);
        if (targetInfo != null) {
            p02 = targetInfo;
            boolean bl = false;
            set2 = this.getDependencies((BspTargetInfo.TargetInfo)p02);
        } else {
            set2 = set = null;
        }
        if (set2 == null) {
            set = SetsKt.emptySet();
        }
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        p02 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            p0 = (Label)element$iv$iv;
            boolean bl = false;
            if (!this.isNotARootTarget(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            p0 = (Label)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.collectTransitiveDependenciesAndAddTarget(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Label> getDependencies(BspTargetInfo.TargetInfo target) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        List<BspTargetInfo.Dependency> list = target.getDependenciesList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDependenciesList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            BspTargetInfo.Dependency dependency = (BspTargetInfo.Dependency)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getId());
        }
        $this$map$iv = (List)destination$iv$iv;
        Label.Companion companion = Label.Companion;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(companion.parse((String)p0));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
    }

    private final boolean isNotARootTarget(Label targetId) {
        return !this.rootTargets.contains(targetId);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<BspTargetInfo.TargetInfo> collectTransitiveDependenciesAndAddTarget(Label targetId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Set set;
        Set set2;
        Object object;
        Set target;
        Set set3;
        Set set4;
        BspTargetInfo.TargetInfo targetInfo = this.idToTargetInfo.get(targetId);
        if (targetInfo != null) {
            BspTargetInfo.TargetInfo p0 = targetInfo;
            boolean bl = false;
            set4 = SetsKt.setOf((Object)p0);
        } else {
            set4 = set3 = null;
        }
        if (set4 == null) {
            set3 = target = SetsKt.emptySet();
        }
        if ((object = this.idToLazyTransitiveDependencies.get(targetId)) != null) {
            Lazy<Set<BspTargetInfo.TargetInfo>> p0 = object;
            boolean bl = false;
            set2 = SetsKt.setOf(p0);
        } else {
            set2 = set = null;
        }
        if (set2 == null) {
            set = SetsKt.emptySet();
        }
        object = set;
        boolean $i$f$map = false;
        void p0 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p02;
            Lazy lazy = (Lazy)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Set)p02.getValue());
        }
        Set dependencies = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
        return SetsKt.plus((Set)dependencies, (Iterable)target);
    }

    @NotNull
    public final Map<Label, BspTargetInfo.TargetInfo> filterUsedLibraries(@NotNull Map<Label, BspTargetInfo.TargetInfo> libraries2, @NotNull Sequence<BspTargetInfo.TargetInfo> targets2) {
        Intrinsics.checkNotNullParameter(libraries2, (String)"libraries");
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        HashSet<Label> visited = new HashSet<Label>();
        ArrayDeque queue = new ArrayDeque();
        Sequence $this$forEach$iv = SequencesKt.map(targets2, (Function1)filterUsedLibraries.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Label it = (Label)element$iv;
            boolean bl = false;
            queue.addLast((Object)it);
            visited.add(it);
        }
        while (!((Collection)queue).isEmpty()) {
            Set<Label> dependencies;
            Label label = (Label)queue.removeFirst();
            if (this.idToDirectDependenciesIds.get(label) == null) continue;
            for (Label dependency : dependencies) {
                if (!visited.add(dependency)) continue;
                queue.addLast((Object)dependency);
            }
        }
        Map<Label, BspTargetInfo.TargetInfo> $this$filterKeys$iv = libraries2;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<Label, BspTargetInfo.TargetInfo> result$iv = new LinkedHashMap<Label, BspTargetInfo.TargetInfo>();
        for (Map.Entry<Label, BspTargetInfo.TargetInfo> entry$iv : $this$filterKeys$iv.entrySet()) {
            Label it = entry$iv.getKey();
            boolean bl = false;
            if (!visited.contains(it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    public DependencyGraph() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ Set access$calculateTransitiveDependenciesForTarget(DependencyGraph $this, BspTargetInfo.TargetInfo targetInfo) {
        return $this.calculateTransitiveDependenciesForTarget(targetInfo);
    }
}

