/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.diagnostics;

import ch.epfl.scala.bsp4j.DiagnosticSeverity;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.server.diagnostics.CompilerDiagnosticParser;
import org.jetbrains.bsp.bazel.server.diagnostics.Diagnostic;
import org.jetbrains.bsp.bazel.server.diagnostics.Output;
import org.jetbrains.bsp.bazel.server.diagnostics.Parser;
import org.jetbrains.bsp.bazel.server.diagnostics.Position;
import org.jetbrains.bsp.bazel.server.diagnostics.Scala3CompilerDiagnosticParser;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/bsp/bazel/server/diagnostics/BazelRootMessageParser;", "Lorg/jetbrains/bsp/bazel/server/diagnostics/Parser;", "<init>", "()V", "TARGET_LABEL", "", "tryParse", "", "Lorg/jetbrains/bsp/bazel/server/diagnostics/Diagnostic;", "output", "Lorg/jetbrains/bsp/bazel/server/diagnostics/Output;", "ErrorInBUILD", "Lkotlin/text/Regex;", "findErrorInBUILD", "createError", "match", "Lkotlin/text/MatchResult;", "targetLabel", "Lorg/jetbrains/bazel/label/Label;", "InfoMessage", "findWarningsInInfoMessage", "collectCompilerDiagnostics", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_diagnostics-diagnostics"})
@SourceDebugExtension(value={"SMAP\nBazelRootMessageParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazelRootMessageParser.kt\norg/jetbrains/bsp/bazel/server/diagnostics/BazelRootMessageParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class BazelRootMessageParser
implements Parser {
    @NotNull
    public static final BazelRootMessageParser INSTANCE = new BazelRootMessageParser();
    @NotNull
    private static final String TARGET_LABEL = "(//[\\w/.-]*:[\\w/.-]+)";
    @NotNull
    private static final Regex ErrorInBUILD = new Regex("\n      ^               # start of line\n      ERROR:\\         # error indicator\n      ([^:]+/BUILD)   # path to BUILD file (1)\n      :(\\d+)          # line number (2)\n      (?::(\\d+))?     # optional column number (3)\n      :\\              # \": \" separator\n      (               # beginning of the error message (4)\n      (?:.*           # part of actual error message wrapped with label into optional group\n      (//[\\w/.-]*:[\\w/.-]+)    # target label (5)\n      )?              # make target label optional\n      .*              # part of actual error message\n      )               # end of the error message (4)\n      $               # end of line\n      ", RegexOption.COMMENTS);
    @NotNull
    private static final Regex InfoMessage = new Regex("\n      ^               # start of line\n      INFO:\\          # info indicator\n      .*?             # part of actual message\n      (//[\\w/.-]*:[\\w/.-]+)    # target label (1)\n      .*              # part of actual message\n      $               # end of line\n    ", RegexOption.COMMENTS);

    private BazelRootMessageParser() {
    }

    @Override
    @NotNull
    public List<Diagnostic> tryParse(@NotNull Output output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        List list = this.findErrorInBUILD(output);
        if (list == null && (list = this.findWarningsInInfoMessage(output)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<Diagnostic> findErrorInBUILD(Output output) {
        MatchResult matchResult = output.tryTake(ErrorInBUILD);
        if (matchResult != null) {
            Collection collection;
            MatchResult match = matchResult;
            boolean bl = false;
            Collection collection2 = INSTANCE.collectCompilerDiagnostics(output);
            if (collection2.isEmpty()) {
                boolean bl2 = false;
                collection = CollectionsKt.listOf((Object)INSTANCE.createError(match, output.getTargetLabel()));
            } else {
                collection = collection2;
            }
            return (List)collection;
        }
        return null;
    }

    private final Diagnostic createError(MatchResult match, Label targetLabel) {
        String path2 = (String)match.getGroupValues().get(1);
        int line = Integer.parseInt((String)match.getGroupValues().get(2));
        Integer n = StringsKt.toIntOrNull((String)((String)match.getGroupValues().get(3)));
        int column = n != null ? n : 1;
        String message = (String)match.getGroupValues().get(4);
        return new Diagnostic(new Position(line, column), message, path2, targetLabel, DiagnosticSeverity.ERROR);
    }

    private final List<Diagnostic> findWarningsInInfoMessage(Output output) {
        List<Diagnostic> list;
        MatchResult matchResult = output.tryTake(InfoMessage);
        if (matchResult != null) {
            MatchResult it = matchResult;
            boolean bl = false;
            list = INSTANCE.collectCompilerDiagnostics(output);
        } else {
            list = null;
        }
        return list;
    }

    private final List<Diagnostic> collectCompilerDiagnostics(Output output) {
        return SequencesKt.toList((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<Diagnostic>(output){
            final /* synthetic */ Output $output;
            {
                this.$output = $output;
                super(0);
            }

            public final Diagnostic invoke() {
                Diagnostic diagnostic = CompilerDiagnosticParser.INSTANCE.tryParseOne(this.$output);
                if (diagnostic == null) {
                    diagnostic = Scala3CompilerDiagnosticParser.INSTANCE.tryParseOne(this.$output);
                }
                return diagnostic;
            }
        })));
    }
}

