/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.diagnostics;

import ch.epfl.scala.bsp4j.DiagnosticSeverity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bsp.bazel.server.diagnostics.Diagnostic;
import org.jetbrains.bsp.bazel.server.diagnostics.Output;
import org.jetbrains.bsp.bazel.server.diagnostics.Parser;
import org.jetbrains.bsp.bazel.server.diagnostics.Position;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0005H\u0002\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/bsp/bazel/server/diagnostics/CompilerDiagnosticParser;", "Lorg/jetbrains/bsp/bazel/server/diagnostics/Parser;", "<init>", "()V", "tryParse", "", "Lorg/jetbrains/bsp/bazel/server/diagnostics/Diagnostic;", "output", "Lorg/jetbrains/bsp/bazel/server/diagnostics/Output;", "DiagnosticHeader", "Lkotlin/text/Regex;", "tryParseOne", "collectMessageLines", "", "header", "IssuePositionMarker", "tryCollectLinesTillErrorMarker", "IssueDetails", "tryCollectLinesMatchingIssueDetails", "tryFindColumnNumber", "", "messageLines", "(Ljava/util/List;)Ljava/lang/Integer;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_diagnostics-diagnostics"})
@SourceDebugExtension(value={"SMAP\nCompilerDiagnosticParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerDiagnosticParser.kt\norg/jetbrains/bsp/bazel/server/diagnostics/CompilerDiagnosticParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n360#2,7:63\n1#3:70\n*S KotlinDebug\n*F\n+ 1 CompilerDiagnosticParser.kt\norg/jetbrains/bsp/bazel/server/diagnostics/CompilerDiagnosticParser\n*L\n49#1:63,7\n*E\n"})
public final class CompilerDiagnosticParser
implements Parser {
    @NotNull
    public static final CompilerDiagnosticParser INSTANCE = new CompilerDiagnosticParser();
    @NotNull
    private static final Regex DiagnosticHeader = new Regex("\n      ^                # start of line\n      ([^:]+)          # file path (1)\n      :(\\d+)           # line number (2)\n      (?::(\\d+))?      # optional column number (3)\n      :\\               # \": \" separator\n      ([a-zA-Z\\ ]+):\\  # level (4)\n      (.*)             # actual error message (5)\n      $                # end of line\n      ", RegexOption.COMMENTS);
    @NotNull
    private static final Regex IssuePositionMarker = new Regex("^\\s*\\^\\s*$");
    @NotNull
    private static final Regex IssueDetails = new Regex("^\\s+.*|" + IssuePositionMarker.getPattern());

    private CompilerDiagnosticParser() {
    }

    @Override
    @NotNull
    public List<Diagnostic> tryParse(@NotNull Output output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return CollectionsKt.listOfNotNull((Object)this.tryParseOne(output));
    }

    @Nullable
    public final Diagnostic tryParseOne(@NotNull Output output) {
        Diagnostic diagnostic;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        MatchResult matchResult = output.tryTake(DiagnosticHeader);
        if (matchResult != null) {
            int n;
            MatchResult match = matchResult;
            boolean bl = false;
            String path2 = (String)match.getGroupValues().get(1);
            int line = Integer.parseInt((String)match.getGroupValues().get(2));
            List<String> messageLines = INSTANCE.collectMessageLines((String)match.getGroupValues().get(5), output);
            Integer n2 = StringsKt.toIntOrNull((String)((String)match.getGroupValues().get(3)));
            if (n2 != null) {
                n = n2;
            } else {
                Integer n3 = INSTANCE.tryFindColumnNumber(messageLines);
                n = n3 != null ? n3 : 1;
            }
            int column = n;
            DiagnosticSeverity level = Intrinsics.areEqual(match.getGroupValues().get(4), (Object)"warning") ? DiagnosticSeverity.WARNING : DiagnosticSeverity.ERROR;
            String message = CollectionsKt.joinToString$default((Iterable)messageLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            diagnostic = new Diagnostic(new Position(line, column), message, path2, output.getTargetLabel(), level);
        } else {
            diagnostic = null;
        }
        return diagnostic;
    }

    private final List<String> collectMessageLines(String header, Output output) {
        List lines = new ArrayList();
        lines.addAll((Collection)this.tryCollectLinesMatchingIssueDetails(output));
        if (lines.isEmpty()) {
            lines.addAll((Collection)this.tryCollectLinesTillErrorMarker(output));
        }
        lines.add(0, header);
        return lines;
    }

    private final List<String> tryCollectLinesTillErrorMarker(Output output) {
        int n;
        block2: {
            List<String> peeked;
            List<String> $this$indexOfFirst$iv = peeked = output.peek(20);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<String> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                String item$iv;
                String it = item$iv = iterator.next();
                boolean bl = false;
                if (IssuePositionMarker.matches((CharSequence)it)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        int index = n;
        return index != -1 ? output.take(index + 1) : CollectionsKt.emptyList();
    }

    private final List<String> tryCollectLinesMatchingIssueDetails(Output output) {
        return SequencesKt.toList((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<String>(output){
            final /* synthetic */ Output $output;
            {
                this.$output = $output;
                super(0);
            }

            public final String invoke() {
                MatchResult matchResult = this.$output.tryTake(CompilerDiagnosticParser.access$getIssueDetails$p());
                return matchResult != null ? matchResult.getValue() : null;
            }
        })));
    }

    private final Integer tryFindColumnNumber(List<String> messageLines) {
        Integer n;
        String line;
        Object v0;
        block3: {
            Iterable iterable = messageLines;
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                if (!IssuePositionMarker.matches((CharSequence)it)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        String string = line = (String)v0;
        if (string != null) {
            int it = StringsKt.indexOf$default((CharSequence)string, (String)"^", (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            n = it + 1;
        } else {
            n = null;
        }
        return n;
    }

    public static final /* synthetic */ Regex access$getIssueDetails$p() {
        return IssueDetails;
    }
}

