/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.server.diagnostics.AllCatchParser;
import org.jetbrains.bsp.bazel.server.diagnostics.BazelRootMessageParser;
import org.jetbrains.bsp.bazel.server.diagnostics.CompilerDiagnosticParser;
import org.jetbrains.bsp.bazel.server.diagnostics.Diagnostic;
import org.jetbrains.bsp.bazel.server.diagnostics.DiagnosticsParser;
import org.jetbrains.bsp.bazel.server.diagnostics.Output;
import org.jetbrains.bsp.bazel.server.diagnostics.Parser;
import org.jetbrains.bsp.bazel.server.diagnostics.Position;
import org.jetbrains.bsp.bazel.server.diagnostics.Scala3CompilerDiagnosticParser;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/bsp/bazel/server/diagnostics/DiagnosticsParserImpl;", "Lorg/jetbrains/bsp/bazel/server/diagnostics/DiagnosticsParser;", "<init>", "()V", "parse", "", "Lorg/jetbrains/bsp/bazel/server/diagnostics/Diagnostic;", "bazelOutput", "", "target", "Lorg/jetbrains/bazel/label/Label;", "prepareOutput", "Lorg/jetbrains/bsp/bazel/server/diagnostics/Output;", "collectDiagnostics", "output", "deduplicate", "parsedDiagnostics", "Companion", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_diagnostics-diagnostics"})
@SourceDebugExtension(value={"SMAP\nDiagnosticsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticsParser.kt\norg/jetbrains/bsp/bazel/server/diagnostics/DiagnosticsParserImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,69:1\n827#2:70\n855#2:71\n1755#2,3:72\n856#2:75\n1485#2:76\n1510#2,3:77\n1513#2,3:87\n1557#2:90\n1628#2,3:91\n381#3,7:80\n*S KotlinDebug\n*F\n+ 1 DiagnosticsParser.kt\norg/jetbrains/bsp/bazel/server/diagnostics/DiagnosticsParserImpl\n*L\n18#1:70\n18#1:71\n18#1:72,3\n18#1:75\n50#1:76\n50#1:77,3\n50#1:87,3\n52#1:90\n52#1:91,3\n50#1:80,7\n*E\n"})
public final class DiagnosticsParserImpl
implements DiagnosticsParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<Parser> Parsers;
    @NotNull
    private static final List<Regex> IgnoredLines;

    @Override
    @NotNull
    public List<Diagnostic> parse(@NotNull String bazelOutput, @NotNull Label target) {
        Intrinsics.checkNotNullParameter((Object)bazelOutput, (String)"bazelOutput");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Output output = this.prepareOutput(bazelOutput, target);
        List<Diagnostic> diagnostics = this.collectDiagnostics(output);
        return this.deduplicate(diagnostics);
    }

    /*
     * WARNING - void declaration
     */
    private final Output prepareOutput(String bazelOutput, Label target) {
        void $this$filterNotTo$iv$iv;
        List lines = StringsKt.lines((CharSequence)bazelOutput);
        Iterable $this$filterNot$iv = lines;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            boolean bl;
            block4: {
                String line = (String)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = IgnoredLines;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Regex it = (Regex)element$iv;
                        boolean bl3 = false;
                        if (!it.matches((CharSequence)line)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List relevantLines = (List)destination$iv$iv;
        return new Output(relevantLines, target);
    }

    private final List<Diagnostic> collectDiagnostics(Output output) {
        List diagnostics = new ArrayList();
        block0: while (output.nonEmpty()) {
            for (Parser parser : Parsers) {
                List<Diagnostic> result2 = parser.tryParse(output);
                if (!(!((Collection)result2).isEmpty())) continue;
                diagnostics.addAll((Collection)result2);
                continue block0;
            }
        }
        if (diagnostics.isEmpty()) {
            diagnostics.add(new Diagnostic(new Position(0, 0), output.fullOutput(), "<unknown>", output.getTargetLabel(), null, 16, null));
        }
        return CollectionsKt.toList((Iterable)diagnostics);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Diagnostic> deduplicate(List<Diagnostic> parsedDiagnostics) {
        void $this$mapTo$iv$iv;
        List list$iv$iv;
        Diagnostic it;
        Iterable $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = parsedDiagnostics;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (Diagnostic)element$iv$iv;
            boolean bl = false;
            Triple key$iv$iv = new Triple((Object)it.getFileLocation(), (Object)it.getMessage(), (Object)it.getPosition());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = destination$iv$iv.values();
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (List)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add((Diagnostic)CollectionsKt.first((List)((Object)it)));
        }
        return (List)destination$iv$iv;
    }

    static {
        Object[] objectArray = new Parser[]{BazelRootMessageParser.INSTANCE, CompilerDiagnosticParser.INSTANCE, Scala3CompilerDiagnosticParser.INSTANCE, AllCatchParser.INSTANCE};
        Parsers = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Regex[]{new Regex("^$"), new Regex("Use --sandbox_debug to see verbose messages from the sandbox")};
        IgnoredLines = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/bsp/bazel/server/diagnostics/DiagnosticsParserImpl$Companion;", "", "<init>", "()V", "Parsers", "", "Lorg/jetbrains/bsp/bazel/server/diagnostics/Parser;", "IgnoredLines", "Lkotlin/text/Regex;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_diagnostics-diagnostics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

