/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.diagnostics;

import ch.epfl.scala.bsp4j.PublishDiagnosticsParams;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.server.diagnostics.Diagnostic;
import org.jetbrains.bsp.bazel.server.diagnostics.DiagnosticBspMapper;
import org.jetbrains.bsp.bazel.server.diagnostics.DiagnosticsParser;
import org.jetbrains.bsp.bazel.server.diagnostics.DiagnosticsParserImpl;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/bsp/bazel/server/diagnostics/DiagnosticsService;", "", "workspaceRoot", "Ljava/nio/file/Path;", "parser", "Lorg/jetbrains/bsp/bazel/server/diagnostics/DiagnosticsParser;", "mapper", "Lorg/jetbrains/bsp/bazel/server/diagnostics/DiagnosticBspMapper;", "<init>", "(Ljava/nio/file/Path;Lorg/jetbrains/bsp/bazel/server/diagnostics/DiagnosticsParser;Lorg/jetbrains/bsp/bazel/server/diagnostics/DiagnosticBspMapper;)V", "extractDiagnostics", "", "Lch/epfl/scala/bsp4j/PublishDiagnosticsParams;", "bazelOutput", "", "targetLabel", "Lorg/jetbrains/bazel/label/Label;", "originId", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_diagnostics-diagnostics"})
public final class DiagnosticsService {
    @NotNull
    private final DiagnosticsParser parser;
    @NotNull
    private final DiagnosticBspMapper mapper;

    public DiagnosticsService(@NotNull Path workspaceRoot, @NotNull DiagnosticsParser parser, @NotNull DiagnosticBspMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)workspaceRoot, (String)"workspaceRoot");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.parser = parser;
        this.mapper = mapper;
    }

    public /* synthetic */ DiagnosticsService(Path path2, DiagnosticsParser diagnosticsParser, DiagnosticBspMapper diagnosticBspMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            diagnosticsParser = new DiagnosticsParserImpl();
        }
        if ((n & 4) != 0) {
            diagnosticBspMapper = new DiagnosticBspMapper(path2);
        }
        this(path2, diagnosticsParser, diagnosticBspMapper);
    }

    @NotNull
    public final List<PublishDiagnosticsParams> extractDiagnostics(@NotNull String bazelOutput, @NotNull Label targetLabel, @Nullable String originId) {
        Intrinsics.checkNotNullParameter((Object)bazelOutput, (String)"bazelOutput");
        Intrinsics.checkNotNullParameter((Object)targetLabel, (String)"targetLabel");
        List<Diagnostic> parsedDiagnostics = this.parser.parse(bazelOutput, targetLabel);
        List<PublishDiagnosticsParams> events = this.mapper.createDiagnostics(parsedDiagnostics, originId);
        return events;
    }
}

