/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bazel.label.Label;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u0010\u001a\u00020\u0004J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0011\u001a\u00020\fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0012\u001a\u00020\fJ\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0004R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/bsp/bazel/server/diagnostics/Output;", "", "lines", "", "", "targetLabel", "Lorg/jetbrains/bazel/label/Label;", "<init>", "(Ljava/util/List;Lorg/jetbrains/bazel/label/Label;)V", "getTargetLabel", "()Lorg/jetbrains/bazel/label/Label;", "pointer", "", "nonEmpty", "", "peek", "take", "limit", "count", "tryTake", "Lkotlin/text/MatchResult;", "regex", "Lkotlin/text/Regex;", "fullOutput", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_diagnostics-diagnostics"})
@SourceDebugExtension(value={"SMAP\nOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Output.kt\norg/jetbrains/bsp/bazel/server/diagnostics/Output\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,24:1\n1#2:25\n*E\n"})
public final class Output {
    @NotNull
    private final List<String> lines;
    @NotNull
    private final Label targetLabel;
    private int pointer;

    public Output(@NotNull List<String> lines, @NotNull Label targetLabel) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)targetLabel, (String)"targetLabel");
        this.lines = lines;
        this.targetLabel = targetLabel;
    }

    @NotNull
    public final Label getTargetLabel() {
        return this.targetLabel;
    }

    public final boolean nonEmpty() {
        return this.pointer < this.lines.size();
    }

    @Nullable
    public final String peek() {
        return (String)CollectionsKt.getOrNull(this.lines, (int)this.pointer);
    }

    @NotNull
    public final String take() {
        int n = this.pointer;
        this.pointer = n + 1;
        return this.lines.get(n);
    }

    @NotNull
    public final List<String> peek(int limit) {
        return this.lines.subList(this.pointer, RangesKt.coerceAtMost((int)(this.pointer + limit), (int)this.lines.size()));
    }

    @NotNull
    public final List<String> take(int count) {
        List<String> list;
        List<String> it = list = this.peek(count);
        boolean bl = false;
        this.pointer += count;
        return list;
    }

    @Nullable
    public final String tryTake() {
        String string;
        String string2 = this.peek();
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            this.take();
            string = string3;
        } else {
            string = null;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final MatchResult tryTake(@NotNull Regex regex) {
        String string;
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        String string2 = this.peek();
        String string3 = string2;
        if (string2 == null) return null;
        String it = string3;
        boolean bl = false;
        MatchResult matchResult = regex.matchEntire((CharSequence)it);
        string3 = matchResult;
        if (matchResult == null) return null;
        it = string = string3;
        boolean bl2 = false;
        this.take();
        String string4 = string;
        return string4;
    }

    @NotNull
    public final String fullOutput() {
        Iterable iterable = this.lines;
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
        return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
    }
}

