/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.model;

import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import ch.epfl.scala.bsp4j.TextDocumentIdentifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.server.model.AspectSyncProject;
import org.jetbrains.bsp.bazel.server.model.Module;
import org.jetbrains.bsp.bazel.server.model.Tag;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/bsp/bazel/server/model/BspMappings;", "", "<init>", "()V", "toBspId", "Lch/epfl/scala/bsp4j/BuildTargetIdentifier;", "module", "Lorg/jetbrains/bsp/bazel/server/model/Module;", "toBspTag", "", "tag", "Lorg/jetbrains/bsp/bazel/server/model/Tag;", "toBspUri", "uri", "Ljava/net/URI;", "getModules", "", "project", "Lorg/jetbrains/bsp/bazel/server/model/AspectSyncProject;", "targets", "", "toUri", "textDocument", "Lch/epfl/scala/bsp4j/TextDocumentIdentifier;", "toLabels", "Lorg/jetbrains/bazel/label/Label;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_model-model"})
@SourceDebugExtension(value={"SMAP\nBspMappings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BspMappings.kt\norg/jetbrains/bsp/bazel/server/model/BspMappings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,32:1\n1611#2,9:33\n1863#2:42\n1864#2:44\n1620#2:45\n1557#2:46\n1628#2,3:47\n1#3:43\n*S KotlinDebug\n*F\n+ 1 BspMappings.kt\norg/jetbrains/bsp/bazel/server/model/BspMappings\n*L\n25#1:33,9\n25#1:42\n25#1:44\n25#1:45\n30#1:46\n30#1:47,3\n25#1:43\n*E\n"})
public final class BspMappings {
    @NotNull
    public static final BspMappings INSTANCE = new BspMappings();

    private BspMappings() {
    }

    @NotNull
    public final BuildTargetIdentifier toBspId(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return new BuildTargetIdentifier(module.getLabel().toString());
    }

    @Nullable
    public final String toBspTag(@NotNull Tag tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        return switch (WhenMappings.$EnumSwitchMapping$0[tag.ordinal()]) {
            case 1 -> "application";
            case 2 -> "test";
            case 3 -> "library";
            case 4 -> "intellij-plugin";
            case 5 -> "no-ide";
            case 6, 7 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final String toBspUri(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Module> getModules(@NotNull AspectSyncProject project, @NotNull List<? extends BuildTargetIdentifier> targets2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        Iterable $this$mapNotNull$iv = this.toLabels(targets2);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Module it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Label p0 = (Label)element$iv$iv;
            boolean bl2 = false;
            if (project.findModule(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final URI toUri(@NotNull TextDocumentIdentifier textDocument) {
        Intrinsics.checkNotNullParameter((Object)textDocument, (String)"textDocument");
        URI uRI = URI.create(textDocument.getUri());
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        return uRI;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Label> toLabels(@NotNull List<? extends BuildTargetIdentifier> targets2) {
        String p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        Iterable $this$map$iv = targets2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BuildTargetIdentifier buildTargetIdentifier = (BuildTargetIdentifier)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getUri());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(Label.Companion.parse((String)it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Tag.values().length];
            try {
                nArray[Tag.APPLICATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tag.TEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tag.LIBRARY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tag.INTELLIJ_PLUGIN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tag.NO_IDE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tag.NO_BUILD.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tag.MANUAL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

