/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.paths;

import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.bazelrunner.utils.BazelInfo;
import org.jetbrains.bsp.bazel.info.BspTargetInfo;
import org.jetbrains.bsp.bazel.server.paths.BazelPathsResolver;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010\u000e\u001a\u00020\bJ\u0006\u0010\u000f\u001a\u00020\tJ$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000bJ\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000bJ\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u000e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bJ\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0018\u0010\"\u001a\u00020\t2\u0006\u0010\r\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020\u0014J\u000e\u0010%\u001a\u00020\b2\u0006\u0010\r\u001a\u00020#J\u000e\u0010&\u001a\u00020\b2\u0006\u0010\r\u001a\u00020#J\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020#2\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u0017\u001a\u00020*2\u0006\u0010\r\u001a\u00020#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;", "", "bazelInfo", "Lorg/jetbrains/bsp/bazel/bazelrunner/utils/BazelInfo;", "<init>", "(Lorg/jetbrains/bsp/bazel/bazelrunner/utils/BazelInfo;)V", "uris", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "Ljava/net/URI;", "paths", "Lorg/jetbrains/bsp/bazel/info/BspTargetInfo$FileLocation;", "resolveUri", "path", "unresolvedWorkspaceRoot", "workspaceRoot", "resolveUris", "", "fileLocations", "shouldFilterExisting", "", "resolvePaths", "fileLocation", "resolve", "doResolve", "isAbsolute", "resolveAbsolute", "resolveExternal", "outputBaseRelativePath", "resolveOutput", "execRootRelativePath", "resolveSource", "isMainWorkspaceSource", "isInExternalWorkspace", "pathToDirectoryUri", "", "isWorkspace", "relativePathToWorkspaceAbsolute", "relativePathToExecRootAbsolute", "clear", "", "getWorkspaceRelativePath", "Ljava/io/File;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_paths-paths"})
@SourceDebugExtension(value={"SMAP\nBazelPathsResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazelPathsResolver.kt\norg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1557#2:115\n1628#2,3:116\n774#2:119\n865#2,2:120\n1557#2:122\n1628#2,3:123\n*S KotlinDebug\n*F\n+ 1 BazelPathsResolver.kt\norg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver\n*L\n28#1:115\n28#1:116,3\n29#1:119\n29#1:120,2\n31#1:122\n31#1:123,3\n*E\n"})
public final class BazelPathsResolver {
    @NotNull
    private final BazelInfo bazelInfo;
    @NotNull
    private final ConcurrentHashMap<Path, URI> uris;
    @NotNull
    private final ConcurrentHashMap<BspTargetInfo.FileLocation, Path> paths;

    public BazelPathsResolver(@NotNull BazelInfo bazelInfo) {
        Intrinsics.checkNotNullParameter((Object)bazelInfo, (String)"bazelInfo");
        this.bazelInfo = bazelInfo;
        this.uris = new ConcurrentHashMap();
        this.paths = new ConcurrentHashMap();
    }

    @NotNull
    public final URI resolveUri(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Function1 function1 = resolveUri.1.INSTANCE;
        URI uRI = this.uris.computeIfAbsent(path2, new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"computeIfAbsent(...)");
        return uRI;
    }

    @NotNull
    public final Path unresolvedWorkspaceRoot() {
        return this.bazelInfo.getWorkspaceRoot();
    }

    @NotNull
    public final URI workspaceRoot() {
        Path path2 = this.bazelInfo.getWorkspaceRoot().toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        return this.resolveUri(path2);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<URI> resolveUris(@NotNull List<BspTargetInfo.FileLocation> fileLocations, boolean shouldFilterExisting) {
        Intrinsics.checkNotNullParameter(fileLocations, (String)"fileLocations");
        $this$map$iv = fileLocations;
        $i$f$map = false;
        var5_5 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var10_10 = (BspTargetInfo.FileLocation)item$iv$iv;
            var12_12 = destination$iv$iv;
            $i$a$-map-BazelPathsResolver$resolveUris$1 = false;
            var12_12.add(this.resolveUri((BspTargetInfo.FileLocation)p0));
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (URI)element$iv$iv;
            $i$a$-filter-BazelPathsResolver$resolveUris$2 = false;
            if (!shouldFilterExisting) ** GOTO lbl-1000
            v0 = Paths.get(it);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"get(...)");
            v1 = new LinkOption[]{};
            if (Files.exists(v0, Arrays.copyOf(v1, v1.length))) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List resolveUris$default(BazelPathsResolver bazelPathsResolver, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return bazelPathsResolver.resolveUris(list, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Path> resolvePaths(@NotNull List<BspTargetInfo.FileLocation> fileLocations) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(fileLocations, (String)"fileLocations");
        Iterable $this$map$iv = fileLocations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            BspTargetInfo.FileLocation fileLocation = (BspTargetInfo.FileLocation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.resolve((BspTargetInfo.FileLocation)p0));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final URI resolveUri(@NotNull BspTargetInfo.FileLocation fileLocation) {
        Intrinsics.checkNotNullParameter((Object)fileLocation, (String)"fileLocation");
        return this.resolveUri(this.resolve(fileLocation));
    }

    @NotNull
    public final Path resolve(@NotNull BspTargetInfo.FileLocation fileLocation) {
        Intrinsics.checkNotNullParameter((Object)fileLocation, (String)"fileLocation");
        Function1 function1 = (Function1)new Function1<BspTargetInfo.FileLocation, Path>((Object)this){

            public final Path invoke(BspTargetInfo.FileLocation p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return BazelPathsResolver.access$doResolve((BazelPathsResolver)this.receiver, p0);
            }
        };
        Path path2 = this.paths.computeIfAbsent(fileLocation, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"computeIfAbsent(...)");
        return path2;
    }

    private final Path doResolve(BspTargetInfo.FileLocation fileLocation) {
        return this.isAbsolute(fileLocation) ? this.resolveAbsolute(fileLocation) : (this.isMainWorkspaceSource(fileLocation) ? this.resolveSource(fileLocation) : (this.isInExternalWorkspace(fileLocation) ? this.resolveExternal(fileLocation) : this.resolveOutput(fileLocation)));
    }

    private final boolean isAbsolute(BspTargetInfo.FileLocation fileLocation) {
        String relative = fileLocation.getRelativePath();
        Intrinsics.checkNotNull((Object)relative);
        return StringsKt.startsWith$default((String)relative, (String)"/", (boolean)false, (int)2, null) && Files.exists(Paths.get(relative, new String[0]), new LinkOption[0]);
    }

    private final Path resolveAbsolute(BspTargetInfo.FileLocation fileLocation) {
        Path path2 = Paths.get(fileLocation.getRelativePath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        return path2;
    }

    private final Path resolveExternal(BspTargetInfo.FileLocation fileLocation) {
        String[] stringArray = new String[]{fileLocation.getRelativePath()};
        Path outputBaseRelativePath = Paths.get(fileLocation.getRootExecutionPathFragment(), stringArray);
        Intrinsics.checkNotNull((Object)outputBaseRelativePath);
        return this.resolveExternal(outputBaseRelativePath);
    }

    private final Path resolveExternal(Path outputBaseRelativePath) {
        Path path2 = this.bazelInfo.getOutputBase().resolve(outputBaseRelativePath);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    private final Path resolveOutput(BspTargetInfo.FileLocation fileLocation) {
        String[] stringArray = new String[]{fileLocation.getRelativePath()};
        Path execRootRelativePath = Paths.get(fileLocation.getRootExecutionPathFragment(), stringArray);
        Intrinsics.checkNotNull((Object)execRootRelativePath);
        return this.resolveOutput(execRootRelativePath);
    }

    @NotNull
    public final Path resolveOutput(@NotNull Path execRootRelativePath) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)execRootRelativePath, (String)"execRootRelativePath");
        if (execRootRelativePath.startsWith("external")) {
            path2 = this.resolveExternal(execRootRelativePath);
        } else {
            Path path3 = Paths.get(this.bazelInfo.getExecRoot(), new String[0]).resolve(execRootRelativePath);
            path2 = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        }
        return path2;
    }

    private final Path resolveSource(BspTargetInfo.FileLocation fileLocation) {
        Path path2 = this.bazelInfo.getWorkspaceRoot().resolve(fileLocation.getRelativePath());
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    private final boolean isMainWorkspaceSource(BspTargetInfo.FileLocation fileLocation) {
        return fileLocation.getIsSource() && !fileLocation.getIsExternal();
    }

    private final boolean isInExternalWorkspace(BspTargetInfo.FileLocation fileLocation) {
        String string = fileLocation.getRootExecutionPathFragment();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRootExecutionPathFragment(...)");
        return StringsKt.startsWith$default((String)string, (String)"external/", (boolean)false, (int)2, null);
    }

    @NotNull
    public final URI pathToDirectoryUri(@NotNull String path2, boolean isWorkspace) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Path absolutePath = isWorkspace ? this.relativePathToWorkspaceAbsolute(path2) : this.relativePathToExecRootAbsolute(path2);
        return this.resolveUri(absolutePath);
    }

    public static /* synthetic */ URI pathToDirectoryUri$default(BazelPathsResolver bazelPathsResolver, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return bazelPathsResolver.pathToDirectoryUri(string, bl);
    }

    @NotNull
    public final Path relativePathToWorkspaceAbsolute(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Path path3 = this.bazelInfo.getWorkspaceRoot().resolve(path2);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        return path3;
    }

    @NotNull
    public final Path relativePathToExecRootAbsolute(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String[] stringArray = new String[]{path2};
        Path path3 = Paths.get(this.bazelInfo.getExecRoot(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        return path3;
    }

    public final void clear() {
        this.uris.clear();
        this.paths.clear();
    }

    @NotNull
    public final String getWorkspaceRelativePath(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string = ((Object)this.bazelInfo.getWorkspaceRoot().relativize(path2)).toString();
        String string2 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
        return StringsKt.replace$default((String)string, (String)string2, (String)"/", (boolean)false, (int)4, null);
    }

    @NotNull
    public final File resolve(@NotNull String path2) {
        File file;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        if (Paths.get(path2, new String[0]).isAbsolute()) {
            file = new File(path2);
        } else if (StringsKt.startsWith$default((String)path2, (String)"external/", (boolean)false, (int)2, null)) {
            File file2 = this.bazelInfo.getOutputBase().resolve(path2).toFile();
            file = file2;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        } else {
            File file3 = this.bazelInfo.getWorkspaceRoot().resolve(path2).toFile();
            file = file3;
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
        }
        return file;
    }

    public static final /* synthetic */ Path access$doResolve(BazelPathsResolver $this, BspTargetInfo.FileLocation fileLocation) {
        return $this.doResolve(fileLocation);
    }
}

