/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.sync;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.bazelrunner.BazelCommand;
import org.jetbrains.bsp.bazel.bazelrunner.BazelProcessResult;
import org.jetbrains.bsp.bazel.bazelrunner.BazelRunner;
import org.jetbrains.bsp.bazel.server.bsp.info.BspInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/ClasspathQuery;", "", "<init>", "()V", "classPathQuery", "Lorg/jetbrains/bsp/bazel/server/sync/ClasspathQuery$JvmClasspath;", "target", "Lorg/jetbrains/bazel/label/Label;", "cancelChecker", "Lorg/eclipse/lsp4j/jsonrpc/CancelChecker;", "bspInfo", "Lorg/jetbrains/bsp/bazel/server/bsp/info/BspInfo;", "bazelRunner", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelRunner;", "JvmClasspath", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync-sync"})
@SourceDebugExtension(value={"SMAP\nClasspathQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClasspathQuery.kt\norg/jetbrains/bsp/bazel/server/sync/ClasspathQuery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1557#2:47\n1628#2,3:48\n1971#2,14:51\n*S KotlinDebug\n*F\n+ 1 ClasspathQuery.kt\norg/jetbrains/bsp/bazel/server/sync/ClasspathQuery\n*L\n36#1:47\n36#1:48,3\n37#1:51,14\n*E\n"})
public final class ClasspathQuery {
    @NotNull
    public static final ClasspathQuery INSTANCE = new ClasspathQuery();

    private ClasspathQuery() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JvmClasspath classPathQuery(@NotNull Label target, @NotNull CancelChecker cancelChecker, @NotNull BspInfo bspInfo, @NotNull BazelRunner bazelRunner) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)bspInfo, (String)"bspInfo");
        Intrinsics.checkNotNullParameter((Object)bazelRunner, (String)"bazelRunner");
        Path queryFile = bspInfo.bazelBspDir().resolve("aspects/runtime_classpath_query.bzl");
        BazelCommand command2 = bazelRunner.buildBazelCommand(true, (Function1<? super BazelRunner.CommandBuilder, ? extends BazelCommand>)((Function1)new Function1<BazelRunner.CommandBuilder, BazelCommand>(target, queryFile){
            final /* synthetic */ Label $target;
            final /* synthetic */ Path $queryFile;
            {
                this.$target = $target;
                this.$queryFile = $queryFile;
                super(1);
            }

            public final BazelCommand invoke(BazelRunner.CommandBuilder $this$buildBazelCommand) {
                Intrinsics.checkNotNullParameter((Object)$this$buildBazelCommand, (String)"$this$buildBazelCommand");
                return $this$buildBazelCommand.cquery((Function1<? super BazelCommand.CQuery, Unit>)((Function1)new Function1<BazelCommand.CQuery, Unit>(this.$target, this.$queryFile){
                    final /* synthetic */ Label $target;
                    final /* synthetic */ Path $queryFile;
                    {
                        this.$target = $target;
                        this.$queryFile = $queryFile;
                        super(1);
                    }

                    public final void invoke(BazelCommand.CQuery $this$cquery) {
                        Intrinsics.checkNotNullParameter((Object)$this$cquery, (String)"$this$cquery");
                        $this$cquery.getTargets().add(this.$target);
                        Object[] objectArray = new String[]{"--starlark:file=" + this.$queryFile, "--output=starlark"};
                        $this$cquery.getOptions().addAll(CollectionsKt.listOf((Object[])objectArray));
                    }
                }));
            }
        }));
        BazelProcessResult cqueryResult = BazelRunner.runBazelCommand$default(bazelRunner, command2, null, false, null, false, 18, null).waitAndGetResult(cancelChecker, true);
        if (cqueryResult.isNotSuccess()) {
            throw new RuntimeException("Could not query target '" + target + "' for runtime classpath");
        }
        try {
            JvmClasspath classpaths = (JvmClasspath)new Gson().fromJson(cqueryResult.getStdout(), JvmClasspath.class);
            Intrinsics.checkNotNull((Object)classpaths);
            return classpaths;
        }
        catch (JsonSyntaxException e) {
            Object v0;
            if (cqueryResult.getStdoutLines().size() > 1) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = cqueryResult.getStdoutLines();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((JvmClasspath)new Gson().fromJson((String)it, JvmClasspath.class));
                }
                List allOpts = (List)destination$iv$iv;
                Iterable $this$maxByOrNull$iv = allOpts;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = maxElem$iv;
                    } else {
                        JvmClasspath it = (JvmClasspath)maxElem$iv;
                        boolean bl = false;
                        int maxValue$iv = it.getRuntime_classpath().size() + it.getCompile_classpath().size();
                        do {
                            Object e$iv = iterator$iv.next();
                            JvmClasspath it2 = (JvmClasspath)e$iv;
                            $i$a$-maxByOrNull-ClasspathQuery$classPathQuery$1 = false;
                            int v$iv = it2.getRuntime_classpath().size() + it2.getCompile_classpath().size();
                            if (maxValue$iv >= v$iv) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = maxElem$iv;
                    }
                }
            } else {
                throw e;
            }
            Intrinsics.checkNotNull(v0);
            return v0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/ClasspathQuery$JvmClasspath;", "", "runtime_classpath", "", "", "compile_classpath", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getRuntime_classpath", "()Ljava/util/List;", "getCompile_classpath", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync-sync"})
    public static final class JvmClasspath {
        @NotNull
        private final List<String> runtime_classpath;
        @NotNull
        private final List<String> compile_classpath;

        public JvmClasspath(@NotNull List<String> runtime_classpath, @NotNull List<String> compile_classpath) {
            Intrinsics.checkNotNullParameter(runtime_classpath, (String)"runtime_classpath");
            Intrinsics.checkNotNullParameter(compile_classpath, (String)"compile_classpath");
            this.runtime_classpath = runtime_classpath;
            this.compile_classpath = compile_classpath;
        }

        @NotNull
        public final List<String> getRuntime_classpath() {
            return this.runtime_classpath;
        }

        @NotNull
        public final List<String> getCompile_classpath() {
            return this.compile_classpath;
        }

        @NotNull
        public final List<String> component1() {
            return this.runtime_classpath;
        }

        @NotNull
        public final List<String> component2() {
            return this.compile_classpath;
        }

        @NotNull
        public final JvmClasspath copy(@NotNull List<String> runtime_classpath, @NotNull List<String> compile_classpath) {
            Intrinsics.checkNotNullParameter(runtime_classpath, (String)"runtime_classpath");
            Intrinsics.checkNotNullParameter(compile_classpath, (String)"compile_classpath");
            return new JvmClasspath(runtime_classpath, compile_classpath);
        }

        public static /* synthetic */ JvmClasspath copy$default(JvmClasspath jvmClasspath, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = jvmClasspath.runtime_classpath;
            }
            if ((n & 2) != 0) {
                list2 = jvmClasspath.compile_classpath;
            }
            return jvmClasspath.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "JvmClasspath(runtime_classpath=" + this.runtime_classpath + ", compile_classpath=" + this.compile_classpath + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.runtime_classpath).hashCode();
            result2 = result2 * 31 + ((Object)this.compile_classpath).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JvmClasspath)) {
                return false;
            }
            JvmClasspath jvmClasspath = (JvmClasspath)other;
            if (!Intrinsics.areEqual(this.runtime_classpath, jvmClasspath.runtime_classpath)) {
                return false;
            }
            return Intrinsics.areEqual(this.compile_classpath, jvmClasspath.compile_classpath);
        }
    }
}

