/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.sync;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bsp.bazel.bazelrunner.params.BazelFlag;
import org.jetbrains.bsp.bazel.server.model.Module;
import org.jetbrains.bsp.bazel.server.model.ModuleKt;
import org.jetbrains.bsp.bazel.server.sync.DebugType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010\u000f\u001a\u00020\u00102\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/DebugHelper;", "", "<init>", "()V", "jdwpArgument", "", "port", "", "generateRunArguments", "", "debugType", "Lorg/jetbrains/bsp/bazel/server/sync/DebugType;", "generateRunOptions", "buildBeforeRun", "", "verifyDebugRequest", "", "moduleToRun", "Lorg/jetbrains/bsp/bazel/server/model/Module;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync-sync"})
public final class DebugHelper {
    @NotNull
    public static final DebugHelper INSTANCE = new DebugHelper();

    private DebugHelper() {
    }

    @NotNull
    public final String jdwpArgument(int port) {
        return "--wrapper_script_flag=--jvm_flag=-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=localhost:" + port;
    }

    @NotNull
    public final List<String> generateRunArguments(@Nullable DebugType debugType) {
        return debugType instanceof DebugType.JDWP ? CollectionsKt.listOf((Object)this.jdwpArgument(((DebugType.JDWP)debugType).getPort())) : CollectionsKt.emptyList();
    }

    @NotNull
    public final List<String> generateRunOptions(@Nullable DebugType debugType) {
        List list;
        if (debugType instanceof DebugType.GoDlv) {
            Object[] objectArray = new String[]{BazelFlag.runUnder("dlv --listen=127.0.0.1:" + ((DebugType.GoDlv)debugType).getPort() + " --headless=true --api-version=2 --check-go-version=false --only-same-user=false exec"), "--compilation_mode=dbg", "--dynamic_mode=off"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean buildBeforeRun(@Nullable DebugType debugType) {
        return !(debugType instanceof DebugType.GoDlv);
    }

    public final void verifyDebugRequest(@Nullable DebugType debugType, @NotNull Module moduleToRun) {
        Intrinsics.checkNotNullParameter((Object)moduleToRun, (String)"moduleToRun");
        DebugType debugType2 = debugType;
        if (debugType2 != null) {
            if (debugType2 instanceof DebugType.JDWP) {
                if (!ModuleKt.isJvmLanguages(moduleToRun)) {
                    throw new RuntimeException("JDWP debugging is only available for Java and Kotlin targets");
                }
            } else if (!(debugType2 instanceof DebugType.GoDlv)) {
                if (debugType2 instanceof DebugType.UNKNOWN) {
                    throw new RuntimeException("Unknown debug type: " + ((DebugType.UNKNOWN)debugType).getName());
                }
                throw new NoWhenBranchMatchedException();
            }
        }
    }
}

