/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.sync;

import ch.epfl.scala.bsp4j.BuildClientCapabilities;
import ch.epfl.scala.bsp4j.CppOptionsParams;
import ch.epfl.scala.bsp4j.CppOptionsResult;
import ch.epfl.scala.bsp4j.DependencyModulesParams;
import ch.epfl.scala.bsp4j.DependencyModulesResult;
import ch.epfl.scala.bsp4j.DependencySourcesParams;
import ch.epfl.scala.bsp4j.DependencySourcesResult;
import ch.epfl.scala.bsp4j.InitializeBuildResult;
import ch.epfl.scala.bsp4j.InverseSourcesParams;
import ch.epfl.scala.bsp4j.InverseSourcesResult;
import ch.epfl.scala.bsp4j.JavacOptionsParams;
import ch.epfl.scala.bsp4j.JavacOptionsResult;
import ch.epfl.scala.bsp4j.JvmCompileClasspathParams;
import ch.epfl.scala.bsp4j.JvmCompileClasspathResult;
import ch.epfl.scala.bsp4j.JvmRunEnvironmentParams;
import ch.epfl.scala.bsp4j.JvmRunEnvironmentResult;
import ch.epfl.scala.bsp4j.JvmTestEnvironmentParams;
import ch.epfl.scala.bsp4j.JvmTestEnvironmentResult;
import ch.epfl.scala.bsp4j.OutputPathsParams;
import ch.epfl.scala.bsp4j.OutputPathsResult;
import ch.epfl.scala.bsp4j.PythonOptionsParams;
import ch.epfl.scala.bsp4j.PythonOptionsResult;
import ch.epfl.scala.bsp4j.ResourcesParams;
import ch.epfl.scala.bsp4j.ResourcesResult;
import ch.epfl.scala.bsp4j.RustWorkspaceParams;
import ch.epfl.scala.bsp4j.RustWorkspaceResult;
import ch.epfl.scala.bsp4j.ScalaMainClassesParams;
import ch.epfl.scala.bsp4j.ScalaMainClassesResult;
import ch.epfl.scala.bsp4j.ScalaTestClassesParams;
import ch.epfl.scala.bsp4j.ScalaTestClassesResult;
import ch.epfl.scala.bsp4j.ScalacOptionsParams;
import ch.epfl.scala.bsp4j.ScalacOptionsResult;
import ch.epfl.scala.bsp4j.SourcesParams;
import ch.epfl.scala.bsp4j.SourcesResult;
import ch.epfl.scala.bsp4j.WorkspaceBuildTargetsResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.server.model.AspectSyncProject;
import org.jetbrains.bsp.bazel.server.model.FirstPhaseProject;
import org.jetbrains.bsp.bazel.server.model.Language;
import org.jetbrains.bsp.bazel.server.model.Project;
import org.jetbrains.bsp.bazel.server.sync.BspProjectMapper;
import org.jetbrains.bsp.bazel.server.sync.ProjectProvider;
import org.jetbrains.bsp.bazel.server.sync.firstPhase.FirstPhaseTargetToBspMapper;
import org.jetbrains.bsp.protocol.BazelResolveLocalToRemoteParams;
import org.jetbrains.bsp.protocol.BazelResolveLocalToRemoteResult;
import org.jetbrains.bsp.protocol.BazelResolveRemoteToLocalParams;
import org.jetbrains.bsp.protocol.BazelResolveRemoteToLocalResult;
import org.jetbrains.bsp.protocol.JvmBinaryJarsParams;
import org.jetbrains.bsp.protocol.JvmBinaryJarsResult;
import org.jetbrains.bsp.protocol.NonModuleTargetsResult;
import org.jetbrains.bsp.protocol.WorkspaceBazelRepoMappingResult;
import org.jetbrains.bsp.protocol.WorkspaceBuildTargetsFirstPhaseParams;
import org.jetbrains.bsp.protocol.WorkspaceDirectoriesResult;
import org.jetbrains.bsp.protocol.WorkspaceGoLibrariesResult;
import org.jetbrains.bsp.protocol.WorkspaceInvalidTargetsResult;
import org.jetbrains.bsp.protocol.WorkspaceLibrariesResult;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u0016\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010(\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+J\u0016\u0010,\u001a\u00020-2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/J\u0016\u00100\u001a\u0002012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00102\u001a\u000203J\u0016\u00104\u001a\u0002052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00106\u001a\u000207J\u0016\u00108\u001a\u0002092\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020:J\u0016\u0010;\u001a\u00020<2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020=J\u0016\u0010>\u001a\u00020?2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020@J\u0016\u0010A\u001a\u00020B2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020CJ\u0016\u0010D\u001a\u00020E2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020FJ\u0016\u0010G\u001a\u00020H2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020IJ\u0016\u0010J\u001a\u00020K2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020LJ\u0016\u0010M\u001a\u00020N2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020OJ\u0016\u0010P\u001a\u00020Q2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020RJ\u0016\u0010S\u001a\u00020T2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020UJ\u0016\u0010V\u001a\u00020W2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020XJ\u0016\u0010Y\u001a\u00020Z2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020[J\u0016\u0010\\\u001a\u00020]2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020^J\u0016\u0010_\u001a\u00020`2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020aJ\u0016\u0010b\u001a\u00020c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/ProjectSyncService;", "", "bspMapper", "Lorg/jetbrains/bsp/bazel/server/sync/BspProjectMapper;", "firstPhaseTargetToBspMapper", "Lorg/jetbrains/bsp/bazel/server/sync/firstPhase/FirstPhaseTargetToBspMapper;", "projectProvider", "Lorg/jetbrains/bsp/bazel/server/sync/ProjectProvider;", "clientCapabilities", "Lch/epfl/scala/bsp4j/BuildClientCapabilities;", "<init>", "(Lorg/jetbrains/bsp/bazel/server/sync/BspProjectMapper;Lorg/jetbrains/bsp/bazel/server/sync/firstPhase/FirstPhaseTargetToBspMapper;Lorg/jetbrains/bsp/bazel/server/sync/ProjectProvider;Lch/epfl/scala/bsp4j/BuildClientCapabilities;)V", "initialize", "Lch/epfl/scala/bsp4j/InitializeBuildResult;", "workspaceReload", "cancelChecker", "Lorg/eclipse/lsp4j/jsonrpc/CancelChecker;", "workspaceBuildTargets", "Lch/epfl/scala/bsp4j/WorkspaceBuildTargetsResult;", "build", "", "workspaceBuildTargetsPartial", "targetsToSync", "", "Lorg/jetbrains/bazel/label/Label;", "workspaceBuildFirstPhase", "params", "Lorg/jetbrains/bsp/protocol/WorkspaceBuildTargetsFirstPhaseParams;", "workspaceBuildLibraries", "Lorg/jetbrains/bsp/protocol/WorkspaceLibrariesResult;", "workspaceBuildGoLibraries", "Lorg/jetbrains/bsp/protocol/WorkspaceGoLibrariesResult;", "workspaceNonModuleTargets", "Lorg/jetbrains/bsp/protocol/NonModuleTargetsResult;", "workspaceDirectories", "Lorg/jetbrains/bsp/protocol/WorkspaceDirectoriesResult;", "workspaceInvalidTargets", "Lorg/jetbrains/bsp/protocol/WorkspaceInvalidTargetsResult;", "workspaceBazelRepoMapping", "Lorg/jetbrains/bsp/protocol/WorkspaceBazelRepoMappingResult;", "buildTargetSources", "Lch/epfl/scala/bsp4j/SourcesResult;", "sourcesParams", "Lch/epfl/scala/bsp4j/SourcesParams;", "buildTargetResources", "Lch/epfl/scala/bsp4j/ResourcesResult;", "resourcesParams", "Lch/epfl/scala/bsp4j/ResourcesParams;", "buildTargetInverseSources", "Lch/epfl/scala/bsp4j/InverseSourcesResult;", "inverseSourcesParams", "Lch/epfl/scala/bsp4j/InverseSourcesParams;", "buildTargetDependencySources", "Lch/epfl/scala/bsp4j/DependencySourcesResult;", "dependencySourcesParams", "Lch/epfl/scala/bsp4j/DependencySourcesParams;", "buildTargetOutputPaths", "Lch/epfl/scala/bsp4j/OutputPathsResult;", "Lch/epfl/scala/bsp4j/OutputPathsParams;", "jvmRunEnvironment", "Lch/epfl/scala/bsp4j/JvmRunEnvironmentResult;", "Lch/epfl/scala/bsp4j/JvmRunEnvironmentParams;", "jvmTestEnvironment", "Lch/epfl/scala/bsp4j/JvmTestEnvironmentResult;", "Lch/epfl/scala/bsp4j/JvmTestEnvironmentParams;", "jvmBinaryJars", "Lorg/jetbrains/bsp/protocol/JvmBinaryJarsResult;", "Lorg/jetbrains/bsp/protocol/JvmBinaryJarsParams;", "jvmCompileClasspath", "Lch/epfl/scala/bsp4j/JvmCompileClasspathResult;", "Lch/epfl/scala/bsp4j/JvmCompileClasspathParams;", "buildTargetJavacOptions", "Lch/epfl/scala/bsp4j/JavacOptionsResult;", "Lch/epfl/scala/bsp4j/JavacOptionsParams;", "buildTargetCppOptions", "Lch/epfl/scala/bsp4j/CppOptionsResult;", "Lch/epfl/scala/bsp4j/CppOptionsParams;", "buildTargetPythonOptions", "Lch/epfl/scala/bsp4j/PythonOptionsResult;", "Lch/epfl/scala/bsp4j/PythonOptionsParams;", "buildTargetScalacOptions", "Lch/epfl/scala/bsp4j/ScalacOptionsResult;", "Lch/epfl/scala/bsp4j/ScalacOptionsParams;", "buildTargetScalaTestClasses", "Lch/epfl/scala/bsp4j/ScalaTestClassesResult;", "Lch/epfl/scala/bsp4j/ScalaTestClassesParams;", "buildTargetScalaMainClasses", "Lch/epfl/scala/bsp4j/ScalaMainClassesResult;", "Lch/epfl/scala/bsp4j/ScalaMainClassesParams;", "buildTargetDependencyModules", "Lch/epfl/scala/bsp4j/DependencyModulesResult;", "Lch/epfl/scala/bsp4j/DependencyModulesParams;", "rustWorkspace", "Lch/epfl/scala/bsp4j/RustWorkspaceResult;", "Lch/epfl/scala/bsp4j/RustWorkspaceParams;", "resolveLocalToRemote", "Lorg/jetbrains/bsp/protocol/BazelResolveLocalToRemoteResult;", "Lorg/jetbrains/bsp/protocol/BazelResolveLocalToRemoteParams;", "resolveRemoteToLocal", "Lorg/jetbrains/bsp/protocol/BazelResolveRemoteToLocalResult;", "Lorg/jetbrains/bsp/protocol/BazelResolveRemoteToLocalParams;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync-sync"})
public final class ProjectSyncService {
    @NotNull
    private final BspProjectMapper bspMapper;
    @NotNull
    private final FirstPhaseTargetToBspMapper firstPhaseTargetToBspMapper;
    @NotNull
    private final ProjectProvider projectProvider;
    @NotNull
    private final BuildClientCapabilities clientCapabilities;

    public ProjectSyncService(@NotNull BspProjectMapper bspMapper, @NotNull FirstPhaseTargetToBspMapper firstPhaseTargetToBspMapper, @NotNull ProjectProvider projectProvider, @NotNull BuildClientCapabilities clientCapabilities) {
        Intrinsics.checkNotNullParameter((Object)bspMapper, (String)"bspMapper");
        Intrinsics.checkNotNullParameter((Object)firstPhaseTargetToBspMapper, (String)"firstPhaseTargetToBspMapper");
        Intrinsics.checkNotNullParameter((Object)projectProvider, (String)"projectProvider");
        Intrinsics.checkNotNullParameter((Object)clientCapabilities, (String)"clientCapabilities");
        this.bspMapper = bspMapper;
        this.firstPhaseTargetToBspMapper = firstPhaseTargetToBspMapper;
        this.projectProvider = projectProvider;
        this.clientCapabilities = clientCapabilities;
    }

    @NotNull
    public final InitializeBuildResult initialize() {
        return this.bspMapper.initializeServer(Language.Companion.all());
    }

    @NotNull
    public final Object workspaceReload(@NotNull CancelChecker cancelChecker) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        return new Object();
    }

    @NotNull
    public final WorkspaceBuildTargetsResult workspaceBuildTargets(@NotNull CancelChecker cancelChecker, boolean build2) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        AspectSyncProject project = this.projectProvider.refreshAndGet(cancelChecker, build2);
        return this.bspMapper.workspaceTargets(project);
    }

    @NotNull
    public final WorkspaceBuildTargetsResult workspaceBuildTargetsPartial(@NotNull CancelChecker cancelChecker, @NotNull List<? extends Label> targetsToSync) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter(targetsToSync, (String)"targetsToSync");
        AspectSyncProject project = this.projectProvider.updateAndGet(cancelChecker, targetsToSync);
        return this.bspMapper.workspaceTargets(project);
    }

    @NotNull
    public final WorkspaceBuildTargetsResult workspaceBuildFirstPhase(@NotNull CancelChecker cancelChecker, @NotNull WorkspaceBuildTargetsFirstPhaseParams params) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        FirstPhaseProject project = this.projectProvider.bazelQueryRefreshAndGet(cancelChecker, params.getOriginId());
        return this.firstPhaseTargetToBspMapper.toWorkspaceBuildTargetsResult(project);
    }

    @NotNull
    public final WorkspaceLibrariesResult workspaceBuildLibraries(@NotNull CancelChecker cancelChecker) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Project project = this.projectProvider.get(cancelChecker);
        AspectSyncProject aspectSyncProject = project instanceof AspectSyncProject ? (AspectSyncProject)project : null;
        if (aspectSyncProject == null) {
            return new WorkspaceLibrariesResult(CollectionsKt.emptyList());
        }
        AspectSyncProject project2 = aspectSyncProject;
        return this.bspMapper.workspaceLibraries(project2);
    }

    @NotNull
    public final WorkspaceGoLibrariesResult workspaceBuildGoLibraries(@NotNull CancelChecker cancelChecker) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Project project = this.projectProvider.get(cancelChecker);
        AspectSyncProject aspectSyncProject = project instanceof AspectSyncProject ? (AspectSyncProject)project : null;
        if (aspectSyncProject == null) {
            return new WorkspaceGoLibrariesResult(CollectionsKt.emptyList());
        }
        AspectSyncProject project2 = aspectSyncProject;
        return this.bspMapper.workspaceGoLibraries(project2);
    }

    @NotNull
    public final NonModuleTargetsResult workspaceNonModuleTargets(@NotNull CancelChecker cancelChecker) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Project project = this.projectProvider.get(cancelChecker);
        AspectSyncProject aspectSyncProject = project instanceof AspectSyncProject ? (AspectSyncProject)project : null;
        if (aspectSyncProject == null) {
            return new NonModuleTargetsResult(CollectionsKt.emptyList());
        }
        AspectSyncProject project2 = aspectSyncProject;
        return this.bspMapper.workspaceNonModuleTargets(project2);
    }

    @NotNull
    public final WorkspaceDirectoriesResult workspaceDirectories(@NotNull CancelChecker cancelChecker) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Project project = this.projectProvider.get(cancelChecker);
        return this.bspMapper.workspaceDirectories(project);
    }

    @NotNull
    public final WorkspaceInvalidTargetsResult workspaceInvalidTargets(@NotNull CancelChecker cancelChecker) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        return new WorkspaceInvalidTargetsResult(CollectionsKt.emptyList());
    }

    @NotNull
    public final WorkspaceBazelRepoMappingResult workspaceBazelRepoMapping(@NotNull CancelChecker cancelChecker) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Project project = this.projectProvider.get(cancelChecker);
        return this.bspMapper.workspaceBazelRepoMapping(project);
    }

    @NotNull
    public final SourcesResult buildTargetSources(@NotNull CancelChecker cancelChecker, @NotNull SourcesParams sourcesParams) {
        SourcesResult sourcesResult;
        Project project;
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)sourcesParams, (String)"sourcesParams");
        Project project2 = project = this.projectProvider.get(cancelChecker);
        if (project2 instanceof AspectSyncProject) {
            sourcesResult = this.bspMapper.sources((AspectSyncProject)project, sourcesParams);
        } else if (project2 instanceof FirstPhaseProject) {
            sourcesResult = this.firstPhaseTargetToBspMapper.toSourcesResult((FirstPhaseProject)project, sourcesParams);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sourcesResult;
    }

    @NotNull
    public final ResourcesResult buildTargetResources(@NotNull CancelChecker cancelChecker, @NotNull ResourcesParams resourcesParams) {
        ResourcesResult resourcesResult;
        Project project;
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)resourcesParams, (String)"resourcesParams");
        Project project2 = project = this.projectProvider.get(cancelChecker);
        if (project2 instanceof AspectSyncProject) {
            resourcesResult = this.bspMapper.resources((AspectSyncProject)project, resourcesParams);
        } else if (project2 instanceof FirstPhaseProject) {
            resourcesResult = this.firstPhaseTargetToBspMapper.toResourcesResult((FirstPhaseProject)project, resourcesParams);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return resourcesResult;
    }

    @NotNull
    public final InverseSourcesResult buildTargetInverseSources(@NotNull CancelChecker cancelChecker, @NotNull InverseSourcesParams inverseSourcesParams) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)inverseSourcesParams, (String)"inverseSourcesParams");
        Project project = this.projectProvider.get(cancelChecker);
        AspectSyncProject aspectSyncProject = project instanceof AspectSyncProject ? (AspectSyncProject)project : null;
        if (aspectSyncProject == null) {
            return new InverseSourcesResult(CollectionsKt.emptyList());
        }
        AspectSyncProject project2 = aspectSyncProject;
        return this.bspMapper.inverseSources(project2, inverseSourcesParams, cancelChecker);
    }

    @NotNull
    public final DependencySourcesResult buildTargetDependencySources(@NotNull CancelChecker cancelChecker, @NotNull DependencySourcesParams dependencySourcesParams) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)dependencySourcesParams, (String)"dependencySourcesParams");
        Project project = this.projectProvider.get(cancelChecker);
        AspectSyncProject aspectSyncProject = project instanceof AspectSyncProject ? (AspectSyncProject)project : null;
        if (aspectSyncProject == null) {
            return new DependencySourcesResult(CollectionsKt.emptyList());
        }
        AspectSyncProject project2 = aspectSyncProject;
        return this.bspMapper.dependencySources(project2, dependencySourcesParams);
    }

    @NotNull
    public final OutputPathsResult buildTargetOutputPaths(@NotNull CancelChecker cancelChecker, @NotNull OutputPathsParams params) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Project project = this.projectProvider.get(cancelChecker);
        AspectSyncProject aspectSyncProject = project instanceof AspectSyncProject ? (AspectSyncProject)project : null;
        if (aspectSyncProject == null) {
            return new OutputPathsResult(CollectionsKt.emptyList());
        }
        AspectSyncProject project2 = aspectSyncProject;
        return this.bspMapper.outputPaths(project2, params);
    }

    @NotNull
    public final JvmRunEnvironmentResult jvmRunEnvironment(@NotNull CancelChecker cancelChecker, @NotNull JvmRunEnvironmentParams params) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Project project = this.projectProvider.get(cancelChecker);
        AspectSyncProject aspectSyncProject = project instanceof AspectSyncProject ? (AspectSyncProject)project : null;
        if (aspectSyncProject == null) {
            return new JvmRunEnvironmentResult(CollectionsKt.emptyList());
        }
        AspectSyncProject project2 = aspectSyncProject;
        return this.bspMapper.jvmRunEnvironment(project2, params, cancelChecker);
    }

    @NotNull
    public final JvmTestEnvironmentResult jvmTestEnvironment(@NotNull CancelChecker cancelChecker, @NotNull JvmTestEnvironmentParams params) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Project project = this.projectProvider.get(cancelChecker);
        AspectSyncProject aspectSyncProject = project instanceof AspectSyncProject ? (AspectSyncProject)project : null;
        if (aspectSyncProject == null) {
            return new JvmTestEnvironmentResult(CollectionsKt.emptyList());
        }
        AspectSyncProject project2 = aspectSyncProject;
        return this.bspMapper.jvmTestEnvironment(project2, params, cancelChecker);
    }

    @NotNull
    public final JvmBinaryJarsResult jvmBinaryJars(@NotNull CancelChecker cancelChecker, @NotNull JvmBinaryJarsParams params) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Project project = this.projectProvider.get(cancelChecker);
        AspectSyncProject aspectSyncProject = project instanceof AspectSyncProject ? (AspectSyncProject)project : null;
        if (aspectSyncProject == null) {
            return new JvmBinaryJarsResult(CollectionsKt.emptyList());
        }
        AspectSyncProject project2 = aspectSyncProject;
        return this.bspMapper.jvmBinaryJars(project2, params);
    }

    @NotNull
    public final JvmCompileClasspathResult jvmCompileClasspath(@NotNull CancelChecker cancelChecker, @NotNull JvmCompileClasspathParams params) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Project project = this.projectProvider.get(cancelChecker);
        AspectSyncProject aspectSyncProject = project instanceof AspectSyncProject ? (AspectSyncProject)project : null;
        if (aspectSyncProject == null) {
            return new JvmCompileClasspathResult(CollectionsKt.emptyList());
        }
        AspectSyncProject project2 = aspectSyncProject;
        return this.bspMapper.jvmCompileClasspath(project2, params, cancelChecker);
    }

    @NotNull
    public final JavacOptionsResult buildTargetJavacOptions(@NotNull CancelChecker cancelChecker, @NotNull JavacOptionsParams params) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Project project = this.projectProvider.get(cancelChecker);
        AspectSyncProject aspectSyncProject = project instanceof AspectSyncProject ? (AspectSyncProject)project : null;
        if (aspectSyncProject == null) {
            return new JavacOptionsResult(CollectionsKt.emptyList());
        }
        AspectSyncProject project2 = aspectSyncProject;
        boolean includeClasspath = Intrinsics.areEqual((Object)this.clientCapabilities.getJvmCompileClasspathReceiver(), (Object)false);
        return this.bspMapper.buildTargetJavacOptions(project2, params, includeClasspath, cancelChecker);
    }

    @NotNull
    public final CppOptionsResult buildTargetCppOptions(@NotNull CancelChecker cancelChecker, @NotNull CppOptionsParams params) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Project project = this.projectProvider.get(cancelChecker);
        AspectSyncProject aspectSyncProject = project instanceof AspectSyncProject ? (AspectSyncProject)project : null;
        if (aspectSyncProject == null) {
            return new CppOptionsResult(CollectionsKt.emptyList());
        }
        AspectSyncProject project2 = aspectSyncProject;
        return this.bspMapper.buildTargetCppOptions(project2, params);
    }

    @NotNull
    public final PythonOptionsResult buildTargetPythonOptions(@NotNull CancelChecker cancelChecker, @NotNull PythonOptionsParams params) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Project project = this.projectProvider.get(cancelChecker);
        AspectSyncProject aspectSyncProject = project instanceof AspectSyncProject ? (AspectSyncProject)project : null;
        if (aspectSyncProject == null) {
            return new PythonOptionsResult(CollectionsKt.emptyList());
        }
        AspectSyncProject project2 = aspectSyncProject;
        return this.bspMapper.buildTargetPythonOptions(project2, params);
    }

    @NotNull
    public final ScalacOptionsResult buildTargetScalacOptions(@NotNull CancelChecker cancelChecker, @NotNull ScalacOptionsParams params) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Project project = this.projectProvider.get(cancelChecker);
        AspectSyncProject aspectSyncProject = project instanceof AspectSyncProject ? (AspectSyncProject)project : null;
        if (aspectSyncProject == null) {
            return new ScalacOptionsResult(CollectionsKt.emptyList());
        }
        AspectSyncProject project2 = aspectSyncProject;
        boolean includeClasspath = Intrinsics.areEqual((Object)this.clientCapabilities.getJvmCompileClasspathReceiver(), (Object)false);
        return this.bspMapper.buildTargetScalacOptions(project2, params, includeClasspath, cancelChecker);
    }

    @NotNull
    public final ScalaTestClassesResult buildTargetScalaTestClasses(@NotNull CancelChecker cancelChecker, @NotNull ScalaTestClassesParams params) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Project project = this.projectProvider.get(cancelChecker);
        AspectSyncProject aspectSyncProject = project instanceof AspectSyncProject ? (AspectSyncProject)project : null;
        if (aspectSyncProject == null) {
            return new ScalaTestClassesResult(CollectionsKt.emptyList());
        }
        AspectSyncProject project2 = aspectSyncProject;
        return this.bspMapper.buildTargetScalaTestClasses(project2, params);
    }

    @NotNull
    public final ScalaMainClassesResult buildTargetScalaMainClasses(@NotNull CancelChecker cancelChecker, @NotNull ScalaMainClassesParams params) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Project project = this.projectProvider.get(cancelChecker);
        AspectSyncProject aspectSyncProject = project instanceof AspectSyncProject ? (AspectSyncProject)project : null;
        if (aspectSyncProject == null) {
            return new ScalaMainClassesResult(CollectionsKt.emptyList());
        }
        AspectSyncProject project2 = aspectSyncProject;
        return this.bspMapper.buildTargetScalaMainClasses(project2, params);
    }

    @NotNull
    public final DependencyModulesResult buildTargetDependencyModules(@NotNull CancelChecker cancelChecker, @NotNull DependencyModulesParams params) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Project project = this.projectProvider.get(cancelChecker);
        AspectSyncProject aspectSyncProject = project instanceof AspectSyncProject ? (AspectSyncProject)project : null;
        if (aspectSyncProject == null) {
            return new DependencyModulesResult(CollectionsKt.emptyList());
        }
        AspectSyncProject project2 = aspectSyncProject;
        return this.bspMapper.buildDependencyModules(project2, params);
    }

    @NotNull
    public final RustWorkspaceResult rustWorkspace(@NotNull CancelChecker cancelChecker, @NotNull RustWorkspaceParams params) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Project project = this.projectProvider.get(cancelChecker);
        AspectSyncProject aspectSyncProject = project instanceof AspectSyncProject ? (AspectSyncProject)project : null;
        if (aspectSyncProject == null) {
            return new RustWorkspaceResult(CollectionsKt.emptyList(), MapsKt.emptyMap(), MapsKt.emptyMap(), CollectionsKt.emptyList());
        }
        AspectSyncProject project2 = aspectSyncProject;
        return this.bspMapper.rustWorkspace(project2, params);
    }

    @NotNull
    public final BazelResolveLocalToRemoteResult resolveLocalToRemote(@NotNull CancelChecker cancelChecker, @NotNull BazelResolveLocalToRemoteParams params) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.bspMapper.resolveLocalToRemote(cancelChecker, params);
    }

    @NotNull
    public final BazelResolveRemoteToLocalResult resolveRemoteToLocal(@NotNull CancelChecker cancelChecker, @NotNull BazelResolveRemoteToLocalParams params) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.bspMapper.resolveRemoteToLocal(cancelChecker, params);
    }
}

