/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.sync;

import com.google.protobuf.ProtocolStringList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.info.BspTargetInfo;
import org.jetbrains.bsp.bazel.server.model.Tag;
import org.jetbrains.bsp.bazel.server.sync.TargetTagsResolverKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010\t\u001a\u00020\n*\u00020\bH\u0002J\f\u0010\u000b\u001a\u00020\n*\u00020\bH\u0002J\f\u0010\f\u001a\u00020\n*\u00020\bH\u0002J\f\u0010\r\u001a\u00020\n*\u00020\bH\u0002J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/TargetTagsResolver;", "", "<init>", "()V", "resolveTags", "", "Lorg/jetbrains/bsp/bazel/server/model/Tag;", "targetInfo", "Lorg/jetbrains/bsp/bazel/info/BspTargetInfo$TargetInfo;", "isTest", "", "isIntellijPlugin", "isAndroidBinary", "isApplication", "mapBazelTags", "tags", "", "", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync-sync"})
@SourceDebugExtension(value={"SMAP\nTargetTagsResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetTagsResolver.kt\norg/jetbrains/bsp/bazel/server/sync/TargetTagsResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n1611#2,9:39\n1863#2:48\n1864#2:50\n1620#2:51\n1#3:49\n*S KotlinDebug\n*F\n+ 1 TargetTagsResolver.kt\norg/jetbrains/bsp/bazel/server/sync/TargetTagsResolver\n*L\n36#1:39,9\n36#1:48\n36#1:50\n36#1:51\n36#1:49\n*E\n"})
public final class TargetTagsResolver {
    @NotNull
    public final Set<Tag> resolveTags(@NotNull BspTargetInfo.TargetInfo targetInfo) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
        if (this.isTest(targetInfo)) {
            set = SetsKt.setOf((Object)((Object)Tag.TEST));
        } else if (this.isIntellijPlugin(targetInfo)) {
            Tag[] tagArray = new Tag[]{Tag.INTELLIJ_PLUGIN, Tag.APPLICATION};
            set = SetsKt.setOf((Object[])tagArray);
        } else {
            set = this.isApplication(targetInfo) || this.isAndroidBinary(targetInfo) ? SetsKt.setOf((Object)((Object)Tag.APPLICATION)) : SetsKt.setOf((Object)((Object)Tag.LIBRARY));
        }
        Set typeTags = set;
        ProtocolStringList protocolStringList = targetInfo.getTagsList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getTagsList(...)");
        return SetsKt.plus((Set)typeTags, (Iterable)this.mapBazelTags((List)protocolStringList));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTest(BspTargetInfo.TargetInfo $this$isTest) {
        if (!this.isApplication($this$isTest)) return false;
        String string = $this$isTest.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKind(...)");
        if (!StringsKt.endsWith$default((String)string, (String)"_test", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final boolean isIntellijPlugin(BspTargetInfo.TargetInfo $this$isIntellijPlugin) {
        return Intrinsics.areEqual((Object)$this$isIntellijPlugin.getKind(), (Object)"intellij_plugin_debug_target");
    }

    private final boolean isAndroidBinary(BspTargetInfo.TargetInfo $this$isAndroidBinary) {
        return Intrinsics.areEqual((Object)$this$isAndroidBinary.getKind(), (Object)"android_binary");
    }

    private final boolean isApplication(BspTargetInfo.TargetInfo $this$isApplication) {
        return $this$isApplication.getExecutable();
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Tag> mapBazelTags(List<String> tags) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = tags;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Tag it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if ((Tag)((Object)TargetTagsResolverKt.access$getBazelTagToTagMapping$p().get(it)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }
}

