/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.sync.languages;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.server.sync.languages.JVMLanguagePluginParser;
import org.jetbrains.bsp.bazel.server.sync.languages.SourceRootAndData;
import org.jetbrains.bsp.bazel.server.sync.languages.jvm.SourceRootGuesser;
import org.jetbrains.bsp.protocol.EnhancedSourceItemData;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/languages/JVMLanguagePluginParser;", "", "<init>", "()V", "PACKAGE_PATTERN", "Lkotlin/text/Regex;", "ONE_BYTE_CHARSET", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "Ljava/nio/charset/Charset;", "BUFFER_SIZE", "", "calculateJVMSourceRootAndAdditionalData", "Lorg/jetbrains/bsp/bazel/server/sync/languages/SourceRootAndData;", "source", "Ljava/nio/file/Path;", "multipleLines", "", "findPackage", "", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_languages-languages"})
@SourceDebugExtension(value={"SMAP\nJVMLanguagePluginParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JVMLanguagePluginParser.kt\norg/jetbrains/bsp/bazel/server/sync/languages/JVMLanguagePluginParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class JVMLanguagePluginParser {
    @NotNull
    public static final JVMLanguagePluginParser INSTANCE = new JVMLanguagePluginParser();
    @NotNull
    private static final Regex PACKAGE_PATTERN = new Regex("^\\s*package\\s+([\\p{L}0-9_.]+)");
    private static final Charset ONE_BYTE_CHARSET = Charset.forName("ISO-8859-1");
    private static final int BUFFER_SIZE = 256;

    private JVMLanguagePluginParser() {
    }

    @NotNull
    public final SourceRootAndData calculateJVMSourceRootAndAdditionalData(@NotNull Path source, boolean multipleLines) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String string = this.findPackage(source, multipleLines);
        if (string == null) {
            return new SourceRootAndData(SourceRootGuesser.INSTANCE.getSourcesRoot(source), null, 2, null);
        }
        String sourcePackage = string;
        Path sourcePackagePath = Paths.get(StringsKt.replace$default((String)sourcePackage, (String)".", (String)"/", (boolean)false, (int)4, null), new String[0]);
        int sourceRootEndIndex = source.getNameCount() - sourcePackagePath.getNameCount() - 1;
        Path sourceRoot = !source.getParent().endsWith(sourcePackagePath) ? SourceRootGuesser.INSTANCE.getSourcesRoot(source) : Paths.get("/", new String[0]).resolve(source.subpath(0, sourceRootEndIndex));
        Intrinsics.checkNotNull((Object)sourceRoot);
        return new SourceRootAndData(sourceRoot, new EnhancedSourceItemData(sourcePackage));
    }

    public static /* synthetic */ SourceRootAndData calculateJVMSourceRootAndAdditionalData$default(JVMLanguagePluginParser jVMLanguagePluginParser, Path path2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jVMLanguagePluginParser.calculateJVMSourceRootAndAdditionalData(path2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String findPackage(Path source, boolean multipleLines) {
        Object object = new File(source.toUri());
        Charset charset = ONE_BYTE_CHARSET;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"ONE_BYTE_CHARSET");
        Object object2 = charset;
        int n = 256;
        Object object3 = object;
        object3 = new InputStreamReader((InputStream)new FileInputStream((File)object3), (Charset)object2);
        object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
        object2 = null;
        try {
            String string;
            BufferedReader bufferedReader = (BufferedReader)object;
            boolean bl = false;
            Sequence packages2 = SequencesKt.mapNotNull((Sequence)TextStreamsKt.lineSequence((BufferedReader)bufferedReader), (Function1)findPackage.1.packages.1.INSTANCE);
            if (multipleLines) {
                String string2;
                String it = string2 = SequencesKt.joinToString$default((Sequence)packages2, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                boolean bl2 = false;
                string = ((CharSequence)it).length() > 0 ? string2 : null;
            } else {
                string = (String)SequencesKt.firstOrNull((Sequence)packages2);
            }
            String string3 = string;
            return string3;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    public static final /* synthetic */ Charset access$getONE_BYTE_CHARSET$p() {
        return ONE_BYTE_CHARSET;
    }

    public static final /* synthetic */ Regex access$getPACKAGE_PATTERN$p() {
        return PACKAGE_PATTERN;
    }
}

