/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.sync.languages;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bsp.bazel.info.BspTargetInfo;
import org.jetbrains.bsp.bazel.server.model.Language;
import org.jetbrains.bsp.bazel.server.model.LanguageData;
import org.jetbrains.bsp.bazel.server.model.Module;
import org.jetbrains.bsp.bazel.server.sync.languages.EmptyLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.LanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.android.AndroidLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.cpp.CppLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.cpp.CppModule;
import org.jetbrains.bsp.bazel.server.sync.languages.go.GoLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.java.JavaLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.kotlin.KotlinLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.python.PythonLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.python.PythonModule;
import org.jetbrains.bsp.bazel.server.sync.languages.rust.RustLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.scala.ScalaLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.thrift.ThriftLanguagePlugin;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0014\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%J\u0018\u0010'\u001a\u0006\u0012\u0002\b\u00030(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*J\u0010\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u0004\u0018\u0001012\u0006\u0010.\u001a\u00020/R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/languages/LanguagePluginsService;", "", "scalaLanguagePlugin", "Lorg/jetbrains/bsp/bazel/server/sync/languages/scala/ScalaLanguagePlugin;", "javaLanguagePlugin", "Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JavaLanguagePlugin;", "cppLanguagePlugin", "Lorg/jetbrains/bsp/bazel/server/sync/languages/cpp/CppLanguagePlugin;", "kotlinLanguagePlugin", "Lorg/jetbrains/bsp/bazel/server/sync/languages/kotlin/KotlinLanguagePlugin;", "thriftLanguagePlugin", "Lorg/jetbrains/bsp/bazel/server/sync/languages/thrift/ThriftLanguagePlugin;", "pythonLanguagePlugin", "Lorg/jetbrains/bsp/bazel/server/sync/languages/python/PythonLanguagePlugin;", "rustLanguagePlugin", "Lorg/jetbrains/bsp/bazel/server/sync/languages/rust/RustLanguagePlugin;", "androidLanguagePlugin", "Lorg/jetbrains/bsp/bazel/server/sync/languages/android/AndroidLanguagePlugin;", "goLanguagePlugin", "Lorg/jetbrains/bsp/bazel/server/sync/languages/go/GoLanguagePlugin;", "<init>", "(Lorg/jetbrains/bsp/bazel/server/sync/languages/scala/ScalaLanguagePlugin;Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JavaLanguagePlugin;Lorg/jetbrains/bsp/bazel/server/sync/languages/cpp/CppLanguagePlugin;Lorg/jetbrains/bsp/bazel/server/sync/languages/kotlin/KotlinLanguagePlugin;Lorg/jetbrains/bsp/bazel/server/sync/languages/thrift/ThriftLanguagePlugin;Lorg/jetbrains/bsp/bazel/server/sync/languages/python/PythonLanguagePlugin;Lorg/jetbrains/bsp/bazel/server/sync/languages/rust/RustLanguagePlugin;Lorg/jetbrains/bsp/bazel/server/sync/languages/android/AndroidLanguagePlugin;Lorg/jetbrains/bsp/bazel/server/sync/languages/go/GoLanguagePlugin;)V", "getScalaLanguagePlugin", "()Lorg/jetbrains/bsp/bazel/server/sync/languages/scala/ScalaLanguagePlugin;", "getCppLanguagePlugin", "()Lorg/jetbrains/bsp/bazel/server/sync/languages/cpp/CppLanguagePlugin;", "getPythonLanguagePlugin", "()Lorg/jetbrains/bsp/bazel/server/sync/languages/python/PythonLanguagePlugin;", "getRustLanguagePlugin", "()Lorg/jetbrains/bsp/bazel/server/sync/languages/rust/RustLanguagePlugin;", "getGoLanguagePlugin", "()Lorg/jetbrains/bsp/bazel/server/sync/languages/go/GoLanguagePlugin;", "emptyLanguagePlugin", "Lorg/jetbrains/bsp/bazel/server/sync/languages/EmptyLanguagePlugin;", "prepareSync", "", "targetInfos", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/bsp/bazel/info/BspTargetInfo$TargetInfo;", "getPlugin", "Lorg/jetbrains/bsp/bazel/server/sync/languages/LanguagePlugin;", "languages", "", "Lorg/jetbrains/bsp/bazel/server/model/Language;", "extractCppModule", "Lorg/jetbrains/bsp/bazel/server/sync/languages/cpp/CppModule;", "module", "Lorg/jetbrains/bsp/bazel/server/model/Module;", "extractPythonModule", "Lorg/jetbrains/bsp/bazel/server/sync/languages/python/PythonModule;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_languages-languages"})
public final class LanguagePluginsService {
    @NotNull
    private final ScalaLanguagePlugin scalaLanguagePlugin;
    @NotNull
    private final JavaLanguagePlugin javaLanguagePlugin;
    @NotNull
    private final CppLanguagePlugin cppLanguagePlugin;
    @NotNull
    private final KotlinLanguagePlugin kotlinLanguagePlugin;
    @NotNull
    private final ThriftLanguagePlugin thriftLanguagePlugin;
    @NotNull
    private final PythonLanguagePlugin pythonLanguagePlugin;
    @NotNull
    private final RustLanguagePlugin rustLanguagePlugin;
    @NotNull
    private final AndroidLanguagePlugin androidLanguagePlugin;
    @NotNull
    private final GoLanguagePlugin goLanguagePlugin;
    @NotNull
    private final EmptyLanguagePlugin emptyLanguagePlugin;

    public LanguagePluginsService(@NotNull ScalaLanguagePlugin scalaLanguagePlugin, @NotNull JavaLanguagePlugin javaLanguagePlugin, @NotNull CppLanguagePlugin cppLanguagePlugin, @NotNull KotlinLanguagePlugin kotlinLanguagePlugin, @NotNull ThriftLanguagePlugin thriftLanguagePlugin, @NotNull PythonLanguagePlugin pythonLanguagePlugin, @NotNull RustLanguagePlugin rustLanguagePlugin, @NotNull AndroidLanguagePlugin androidLanguagePlugin, @NotNull GoLanguagePlugin goLanguagePlugin) {
        Intrinsics.checkNotNullParameter((Object)scalaLanguagePlugin, (String)"scalaLanguagePlugin");
        Intrinsics.checkNotNullParameter((Object)javaLanguagePlugin, (String)"javaLanguagePlugin");
        Intrinsics.checkNotNullParameter((Object)cppLanguagePlugin, (String)"cppLanguagePlugin");
        Intrinsics.checkNotNullParameter((Object)kotlinLanguagePlugin, (String)"kotlinLanguagePlugin");
        Intrinsics.checkNotNullParameter((Object)thriftLanguagePlugin, (String)"thriftLanguagePlugin");
        Intrinsics.checkNotNullParameter((Object)pythonLanguagePlugin, (String)"pythonLanguagePlugin");
        Intrinsics.checkNotNullParameter((Object)rustLanguagePlugin, (String)"rustLanguagePlugin");
        Intrinsics.checkNotNullParameter((Object)androidLanguagePlugin, (String)"androidLanguagePlugin");
        Intrinsics.checkNotNullParameter((Object)goLanguagePlugin, (String)"goLanguagePlugin");
        this.scalaLanguagePlugin = scalaLanguagePlugin;
        this.javaLanguagePlugin = javaLanguagePlugin;
        this.cppLanguagePlugin = cppLanguagePlugin;
        this.kotlinLanguagePlugin = kotlinLanguagePlugin;
        this.thriftLanguagePlugin = thriftLanguagePlugin;
        this.pythonLanguagePlugin = pythonLanguagePlugin;
        this.rustLanguagePlugin = rustLanguagePlugin;
        this.androidLanguagePlugin = androidLanguagePlugin;
        this.goLanguagePlugin = goLanguagePlugin;
        this.emptyLanguagePlugin = new EmptyLanguagePlugin();
    }

    @NotNull
    public final ScalaLanguagePlugin getScalaLanguagePlugin() {
        return this.scalaLanguagePlugin;
    }

    @NotNull
    public final CppLanguagePlugin getCppLanguagePlugin() {
        return this.cppLanguagePlugin;
    }

    @NotNull
    public final PythonLanguagePlugin getPythonLanguagePlugin() {
        return this.pythonLanguagePlugin;
    }

    @NotNull
    public final RustLanguagePlugin getRustLanguagePlugin() {
        return this.rustLanguagePlugin;
    }

    @NotNull
    public final GoLanguagePlugin getGoLanguagePlugin() {
        return this.goLanguagePlugin;
    }

    public final void prepareSync(@NotNull Sequence<BspTargetInfo.TargetInfo> targetInfos) {
        Intrinsics.checkNotNullParameter(targetInfos, (String)"targetInfos");
        this.scalaLanguagePlugin.prepareSync(targetInfos);
        this.javaLanguagePlugin.prepareSync(targetInfos);
        this.cppLanguagePlugin.prepareSync(targetInfos);
        this.thriftLanguagePlugin.prepareSync(targetInfos);
        this.pythonLanguagePlugin.prepareSync(targetInfos);
        this.rustLanguagePlugin.prepareSync(targetInfos);
        this.androidLanguagePlugin.prepareSync(targetInfos);
        this.goLanguagePlugin.prepareSync(targetInfos);
    }

    @NotNull
    public final LanguagePlugin<?> getPlugin(@NotNull Set<? extends Language> languages) {
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        return languages.contains((Object)Language.ANDROID) ? (LanguagePlugin)this.androidLanguagePlugin : (languages.contains((Object)Language.KOTLIN) ? (LanguagePlugin)this.kotlinLanguagePlugin : (languages.contains((Object)Language.SCALA) ? (LanguagePlugin)this.scalaLanguagePlugin : (languages.contains((Object)Language.JAVA) ? (LanguagePlugin)this.javaLanguagePlugin : (languages.contains((Object)Language.CPP) ? (LanguagePlugin)this.cppLanguagePlugin : (languages.contains((Object)Language.THRIFT) ? (LanguagePlugin)this.thriftLanguagePlugin : (languages.contains((Object)Language.PYTHON) ? (LanguagePlugin)this.pythonLanguagePlugin : (languages.contains((Object)Language.RUST) ? (LanguagePlugin)this.rustLanguagePlugin : (languages.contains((Object)Language.GO) ? (LanguagePlugin)this.goLanguagePlugin : (LanguagePlugin)this.emptyLanguagePlugin))))))));
    }

    @Nullable
    public final CppModule extractCppModule(@NotNull Module module) {
        CppModule cppModule;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        LanguageData languageData = module.getLanguageData();
        if (languageData != null) {
            LanguageData it = languageData;
            boolean bl = false;
            cppModule = it instanceof CppModule ? (CppModule)it : null;
        } else {
            cppModule = null;
        }
        return cppModule;
    }

    @Nullable
    public final PythonModule extractPythonModule(@NotNull Module module) {
        PythonModule pythonModule;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        LanguageData languageData = module.getLanguageData();
        if (languageData != null) {
            LanguageData it = languageData;
            boolean bl = false;
            pythonModule = it instanceof PythonModule ? (PythonModule)it : null;
        } else {
            pythonModule = null;
        }
        return pythonModule;
    }
}

