/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.sync.languages.android;

import ch.epfl.scala.bsp4j.BuildTarget;
import ch.epfl.scala.bsp4j.JvmBuildTarget;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bsp.bazel.info.BspTargetInfo;
import org.jetbrains.bsp.bazel.server.dependencygraph.DependencyGraph;
import org.jetbrains.bsp.bazel.server.model.LanguageData;
import org.jetbrains.bsp.bazel.server.paths.BazelPathsResolver;
import org.jetbrains.bsp.bazel.server.sync.languages.LanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.SourceRootAndData;
import org.jetbrains.bsp.bazel.server.sync.languages.android.AndroidModule;
import org.jetbrains.bsp.bazel.server.sync.languages.java.JavaLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.java.JavaModule;
import org.jetbrains.bsp.bazel.server.sync.languages.kotlin.KotlinLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.kotlin.KotlinModule;
import org.jetbrains.bsp.bazel.workspacecontext.WorkspaceContextProvider;
import org.jetbrains.bsp.protocol.AndroidBuildTarget;
import org.jetbrains.bsp.protocol.AndroidTargetType;
import org.jetbrains.bsp.protocol.KotlinBuildTarget;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u001a\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006'"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/languages/android/AndroidLanguagePlugin;", "Lorg/jetbrains/bsp/bazel/server/sync/languages/LanguagePlugin;", "Lorg/jetbrains/bsp/bazel/server/sync/languages/android/AndroidModule;", "workspaceContextProvider", "Lorg/jetbrains/bsp/bazel/workspacecontext/WorkspaceContextProvider;", "javaLanguagePlugin", "Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JavaLanguagePlugin;", "kotlinLanguagePlugin", "Lorg/jetbrains/bsp/bazel/server/sync/languages/kotlin/KotlinLanguagePlugin;", "bazelPathsResolver", "Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;", "<init>", "(Lorg/jetbrains/bsp/bazel/workspacecontext/WorkspaceContextProvider;Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JavaLanguagePlugin;Lorg/jetbrains/bsp/bazel/server/sync/languages/kotlin/KotlinLanguagePlugin;Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;)V", "androidMinSdkOverride", "", "Ljava/lang/Integer;", "prepareSync", "", "targets", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/bsp/bazel/info/BspTargetInfo$TargetInfo;", "applyModuleData", "moduleData", "buildTarget", "Lch/epfl/scala/bsp4j/BuildTarget;", "resolveModule", "targetInfo", "getAndroidTargetType", "Lorg/jetbrains/bsp/protocol/AndroidTargetType;", "dependencySources", "", "Ljava/net/URI;", "dependencyGraph", "Lorg/jetbrains/bsp/bazel/server/dependencygraph/DependencyGraph;", "calculateSourceRootAndAdditionalData", "Lorg/jetbrains/bsp/bazel/server/sync/languages/SourceRootAndData;", "source", "Ljava/nio/file/Path;", "resolveAdditionalResources", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_languages-languages"})
@SourceDebugExtension(value={"SMAP\nAndroidLanguagePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidLanguagePlugin.kt\norg/jetbrains/bsp/bazel/server/sync/languages/android/AndroidLanguagePlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1557#2:124\n1628#2,3:125\n1557#2:128\n1628#2,3:129\n1#3:132\n*S KotlinDebug\n*F\n+ 1 AndroidLanguagePlugin.kt\norg/jetbrains/bsp/bazel/server/sync/languages/android/AndroidLanguagePlugin\n*L\n38#1:124\n38#1:125,3\n40#1:128\n40#1:129,3\n*E\n"})
public final class AndroidLanguagePlugin
extends LanguagePlugin<AndroidModule> {
    @NotNull
    private final WorkspaceContextProvider workspaceContextProvider;
    @NotNull
    private final JavaLanguagePlugin javaLanguagePlugin;
    @NotNull
    private final KotlinLanguagePlugin kotlinLanguagePlugin;
    @NotNull
    private final BazelPathsResolver bazelPathsResolver;
    @Nullable
    private Integer androidMinSdkOverride;

    public AndroidLanguagePlugin(@NotNull WorkspaceContextProvider workspaceContextProvider, @NotNull JavaLanguagePlugin javaLanguagePlugin, @NotNull KotlinLanguagePlugin kotlinLanguagePlugin, @NotNull BazelPathsResolver bazelPathsResolver) {
        Intrinsics.checkNotNullParameter((Object)workspaceContextProvider, (String)"workspaceContextProvider");
        Intrinsics.checkNotNullParameter((Object)javaLanguagePlugin, (String)"javaLanguagePlugin");
        Intrinsics.checkNotNullParameter((Object)kotlinLanguagePlugin, (String)"kotlinLanguagePlugin");
        Intrinsics.checkNotNullParameter((Object)bazelPathsResolver, (String)"bazelPathsResolver");
        this.workspaceContextProvider = workspaceContextProvider;
        this.javaLanguagePlugin = javaLanguagePlugin;
        this.kotlinLanguagePlugin = kotlinLanguagePlugin;
        this.bazelPathsResolver = bazelPathsResolver;
    }

    @Override
    public void prepareSync(@NotNull Sequence<BspTargetInfo.TargetInfo> targets2) {
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        this.androidMinSdkOverride = this.workspaceContextProvider.currentWorkspaceContext().getAndroidMinSdkSpec().getValue();
    }

    @Override
    protected void applyModuleData(@NotNull AndroidModule moduleData, @NotNull BuildTarget buildTarget) {
        Object object;
        Object it;
        Collection<String> collection;
        URI it2;
        Collection<String> collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        Intrinsics.checkNotNullParameter((Object)buildTarget, (String)"buildTarget");
        AndroidModule $this$applyModuleData_u24lambda_u242 = moduleData;
        boolean bl = false;
        String string = $this$applyModuleData_u24lambda_u242.getAndroidJar().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        URI uRI = $this$applyModuleData_u24lambda_u242.getManifest();
        Iterable iterable = $this$applyModuleData_u24lambda_u242.getResourceDirectories();
        Map<String, String> map = $this$applyModuleData_u24lambda_u242.getManifestOverrides();
        String string2 = uRI != null ? uRI.toString() : null;
        AndroidTargetType androidTargetType = $this$applyModuleData_u24lambda_u242.getAndroidTargetType();
        String string3 = string;
        boolean $i$f$map = false;
        void var12_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            URI uRI2 = (URI)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl2 = false;
            String string4 = it2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            collection2.add(string4);
        }
        collection2 = (List)destination$iv$iv;
        $this$map$iv = $this$applyModuleData_u24lambda_u242.getAssetsDirectories();
        String string5 = $this$applyModuleData_u24lambda_u242.getResourceJavaPackage();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (URI)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            String string6 = it2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
            collection.add(string6);
        }
        collection = (List)destination$iv$iv;
        URI uRI3 = $this$applyModuleData_u24lambda_u242.getApk();
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 768;
        KotlinBuildTarget kotlinBuildTarget = null;
        JvmBuildTarget jvmBuildTarget = null;
        String string7 = uRI3 != null ? uRI3.toString() : null;
        Collection<String> collection3 = collection;
        String string8 = string5;
        Collection<String> collection4 = collection2;
        Map<String, String> map2 = map;
        String string9 = string2;
        AndroidTargetType androidTargetType2 = androidTargetType;
        String string10 = string3;
        AndroidBuildTarget androidBuildTarget = new AndroidBuildTarget(string10, androidTargetType2, string9, map2, (List)collection4, string8, (List)collection3, string7, jvmBuildTarget, kotlinBuildTarget, n, defaultConstructorMarker);
        JavaModule javaModule = moduleData.getJavaModule();
        if (javaModule != null) {
            it = javaModule;
            boolean bl4 = false;
            JvmBuildTarget jvmBuildTarget2 = this.javaLanguagePlugin.toJvmBuildTarget((JavaModule)it);
            javaModule = jvmBuildTarget2;
            if (jvmBuildTarget2 != null) {
                it = javaModule;
                boolean bl5 = false;
                androidBuildTarget.setJvmBuildTarget((JvmBuildTarget)it);
            }
        }
        if ((object = moduleData.getKotlinModule()) != null) {
            it = object;
            boolean bl6 = false;
            KotlinBuildTarget kotlinBuildTarget2 = this.kotlinLanguagePlugin.toKotlinBuildTarget((KotlinModule)it);
            object = kotlinBuildTarget2;
            if (kotlinBuildTarget2 != null) {
                it = object;
                boolean bl7 = false;
                androidBuildTarget.setKotlinBuildTarget((KotlinBuildTarget)it);
            }
        }
        buildTarget.setDataKind("android");
        buildTarget.setData((Object)androidBuildTarget);
    }

    @Override
    @Nullable
    public AndroidModule resolveModule(@NotNull BspTargetInfo.TargetInfo targetInfo) {
        URI uRI;
        String string2;
        Object object;
        URI manifest;
        URI androidJar;
        BspTargetInfo.AndroidTargetInfo androidTargetInfo;
        block10: {
            Map<String, String> $this$resolveModule_u24lambda_u248;
            block9: {
                URI uRI2;
                Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
                if (!targetInfo.hasAndroidTargetInfo()) {
                    return null;
                }
                androidTargetInfo = targetInfo.getAndroidTargetInfo();
                BspTargetInfo.FileLocation fileLocation = androidTargetInfo.getAndroidJar();
                Intrinsics.checkNotNullExpressionValue((Object)fileLocation, (String)"getAndroidJar(...)");
                androidJar = this.bazelPathsResolver.resolveUri(fileLocation);
                if (androidTargetInfo.hasManifest()) {
                    BspTargetInfo.FileLocation fileLocation2 = androidTargetInfo.getManifest();
                    Intrinsics.checkNotNullExpressionValue((Object)fileLocation2, (String)"getManifest(...)");
                    uRI2 = this.bazelPathsResolver.resolveUri(fileLocation2);
                } else {
                    uRI2 = null;
                }
                manifest = uRI2;
                $this$resolveModule_u24lambda_u248 = androidTargetInfo.getManifestOverridesMap();
                boolean string2 = false;
                object = this.androidMinSdkOverride;
                if (object == null) break block9;
                int androidMinSdkOverride = ((Number)object).intValue();
                boolean bl = false;
                Intrinsics.checkNotNull($this$resolveModule_u24lambda_u248);
                Map map = MapsKt.plus($this$resolveModule_u24lambda_u248, (Pair)TuplesKt.to((Object)"minSdkVersion", (Object)String.valueOf(androidMinSdkOverride)));
                object = map;
                if (map != null) break block10;
            }
            object = $this$resolveModule_u24lambda_u248;
        }
        Object manifestOverrides = object;
        List<BspTargetInfo.FileLocation> list = androidTargetInfo.getResourceDirectoriesList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getResourceDirectoriesList(...)");
        List resourceDirectories = BazelPathsResolver.resolveUris$default(this.bazelPathsResolver, list, false, 2, null);
        String it = string2 = androidTargetInfo.getResourceJavaPackage();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        String resourceJavaPackage = ((CharSequence)it).length() > 0 ? string2 : null;
        List<BspTargetInfo.FileLocation> list2 = androidTargetInfo.getAssetsDirectoriesList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getAssetsDirectoriesList(...)");
        List assetsDirectories = BazelPathsResolver.resolveUris$default(this.bazelPathsResolver, list2, false, 2, null);
        if (androidTargetInfo.hasApk()) {
            BspTargetInfo.FileLocation fileLocation = androidTargetInfo.getApk();
            Intrinsics.checkNotNullExpressionValue((Object)fileLocation, (String)"getApk(...)");
            uRI = this.bazelPathsResolver.resolveUri(fileLocation);
        } else {
            uRI = null;
        }
        URI apk = uRI;
        KotlinModule kotlinModule = this.kotlinLanguagePlugin.resolveModule(targetInfo);
        AndroidTargetType androidTargetType = this.getAndroidTargetType(targetInfo);
        Intrinsics.checkNotNull((Object)manifestOverrides);
        LanguageData languageData = kotlinModule;
        if (languageData == null || (languageData = languageData.getJavaModule()) == null) {
            languageData = this.javaLanguagePlugin.resolveModule(targetInfo);
        }
        return new AndroidModule(androidJar, androidTargetType, manifest, (Map<String, String>)manifestOverrides, resourceDirectories, resourceJavaPackage, assetsDirectories, apk, (JavaModule)languageData, kotlinModule, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final AndroidTargetType getAndroidTargetType(BspTargetInfo.TargetInfo targetInfo) {
        AndroidTargetType androidTargetType;
        String string = targetInfo.getKind();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case -1747706698: {
                    if (!string.equals("android_local_test")) break;
                    n = 1;
                    break;
                }
                case -15235119: {
                    if (!string.equals("android_binary")) break;
                    n = 2;
                    break;
                }
                case 940233363: {
                    if (!string.equals("android_instrumentation_test")) break;
                    n = 1;
                    break;
                }
                case -197778709: {
                    if (!string.equals("android_library")) break;
                    n = 3;
                    break;
                }
            }
            switch (n) {
                case 2: {
                    androidTargetType = AndroidTargetType.APP;
                    return androidTargetType;
                }
                case 3: {
                    androidTargetType = AndroidTargetType.LIBRARY;
                    return androidTargetType;
                }
                case 1: {
                    androidTargetType = AndroidTargetType.TEST;
                    return androidTargetType;
                }
            }
        }
        androidTargetType = AndroidTargetType.LIBRARY;
        return androidTargetType;
    }

    @Override
    @NotNull
    public Set<URI> dependencySources(@NotNull BspTargetInfo.TargetInfo targetInfo, @NotNull DependencyGraph dependencyGraph2) {
        Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
        Intrinsics.checkNotNullParameter((Object)dependencyGraph2, (String)"dependencyGraph");
        return this.javaLanguagePlugin.dependencySources(targetInfo, dependencyGraph2);
    }

    @Override
    @NotNull
    public SourceRootAndData calculateSourceRootAndAdditionalData(@NotNull Path source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.javaLanguagePlugin.calculateSourceRootAndAdditionalData(source);
    }

    @Override
    @NotNull
    public Set<URI> resolveAdditionalResources(@NotNull BspTargetInfo.TargetInfo targetInfo) {
        Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
        if (!targetInfo.hasAndroidTargetInfo()) {
            return SetsKt.emptySet();
        }
        BspTargetInfo.AndroidTargetInfo androidTargetInfo = targetInfo.getAndroidTargetInfo();
        if (!androidTargetInfo.hasManifest()) {
            return SetsKt.emptySet();
        }
        Collection collection = CollectionsKt.listOf((Object)targetInfo.getAndroidTargetInfo().getManifest());
        List<BspTargetInfo.FileLocation> list = targetInfo.getAndroidTargetInfo().getResourceDirectoriesList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getResourceDirectoriesList(...)");
        return CollectionsKt.toSet((Iterable)BazelPathsResolver.resolveUris$default(this.bazelPathsResolver, CollectionsKt.plus((Collection)collection, (Iterable)list), false, 2, null));
    }
}

