/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.sync.languages.go;

import ch.epfl.scala.bsp4j.BuildTarget;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bsp.bazel.info.BspTargetInfo;
import org.jetbrains.bsp.bazel.logger.BspClientLogger;
import org.jetbrains.bsp.bazel.server.paths.BazelPathsResolver;
import org.jetbrains.bsp.bazel.server.sync.languages.LanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.SourceRootAndData;
import org.jetbrains.bsp.bazel.server.sync.languages.go.GoModule;
import org.jetbrains.bsp.bazel.server.sync.languages.jvm.SourceRootGuesser;
import org.jetbrains.bsp.protocol.BazelResolveLocalToRemoteParams;
import org.jetbrains.bsp.protocol.BazelResolveLocalToRemoteResult;
import org.jetbrains.bsp.protocol.BazelResolveRemoteToLocalParams;
import org.jetbrains.bsp.protocol.BazelResolveRemoteToLocalResult;
import org.jetbrains.bsp.protocol.GoBuildTarget;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0014H\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020!J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#H\u0002J\u0018\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/languages/go/GoLanguagePlugin;", "Lorg/jetbrains/bsp/bazel/server/sync/languages/LanguagePlugin;", "Lorg/jetbrains/bsp/bazel/server/sync/languages/go/GoModule;", "bazelPathsResolver", "Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;", "logger", "Lorg/jetbrains/bsp/bazel/logger/BspClientLogger;", "<init>", "(Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;Lorg/jetbrains/bsp/bazel/logger/BspClientLogger;)V", "applyModuleData", "", "moduleData", "buildTarget", "Lch/epfl/scala/bsp4j/BuildTarget;", "calculateSourceRootAndAdditionalData", "Lorg/jetbrains/bsp/bazel/server/sync/languages/SourceRootAndData;", "source", "Ljava/nio/file/Path;", "calculateAdditionalSources", "", "Lorg/jetbrains/bsp/bazel/info/BspTargetInfo$FileLocation;", "targetInfo", "Lorg/jetbrains/bsp/bazel/info/BspTargetInfo$TargetInfo;", "resolveModule", "calculateSdkURI", "Ljava/net/URI;", "sdk", "resolveLocalToRemote", "Lorg/jetbrains/bsp/protocol/BazelResolveLocalToRemoteResult;", "params", "Lorg/jetbrains/bsp/protocol/BazelResolveLocalToRemoteParams;", "resolveRemoteToLocal", "Lorg/jetbrains/bsp/protocol/BazelResolveRemoteToLocalResult;", "Lorg/jetbrains/bsp/protocol/BazelResolveRemoteToLocalParams;", "normalizeRemotePath", "", "path", "goRoot", "afterNthSlash", "n", "", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_languages-languages"})
@SourceDebugExtension(value={"SMAP\nGoLanguagePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoLanguagePlugin.kt\norg/jetbrains/bsp/bazel/server/sync/languages/go/GoLanguagePlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1611#2,9:137\n1863#2:146\n1864#2:148\n1620#2:149\n1611#2,9:150\n1863#2:159\n1864#2:161\n1620#2:162\n1#3:147\n1#3:160\n1#3:163\n*S KotlinDebug\n*F\n+ 1 GoLanguagePlugin.kt\norg/jetbrains/bsp/bazel/server/sync/languages/go/GoLanguagePlugin\n*L\n50#1:137,9\n50#1:146\n50#1:148\n50#1:149\n51#1:150,9\n51#1:159\n51#1:161\n51#1:162\n50#1:147\n51#1:160\n*E\n"})
public final class GoLanguagePlugin
extends LanguagePlugin<GoModule> {
    @NotNull
    private final BazelPathsResolver bazelPathsResolver;
    @Nullable
    private final BspClientLogger logger;

    public GoLanguagePlugin(@NotNull BazelPathsResolver bazelPathsResolver, @Nullable BspClientLogger logger) {
        Intrinsics.checkNotNullParameter((Object)bazelPathsResolver, (String)"bazelPathsResolver");
        this.bazelPathsResolver = bazelPathsResolver;
        this.logger = logger;
    }

    public /* synthetic */ GoLanguagePlugin(BazelPathsResolver bazelPathsResolver, BspClientLogger bspClientLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bspClientLogger = null;
        }
        this(bazelPathsResolver, bspClientLogger);
    }

    @Override
    protected void applyModuleData(@NotNull GoModule moduleData, @NotNull BuildTarget buildTarget) {
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        Intrinsics.checkNotNullParameter((Object)buildTarget, (String)"buildTarget");
        GoModule $this$applyModuleData_u24lambda_u240 = moduleData;
        boolean bl = false;
        GoBuildTarget goBuildTarget = new GoBuildTarget($this$applyModuleData_u24lambda_u240.getSdkHomePath(), $this$applyModuleData_u24lambda_u240.getImportPath(), $this$applyModuleData_u24lambda_u240.getGeneratedLibraries());
        buildTarget.setDataKind("go");
        buildTarget.setData((Object)goBuildTarget);
    }

    @Override
    @NotNull
    public SourceRootAndData calculateSourceRootAndAdditionalData(@NotNull Path source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new SourceRootAndData(SourceRootGuesser.INSTANCE.getSourcesRoot(source), null, 2, null);
    }

    @Override
    @NotNull
    public List<BspTargetInfo.FileLocation> calculateAdditionalSources(@NotNull BspTargetInfo.TargetInfo targetInfo) {
        Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
        if (!targetInfo.hasGoTargetInfo()) {
            return CollectionsKt.emptyList();
        }
        List<BspTargetInfo.FileLocation> list = targetInfo.getGoTargetInfo().getGeneratedSourcesList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getGeneratedSourcesList(...)");
        return list;
    }

    @Override
    @Nullable
    public GoModule resolveModule(@NotNull BspTargetInfo.TargetInfo targetInfo) {
        List list;
        URI it$iv$iv;
        boolean bl;
        BspTargetInfo.FileLocation it;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
        if (!targetInfo.hasGoTargetInfo()) {
            return null;
        }
        BspTargetInfo.GoTargetInfo goTargetInfo = targetInfo.getGoTargetInfo();
        URI uRI = this.calculateSdkURI(goTargetInfo.getSdkHomePath());
        String string = goTargetInfo.getImportpath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getImportpath(...)");
        List<BspTargetInfo.FileLocation> list2 = goTargetInfo.getGeneratedSourcesList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getGeneratedSourcesList(...)");
        Iterable iterable = list2;
        String string2 = string;
        URI uRI2 = uRI;
        boolean $i$f$mapNotNull = false;
        void var5_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (BspTargetInfo.FileLocation)element$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it);
            if (this.bazelPathsResolver.resolveUri(it) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        List<BspTargetInfo.FileLocation> list4 = goTargetInfo.getGeneratedLibrariesList();
        Intrinsics.checkNotNullExpressionValue(list4, (String)"getGeneratedLibrariesList(...)");
        $this$mapNotNull$iv = list4;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (BspTargetInfo.FileLocation)element$iv$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)it);
            if (this.bazelPathsResolver.resolveUri(it) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list5 = list = (List)destination$iv$iv;
        List list6 = list3;
        String string3 = string2;
        URI uRI3 = uRI2;
        return new GoModule(uRI3, string3, list6, list5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final URI calculateSdkURI(BspTargetInfo.FileLocation sdk) {
        BspTargetInfo.FileLocation fileLocation;
        if (sdk == null) return null;
        BspTargetInfo.FileLocation it = fileLocation = sdk;
        boolean bl = false;
        CharSequence charSequence = it.getRelativePath();
        if (charSequence == null) return null;
        if (charSequence.length() == 0) {
            return null;
        }
        boolean bl2 = false;
        if (bl2) return null;
        BspTargetInfo.FileLocation fileLocation2 = fileLocation;
        BspTargetInfo.FileLocation fileLocation3 = fileLocation2;
        if (fileLocation3 == null) return null;
        it = fileLocation3;
        boolean bl3 = false;
        Path path2 = Paths.get(this.bazelPathsResolver.resolveUri(it));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path goBinaryPath = path2;
        Path goSdkDir = goBinaryPath.getParent().getParent();
        URI uRI = goSdkDir.toUri();
        return uRI;
    }

    @NotNull
    public final BazelResolveLocalToRemoteResult resolveLocalToRemote(@NotNull BazelResolveLocalToRemoteParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Map mapping = new LinkedHashMap();
        for (String local : params.getLocalPaths()) {
            try {
                Path localAbs = Paths.get(local, new String[0]).toAbsolutePath().normalize();
                Path workspaceRoot = this.bazelPathsResolver.unresolvedWorkspaceRoot().toAbsolutePath().normalize();
                if (localAbs.startsWith(workspaceRoot)) {
                    Intrinsics.checkNotNull((Object)localAbs);
                    String relative = this.bazelPathsResolver.getWorkspaceRelativePath(localAbs);
                    mapping.put(local, relative);
                    continue;
                }
                mapping.put(local, StringsKt.replace$default((String)((Object)localAbs).toString(), (String)"\\", (String)"/", (boolean)false, (int)4, null));
            }
            catch (Exception e) {
                BspClientLogger bspClientLogger = this.logger;
                if (bspClientLogger != null) {
                    Object[] objectArray = new Object[]{e};
                    bspClientLogger.warn("Failed to resolve local path '" + local + "': " + e.getMessage(), objectArray);
                }
                mapping.put(local, local);
            }
        }
        return new BazelResolveLocalToRemoteResult(mapping);
    }

    @NotNull
    public final BazelResolveRemoteToLocalResult resolveRemoteToLocal(@NotNull BazelResolveRemoteToLocalParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Map mapping = new LinkedHashMap();
        for (String remote : params.getRemotePaths()) {
            try {
                String normalizedRemotePath = this.normalizeRemotePath(remote, params.getGoRoot());
                File localFile = this.bazelPathsResolver.resolve(normalizedRemotePath);
                File file = localFile.getAbsoluteFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAbsoluteFile(...)");
                String localPath = FilesKt.normalize((File)file).getPath();
                mapping.put(remote, localPath);
            }
            catch (Exception e) {
                BspClientLogger bspClientLogger = this.logger;
                if (bspClientLogger != null) {
                    Object[] objectArray = new Object[]{e};
                    bspClientLogger.warn("Failed to resolve remote path '" + remote + "': " + e.getMessage(), objectArray);
                }
                mapping.put(remote, "");
            }
        }
        return new BazelResolveRemoteToLocalResult(mapping);
    }

    private final String normalizeRemotePath(String path2, String goRoot) {
        Object object;
        if (StringsKt.startsWith$default((String)path2, (String)"/build/work/", (boolean)false, (int)2, null)) {
            object = this.afterNthSlash(path2, 5);
        } else if (StringsKt.startsWith$default((String)path2, (String)"/tmp/go-build-release/buildroot/", (boolean)false, (int)2, null)) {
            object = this.afterNthSlash(path2, 4);
        } else if (StringsKt.startsWith$default((String)path2, (String)"GOROOT/", (boolean)false, (int)2, null)) {
            String suffix = this.afterNthSlash(path2, 1);
            object = StringsKt.removeSuffix((String)goRoot, (CharSequence)"/") + "/" + suffix;
        } else {
            object = path2;
        }
        return object;
    }

    private final String afterNthSlash(String path2, int n) {
        String string;
        int index = 0;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            if ((index = StringsKt.indexOf$default((CharSequence)path2, (char)'/', (int)index, (boolean)false, (int)4, null) + 1) != 0) continue;
            return path2;
        }
        if (index < path2.length()) {
            String string2 = path2.substring(index);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = "";
        }
        return string;
    }
}

