/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.sync.languages.java;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bazel.label.PackageType;
import org.jetbrains.bsp.bazel.server.sync.languages.java.IdeClasspathResolver;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/languages/java/IdeClasspathResolver;", "", "label", "Lorg/jetbrains/bazel/label/Label;", "runtimeClasspath", "Lkotlin/sequences/Sequence;", "Ljava/net/URI;", "compileClasspath", "<init>", "(Lorg/jetbrains/bazel/label/Label;Lkotlin/sequences/Sequence;Lkotlin/sequences/Sequence;)V", "runtimeJars", "", "", "runtimeMavenJarSuffixes", "compileJars", "resolve", "findRuntimeEquivalent", "compileJar", "toMavenSuffix", "uri", "isItJarOfTheCurrentTarget", "", "jar", "Companion", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_languages-languages"})
@SourceDebugExtension(value={"SMAP\nIdeClasspathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeClasspathResolver.kt\norg/jetbrains/bsp/bazel/server/sync/languages/java/IdeClasspathResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1611#2,9:71\n1863#2:80\n1864#2:82\n1620#2:83\n1863#2,2:85\n1#3:81\n1#3:84\n*S KotlinDebug\n*F\n+ 1 IdeClasspathResolver.kt\norg/jetbrains/bsp/bazel/server/sync/languages/java/IdeClasspathResolver\n*L\n12#1:71,9\n12#1:80\n12#1:82\n12#1:83\n40#1:85,2\n12#1:81\n*E\n"})
public final class IdeClasspathResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Label label;
    @NotNull
    private final Set<String> runtimeJars;
    @NotNull
    private final Set<String> runtimeMavenJarSuffixes;
    @NotNull
    private final Sequence<String> compileJars;
    @NotNull
    private static final Regex JAR_PATTERN = new Regex("((-[hi]jar)|(\\.abi))\\.jar$");

    /*
     * WARNING - void declaration
     */
    public IdeClasspathResolver(@NotNull Label label, @NotNull Sequence<URI> runtimeClasspath, @NotNull Sequence<URI> compileClasspath) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter(runtimeClasspath, (String)"runtimeClasspath");
        Intrinsics.checkNotNullParameter(compileClasspath, (String)"compileClasspath");
        this.label = label;
        this.runtimeJars = SequencesKt.toSet((Sequence)SequencesKt.map(runtimeClasspath, (Function1)runtimeJars.1.INSTANCE));
        Iterable iterable = this.runtimeJars;
        IdeClasspathResolver ideClasspathResolver = this;
        boolean $i$f$mapNotNull = false;
        void var6_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String p0 = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.toMavenSuffix(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        ideClasspathResolver.runtimeMavenJarSuffixes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.compileJars = SequencesKt.map(compileClasspath, (Function1)compileJars.1.INSTANCE);
    }

    @NotNull
    public final Sequence<URI> resolve() {
        return SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map(this.compileJars, (Function1)((Function1)new Function1<String, String>((Object)this){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return IdeClasspathResolver.access$findRuntimeEquivalent((IdeClasspathResolver)this.receiver, p0);
            }
        })), (Function1)((Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ IdeClasspathResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Boolean invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return IdeClasspathResolver.access$isItJarOfTheCurrentTarget(this.this$0, it);
            }
        })), (Function1)resolve.3.INSTANCE);
    }

    private final String findRuntimeEquivalent(String compileJar) {
        String string;
        block9: {
            block8: {
                Object v3;
                block7: {
                    String mavenJarSuffix;
                    String string2;
                    Object object;
                    String headerSuffix;
                    Regex regex = JAR_PATTERN;
                    CharSequence charSequence = compileJar;
                    String string3 = ".jar";
                    String runtimeJar = regex.replace(charSequence, string3);
                    if (this.runtimeJars.contains(runtimeJar)) {
                        return runtimeJar;
                    }
                    String string4 = headerSuffix = this.toMavenSuffix(compileJar);
                    if (string4 != null) {
                        String s = string4;
                        boolean bl = false;
                        CharSequence charSequence2 = s;
                        Regex regex2 = new Regex("/header_([^/]+)\\.jar$");
                        object = "/$1.jar";
                        string2 = regex2.replace(charSequence2, (String)object);
                    } else {
                        string2 = null;
                    }
                    if ((string = (mavenJarSuffix = string2)) == null) break block8;
                    String string5 = string;
                    Set<String> set = this.runtimeMavenJarSuffixes;
                    String p0 = string5;
                    boolean bl = false;
                    string = set.contains(p0) ? string5 : null;
                    if (string == null) break block8;
                    String suffix = string;
                    boolean bl2 = false;
                    object = this.runtimeJars;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        String jar = (String)t;
                        boolean bl3 = false;
                        if (!StringsKt.endsWith$default((String)jar, (String)suffix, (boolean)false, (int)2, null)) continue;
                        v3 = t;
                        break block7;
                    }
                    v3 = null;
                }
                String string6 = v3;
                string = string6;
                if (string6 != null) break block9;
            }
            string = compileJar;
        }
        return string;
    }

    private final String toMavenSuffix(String uri) {
        Object[] objectArray = new String[]{"/maven/", "/maven2/"};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String indicator = (String)element$iv;
            boolean bl = false;
            int index = StringsKt.lastIndexOf$default((CharSequence)uri, (String)indicator, (int)0, (boolean)false, (int)6, null);
            if (index < 0) continue;
            String string = uri.substring(index + indicator.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return null;
    }

    private final boolean isItJarOfTheCurrentTarget(String jar) {
        PackageType targetPath = this.label.getPackagePath();
        String targetJar = targetPath + "/" + this.label.getTarget() + ".jar";
        return StringsKt.endsWith$default((String)jar, (String)targetJar, (boolean)false, (int)2, null);
    }

    public static final /* synthetic */ String access$findRuntimeEquivalent(IdeClasspathResolver $this, String compileJar) {
        return $this.findRuntimeEquivalent(compileJar);
    }

    public static final /* synthetic */ boolean access$isItJarOfTheCurrentTarget(IdeClasspathResolver $this, String jar) {
        return $this.isItJarOfTheCurrentTarget(jar);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/languages/java/IdeClasspathResolver$Companion;", "", "<init>", "()V", "JAR_PATTERN", "Lkotlin/text/Regex;", "resolveIdeClasspath", "", "Ljava/net/URI;", "label", "Lorg/jetbrains/bazel/label/Label;", "runtimeClasspath", "compileClasspath", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_languages-languages"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<URI> resolveIdeClasspath(@NotNull Label label, @NotNull List<URI> runtimeClasspath, @NotNull List<URI> compileClasspath) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter(runtimeClasspath, (String)"runtimeClasspath");
            Intrinsics.checkNotNullParameter(compileClasspath, (String)"compileClasspath");
            return SequencesKt.toList(new IdeClasspathResolver(label, (Sequence<URI>)CollectionsKt.asSequence((Iterable)runtimeClasspath), (Sequence<URI>)CollectionsKt.asSequence((Iterable)compileClasspath)).resolve());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

