/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.sync.languages.java;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bsp.bazel.info.BspTargetInfo;
import org.jetbrains.bsp.bazel.server.paths.BazelPathsResolver;
import org.jetbrains.bsp.bazel.server.sync.languages.java.Jdk;
import org.jetbrains.bsp.bazel.server.sync.languages.java.JdkResolver;
import org.jetbrains.bsp.bazel.server.sync.languages.java.JdkVersionResolver;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\fJ$\u0010\u000f\u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00000\u000b2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00000\u000bH\u0002J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00000\u000bH\u0002J \u0010\u0014\u001a\b\u0018\u00010\u0010R\u00020\u00002\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00000\u000bH\u0002J \u0010\u0015\u001a\b\u0018\u00010\u0010R\u00020\u00002\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00000\u000bH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u000b\"\u0004\b\u0000\u0010\u001a*\b\u0012\u0004\u0012\u0002H\u001a0\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JdkResolver;", "", "bazelPathsResolver", "Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;", "jdkVersionResolver", "Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JdkVersionResolver;", "<init>", "(Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JdkVersionResolver;)V", "resolve", "Lorg/jetbrains/bsp/bazel/server/sync/languages/java/Jdk;", "targets", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/bsp/bazel/info/BspTargetInfo$TargetInfo;", "resolveJdk", "target", "candidatesWithLatestVersion", "Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JdkResolver$JdkCandidate;", "candidates", "findLatestVersion", "", "pickCandidateFromJvmRuntime", "pickAnyCandidate", "resolveJdkData", "Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JdkResolver$JdkCandidateData;", "targetInfo", "sortByFrequency", "A", "JdkCandidate", "JdkCandidateData", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_languages-languages"})
@SourceDebugExtension(value={"SMAP\nJdkResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkResolver.kt\norg/jetbrains/bsp/bazel/server/sync/languages/java/JdkResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1#2:85\n1437#3,14:86\n992#3:100\n1021#3,3:101\n1024#3,3:111\n381#4,7:104\n1062#5:114\n1557#5:115\n1628#5,3:116\n*S KotlinDebug\n*F\n+ 1 JdkResolver.kt\norg/jetbrains/bsp/bazel/server/sync/languages/java/JdkResolver\n*L\n33#1:86,14\n78#1:100\n78#1:101,3\n78#1:111,3\n78#1:104,7\n80#1:114\n81#1:115\n81#1:116,3\n*E\n"})
public final class JdkResolver {
    @NotNull
    private final BazelPathsResolver bazelPathsResolver;
    @NotNull
    private final JdkVersionResolver jdkVersionResolver;

    public JdkResolver(@NotNull BazelPathsResolver bazelPathsResolver, @NotNull JdkVersionResolver jdkVersionResolver) {
        Intrinsics.checkNotNullParameter((Object)bazelPathsResolver, (String)"bazelPathsResolver");
        Intrinsics.checkNotNullParameter((Object)jdkVersionResolver, (String)"jdkVersionResolver");
        this.bazelPathsResolver = bazelPathsResolver;
        this.jdkVersionResolver = jdkVersionResolver;
    }

    @Nullable
    public final Jdk resolve(@NotNull Sequence<BspTargetInfo.TargetInfo> targets2) {
        JdkCandidate jdkCandidate;
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        Sequence allCandidates2 = SequencesKt.map(this.sortByFrequency(SequencesKt.mapNotNull(targets2, (Function1)((Function1)new Function1<BspTargetInfo.TargetInfo, JdkCandidateData>(this){
            final /* synthetic */ JdkResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final JdkCandidateData invoke(BspTargetInfo.TargetInfo it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return JdkResolver.access$resolveJdkData(this.this$0, it);
            }
        }))), (Function1)((Function1)new Function1<JdkCandidateData, JdkCandidate>(this){
            final /* synthetic */ JdkResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final JdkCandidate invoke(JdkCandidateData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new JdkCandidate(this.this$0, it);
            }
        }));
        if (SequencesKt.none((Sequence)allCandidates2)) {
            return null;
        }
        Sequence<JdkCandidate> latestVersion = this.candidatesWithLatestVersion((Sequence<JdkCandidate>)allCandidates2);
        Sequence complete2 = SequencesKt.filter((Sequence)allCandidates2, (Function1)resolve.complete.1.INSTANCE);
        Sequence latestVersionAndComplete2 = SequencesKt.filter(latestVersion, (Function1)resolve.latestVersionAndComplete.1.INSTANCE);
        JdkCandidate jdkCandidate2 = this.pickCandidateFromJvmRuntime((Sequence<JdkCandidate>)latestVersionAndComplete2);
        if (jdkCandidate2 == null && (jdkCandidate2 = this.pickAnyCandidate((Sequence<JdkCandidate>)latestVersionAndComplete2)) == null && (jdkCandidate2 = this.pickCandidateFromJvmRuntime((Sequence<JdkCandidate>)complete2)) == null && (jdkCandidate2 = this.pickAnyCandidate((Sequence<JdkCandidate>)complete2)) == null) {
            jdkCandidate2 = this.pickAnyCandidate((Sequence<JdkCandidate>)allCandidates2);
        }
        return (jdkCandidate = jdkCandidate2) != null ? jdkCandidate.asJdk() : null;
    }

    @Nullable
    public final Jdk resolveJdk(@NotNull BspTargetInfo.TargetInfo target) {
        Jdk jdk;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        JdkCandidateData jdkCandidateData = this.resolveJdkData(target);
        if (jdkCandidateData != null) {
            JdkCandidateData it = jdkCandidateData;
            boolean bl = false;
            jdk = new JdkCandidate(this, it).asJdk();
        } else {
            jdk = null;
        }
        return jdk;
    }

    private final Sequence<JdkCandidate> candidatesWithLatestVersion(Sequence<JdkCandidate> candidates) {
        Sequence sequence;
        Sequence sequence2;
        String string = this.findLatestVersion(candidates);
        if (string != null) {
            String version2 = string;
            boolean bl = false;
            sequence2 = SequencesKt.filter(candidates, (Function1)((Function1)new Function1<JdkCandidate, Boolean>(version2){
                final /* synthetic */ String $version;
                {
                    this.$version = $version;
                    super(1);
                }

                public final Boolean invoke(JdkCandidate it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getVersion(), (Object)this.$version);
                }
            }));
        } else {
            sequence2 = sequence = null;
        }
        if (sequence2 == null) {
            sequence = SequencesKt.emptySequence();
        }
        return sequence;
    }

    private final String findLatestVersion(Sequence<JdkCandidate> candidates) {
        Object v0;
        Sequence $this$maxByOrNull$iv = SequencesKt.mapNotNull(candidates, (Function1)findLatestVersion.1.INSTANCE);
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                String it = (String)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = Integer.parseInt(it);
                do {
                    Object e$iv = iterator$iv.next();
                    String it2 = (String)e$iv;
                    $i$a$-maxByOrNull-JdkResolver$findLatestVersion$2 = false;
                    int v$iv = Integer.parseInt(it2);
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    private final JdkCandidate pickCandidateFromJvmRuntime(Sequence<JdkCandidate> candidates) {
        Object v0;
        block1: {
            Sequence<JdkCandidate> sequence = candidates;
            for (Object e : sequence) {
                JdkCandidate it = (JdkCandidate)e;
                boolean bl = false;
                if (!it.isRuntime()) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final JdkCandidate pickAnyCandidate(Sequence<JdkCandidate> candidates) {
        return (JdkCandidate)SequencesKt.firstOrNull(candidates);
    }

    private final JdkCandidateData resolveJdkData(BspTargetInfo.TargetInfo targetInfo) {
        URI uRI;
        Object it;
        BspTargetInfo.FileLocation javaHomeFile;
        boolean hasToolchainJavaHome;
        boolean hasRuntimeJavaHome = targetInfo.hasJavaRuntimeInfo() && targetInfo.getJavaRuntimeInfo().hasJavaHome();
        boolean bl = hasToolchainJavaHome = targetInfo.hasJavaToolchainInfo() && targetInfo.getJavaToolchainInfo().hasJavaHome();
        BspTargetInfo.FileLocation fileLocation = javaHomeFile = hasRuntimeJavaHome ? targetInfo.getJavaRuntimeInfo().getJavaHome() : (hasToolchainJavaHome ? targetInfo.getJavaToolchainInfo().getJavaHome() : null);
        if (fileLocation != null) {
            it = fileLocation;
            boolean bl2 = false;
            uRI = this.bazelPathsResolver.resolveUri((BspTargetInfo.FileLocation)it);
        } else {
            uRI = null;
        }
        URI javaHome = uRI;
        JdkCandidateData jdkCandidateData = new JdkCandidateData(hasRuntimeJavaHome, javaHome);
        it = jdkCandidateData;
        boolean bl3 = false;
        return javaHome != null ? jdkCandidateData : null;
    }

    /*
     * WARNING - void declaration
     */
    private final <A> Sequence<A> sortByFrequency(Sequence<? extends A> $this$sortByFrequency) {
        void $this$mapTo$iv$iv;
        List list$iv$iv;
        Object it;
        Iterable $this$groupByTo$iv$iv;
        Sequence<? extends A> $this$groupBy$iv = $this$sortByFrequency;
        boolean $i$f$groupBy = false;
        Sequence<? extends A> sequence = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            Object key$iv$iv = it;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = destination$iv$iv.values();
        boolean $i$f$sortedByDescending = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                List it = (List)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.size());
                it = (List)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.size()));
            }
        });
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (List)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add(CollectionsKt.first(it));
        }
        return CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
    }

    public static final /* synthetic */ JdkCandidateData access$resolveJdkData(JdkResolver $this, BspTargetInfo.TargetInfo targetInfo) {
        return $this.resolveJdkData(targetInfo);
    }

    public static final /* synthetic */ JdkVersionResolver access$getJdkVersionResolver$p(JdkResolver $this) {
        return $this.jdkVersionResolver;
    }

    /*
     * Exception performing whole class analysis.
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u0004\u0018\u00010\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f*\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0013*\u0004\b\u0012\u0010\rR\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JdkResolver$JdkCandidate;", "", "data", "Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JdkResolver$JdkCandidateData;", "<init>", "(Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JdkResolver;Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JdkResolver$JdkCandidateData;)V", "version", "", "getVersion", "()Ljava/lang/String;", "javaHome", "Ljava/net/URI;", "getJavaHome$delegate", "(Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JdkResolver$JdkCandidate;)Ljava/lang/Object;", "getJavaHome", "()Ljava/net/URI;", "isRuntime", "", "isRuntime$delegate", "()Z", "isComplete", "asJdk", "Lorg/jetbrains/bsp/bazel/server/sync/languages/java/Jdk;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_languages-languages"})
    @SourceDebugExtension(value={"SMAP\nJdkResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkResolver.kt\norg/jetbrains/bsp/bazel/server/sync/languages/java/JdkResolver$JdkCandidate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
    private final class JdkCandidate {
        @NotNull
        private final JdkCandidateData data;
        @Nullable
        private final String version;
        private final boolean isComplete;
        final /* synthetic */ JdkResolver this$0;

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public JdkCandidate(@NotNull JdkResolver this$0, JdkCandidateData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.this$0 = this$0;
            super();
            this.data = data;
            v0 = this;
            var3_3 = this.data.getJavaHome();
            if (var3_3 == null) ** GOTO lbl-1000
            v1 = Paths.get(var3_3);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"get(...)");
            var4_4 = v1;
            if (var4_4 == null) ** GOTO lbl-1000
            var6_5 = var4_4;
            var7_6 = var6_5;
            var11_7 = v0;
            $i$a$-takeIf-JdkResolver$JdkCandidate$version$1 = false;
            v2 = new LinkOption[]{};
            var12_10 = Files.exists((Path)it, Arrays.copyOf(v2, v2.length));
            v0 = var11_7;
            v3 /* !! */  = var5_11 = var12_10 != false ? var6_5 : null;
            if (var5_11 == null) ** GOTO lbl-1000
            var7_6 = var5_11;
            var8_9 = this.this$0;
            var9_12 = var7_6;
            var11_7 = v0;
            $i$a$-let-JdkResolver$JdkCandidate$version$2 = false;
            v0 = var11_7;
            var6_5 = JdkResolver.access$getJdkVersionResolver$p(var8_9).resolve((Path)it);
            if (var6_5 != null) {
                v4 = var6_5.toString();
            } else lbl-1000:
            // 4 sources

            {
                v4 = null;
            }
            v0.version = v4;
            this.isComplete = this.getJavaHome() != null && this.version != null;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        @Nullable
        public final URI getJavaHome() {
            return this.data.getJavaHome();
        }

        private static Object getJavaHome$delegate(JdkCandidate jdkCandidate) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)jdkCandidate.data, JdkCandidateData.class, "javaHome", "getJavaHome()Ljava/net/URI;", 0)));
        }

        public final boolean isRuntime() {
            return this.data.isRuntime();
        }

        private static Object isRuntime$delegate(JdkCandidate jdkCandidate) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)jdkCandidate.data, JdkCandidateData.class, "isRuntime", "isRuntime()Z", 0)));
        }

        public final boolean isComplete() {
            return this.isComplete;
        }

        @Nullable
        public final Jdk asJdk() {
            Jdk jdk;
            String string = this.version;
            if (string != null) {
                String it = string;
                boolean bl = false;
                jdk = new Jdk(it, this.getJavaHome());
            } else {
                jdk = null;
            }
            return jdk;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JdkResolver$JdkCandidateData;", "", "isRuntime", "", "javaHome", "Ljava/net/URI;", "<init>", "(ZLjava/net/URI;)V", "()Z", "getJavaHome", "()Ljava/net/URI;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_languages-languages"})
    private static final class JdkCandidateData {
        private final boolean isRuntime;
        @Nullable
        private final URI javaHome;

        public JdkCandidateData(boolean isRuntime, @Nullable URI javaHome) {
            this.isRuntime = isRuntime;
            this.javaHome = javaHome;
        }

        public final boolean isRuntime() {
            return this.isRuntime;
        }

        @Nullable
        public final URI getJavaHome() {
            return this.javaHome;
        }

        public final boolean component1() {
            return this.isRuntime;
        }

        @Nullable
        public final URI component2() {
            return this.javaHome;
        }

        @NotNull
        public final JdkCandidateData copy(boolean isRuntime, @Nullable URI javaHome) {
            return new JdkCandidateData(isRuntime, javaHome);
        }

        public static /* synthetic */ JdkCandidateData copy$default(JdkCandidateData jdkCandidateData, boolean bl, URI uRI, int n, Object object) {
            if ((n & 1) != 0) {
                bl = jdkCandidateData.isRuntime;
            }
            if ((n & 2) != 0) {
                uRI = jdkCandidateData.javaHome;
            }
            return jdkCandidateData.copy(bl, uRI);
        }

        @NotNull
        public String toString() {
            return "JdkCandidateData(isRuntime=" + this.isRuntime + ", javaHome=" + this.javaHome + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.isRuntime);
            result2 = result2 * 31 + (this.javaHome == null ? 0 : this.javaHome.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JdkCandidateData)) {
                return false;
            }
            JdkCandidateData jdkCandidateData = (JdkCandidateData)other;
            if (this.isRuntime != jdkCandidateData.isRuntime) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.javaHome, (Object)jdkCandidateData.javaHome);
        }
    }
}

