/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.sync.languages.java;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u001bR\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JdkVersionResolver;", "", "<init>", "()V", "versions", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "", "resolve", "path", "(Ljava/nio/file/Path;)Ljava/lang/Integer;", "resolveJavaVersion", "readFromReleaseFile", "readByRunningJavaBinary", "firstLineOfJavaVersionOutput", "", "javaPath", "readLines", "", "process", "Ljava/lang/Process;", "quotedVersionPattern", "Lkotlin/text/Regex;", "releaseFileVersionPattern", "parseVersion", "text", "regex", "(Ljava/lang/String;Lkotlin/text/Regex;)Ljava/lang/Integer;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_languages-languages"})
@SourceDebugExtension(value={"SMAP\nJdkVersionResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkVersionResolver.kt\norg/jetbrains/bsp/bazel/server/sync/languages/java/JdkVersionResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,55:1\n1#2:56\n648#3,5:57\n*S KotlinDebug\n*F\n+ 1 JdkVersionResolver.kt\norg/jetbrains/bsp/bazel/server/sync/languages/java/JdkVersionResolver\n*L\n52#1:57,5\n*E\n"})
public final class JdkVersionResolver {
    @NotNull
    private final ConcurrentHashMap<Path, Integer> versions = new ConcurrentHashMap();
    @NotNull
    private final Regex quotedVersionPattern = new Regex("\"(\\d+(?:.\\d+)*)\"");
    @NotNull
    private final Regex releaseFileVersionPattern = new Regex("JAVA_VERSION=" + this.quotedVersionPattern.getPattern());

    @Nullable
    public final Integer resolve(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Function1 function1 = (Function1)new Function1<Path, Integer>(this){
            final /* synthetic */ JdkVersionResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Integer invoke(Path it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return JdkVersionResolver.access$resolveJavaVersion(this.this$0, it);
            }
        };
        return this.versions.computeIfAbsent(path2.toRealPath(new LinkOption[0]), new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        });
    }

    private final Integer resolveJavaVersion(Path path2) {
        Integer n = this.readFromReleaseFile(path2);
        if (n == null) {
            n = this.readByRunningJavaBinary(path2);
        }
        return n;
    }

    private final Integer readFromReleaseFile(Path path2) {
        Path releasePath = path2.resolve("release");
        if (Files.notExists(releasePath, new LinkOption[0])) {
            return null;
        }
        String text = Files.readString(releasePath);
        Intrinsics.checkNotNull((Object)text);
        return this.parseVersion(text, this.releaseFileVersionPattern);
    }

    private final Integer readByRunningJavaBinary(Path path2) {
        Integer n;
        Path javaPath = path2.resolve("bin").resolve("java");
        if (Files.notExists(javaPath, new LinkOption[0])) {
            return null;
        }
        Intrinsics.checkNotNull((Object)javaPath);
        String string = this.firstLineOfJavaVersionOutput(javaPath);
        if (string != null) {
            String it = string;
            boolean bl = false;
            n = this.parseVersion(it, this.quotedVersionPattern);
        } else {
            n = null;
        }
        return n;
    }

    private final String firstLineOfJavaVersionOutput(Path javaPath) {
        String string;
        String[] stringArray = new String[]{((Object)javaPath).toString(), "-version"};
        Process process = new ProcessBuilder(stringArray).redirectErrorStream(true).start();
        int result2 = process.waitFor();
        if (result2 == 0) {
            Intrinsics.checkNotNull((Object)process);
            string = (String)CollectionsKt.firstOrNull(this.readLines(process));
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<String> readLines(Process process) {
        InputStream inputStream2 = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
        Closeable closeable = inputStream2;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return StringsKt.lines((CharSequence)((CharSequence)object2));
    }

    private final Integer parseVersion(String text, Regex regex) {
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)text, (int)0, (int)2, null);
        if (matchResult != null) {
            String string;
            block2: {
                String version2;
                MatchResult match = matchResult;
                boolean bl = false;
                String $this$takeWhile$iv = version2 = StringsKt.removePrefix((String)((String)match.getGroupValues().get(1)), (CharSequence)"1.");
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl2 = false;
                    if (it != '.') continue;
                    String string2 = $this$takeWhile$iv;
                    int n2 = 0;
                    String string3 = string2.substring(n2, index$iv);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    break block2;
                }
                string = $this$takeWhile$iv;
            }
            return StringsKt.toIntOrNull((String)string);
        }
        return null;
    }

    public static final /* synthetic */ Integer access$resolveJavaVersion(JdkVersionResolver $this, Path path2) {
        return $this.resolveJavaVersion(path2);
    }
}

