/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.sync.languages.jvm;

import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0004\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/languages/jvm/SourceRootGuesser;", "", "<init>", "()V", "getSourcesRoot", "Ljava/nio/file/Path;", "sourcePath", "", "sourceUri", "Ljava/net/URI;", "approximateSourceRoot", "dir", "matcher", "Ljava/nio/file/PathMatcher;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_languages-languages"})
public final class SourceRootGuesser {
    @NotNull
    public static final SourceRootGuesser INSTANCE = new SourceRootGuesser();

    private SourceRootGuesser() {
    }

    @NotNull
    public final Path getSourcesRoot(@NotNull Path sourcePath) {
        Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
        FileSystem fs = FileSystems.getDefault();
        PathMatcher sourceRootPattern = fs.getPathMatcher("glob:**/{main,test,tests,src,3rdparty,3rd_party,thirdparty,third_party}/{*resources,scala,java,kotlin,jvm,proto,python,protobuf,py}");
        PathMatcher defaultTestRootPattern = fs.getPathMatcher("glob:**/{test,tests}");
        Object[] objectArray = new PathMatcher[]{sourceRootPattern, defaultTestRootPattern};
        Path sourceRootGuess2 = (Path)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Function1)((Function1)new Function1<PathMatcher, Path>(sourcePath){
            final /* synthetic */ Path $sourcePath;
            {
                this.$sourcePath = $sourcePath;
                super(1);
            }

            public final Path invoke(PathMatcher pattern) {
                Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
                return SourceRootGuesser.access$approximateSourceRoot(SourceRootGuesser.INSTANCE, this.$sourcePath, pattern);
            }
        })));
        Path path2 = sourceRootGuess2;
        if (path2 == null) {
            path2 = sourcePath.getParent();
        }
        Path path3 = path2.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toAbsolutePath(...)");
        return path3;
    }

    @NotNull
    public final String getSourcesRoot(@NotNull URI sourceUri) {
        Intrinsics.checkNotNullParameter((Object)sourceUri, (String)"sourceUri");
        Path path2 = Paths.get(sourceUri);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        return ((Object)this.getSourcesRoot(path2)).toString();
    }

    private final Path approximateSourceRoot(Path dir, PathMatcher matcher) {
        for (Path guess = dir; guess != null; guess = guess.getParent()) {
            if (!matcher.matches(guess)) continue;
            return guess;
        }
        return null;
    }

    public static final /* synthetic */ Path access$approximateSourceRoot(SourceRootGuesser $this, Path dir, PathMatcher matcher) {
        return $this.approximateSourceRoot(dir, matcher);
    }
}

