/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.sync.languages.scala;

import ch.epfl.scala.bsp4j.BuildTarget;
import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import ch.epfl.scala.bsp4j.JvmBuildTarget;
import ch.epfl.scala.bsp4j.ScalaBuildTarget;
import ch.epfl.scala.bsp4j.ScalaMainClass;
import ch.epfl.scala.bsp4j.ScalaMainClassesItem;
import ch.epfl.scala.bsp4j.ScalaPlatform;
import ch.epfl.scala.bsp4j.ScalaTestClassesItem;
import com.google.protobuf.ProtocolStringList;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.info.BspTargetInfo;
import org.jetbrains.bsp.bazel.server.dependencygraph.DependencyGraph;
import org.jetbrains.bsp.bazel.server.label.LabelKt;
import org.jetbrains.bsp.bazel.server.model.BspMappings;
import org.jetbrains.bsp.bazel.server.model.Language;
import org.jetbrains.bsp.bazel.server.model.LanguageData;
import org.jetbrains.bsp.bazel.server.model.Module;
import org.jetbrains.bsp.bazel.server.model.Tag;
import org.jetbrains.bsp.bazel.server.paths.BazelPathsResolver;
import org.jetbrains.bsp.bazel.server.sync.languages.JVMLanguagePluginParser;
import org.jetbrains.bsp.bazel.server.sync.languages.LanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.SourceRootAndData;
import org.jetbrains.bsp.bazel.server.sync.languages.java.JavaLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.java.JavaModule;
import org.jetbrains.bsp.bazel.server.sync.languages.scala.ScalaLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.scala.ScalaModule;
import org.jetbrains.bsp.bazel.server.sync.languages.scala.ScalaSdk;
import org.jetbrains.bsp.bazel.server.sync.languages.scala.ScalaSdkResolver;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J2\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u0002H\u001d0\n\"\u0004\b\u0000\u0010\u001c\"\u0004\b\u0001\u0010\u001d*\u0010\u0012\u0004\u0012\u0002H\u001c\u0012\u0006\u0012\u0004\u0018\u0001H\u001d0\nH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020\u001aH\u0016J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&H\u0014J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010-\u001a\u00020.J7\u00101\u001a\u0004\u0018\u0001H2\"\u0004\b\u0000\u001022\u0006\u0010-\u001a\u00020.2\u0018\u00103\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u0002H204H\u0002\u00a2\u0006\u0002\u00106J9\u00107\u001a\u0004\u0018\u0001H2\"\u0004\b\u0000\u001022\u0006\u0010-\u001a\u00020.2\u001a\u00103\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u000205\u0012\u0006\u0012\u0004\u0018\u0001H204H\u0002\u00a2\u0006\u0002\u00106J\u001e\u00108\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u000205\u0018\u0001092\u0006\u0010-\u001a\u00020.H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R,\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000e\"\u0004\b\u0015\u0010\u0010\u00a8\u0006:"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/languages/scala/ScalaLanguagePlugin;", "Lorg/jetbrains/bsp/bazel/server/sync/languages/LanguagePlugin;", "Lorg/jetbrains/bsp/bazel/server/sync/languages/scala/ScalaModule;", "javaLanguagePlugin", "Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JavaLanguagePlugin;", "bazelPathsResolver", "Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;", "<init>", "(Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JavaLanguagePlugin;Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;)V", "scalaSdks", "", "Lorg/jetbrains/bazel/label/Label;", "Lorg/jetbrains/bsp/bazel/server/sync/languages/scala/ScalaSdk;", "getScalaSdks", "()Ljava/util/Map;", "setScalaSdks", "(Ljava/util/Map;)V", "scalaTestJars", "", "Ljava/net/URI;", "getScalaTestJars", "setScalaTestJars", "prepareSync", "", "targets", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/bsp/bazel/info/BspTargetInfo$TargetInfo;", "filterValuesNotNull", "K", "V", "resolveModule", "targetInfo", "dependencySources", "dependencyGraph", "Lorg/jetbrains/bsp/bazel/server/dependencygraph/DependencyGraph;", "applyModuleData", "moduleData", "buildTarget", "Lch/epfl/scala/bsp4j/BuildTarget;", "calculateSourceRootAndAdditionalData", "Lorg/jetbrains/bsp/bazel/server/sync/languages/SourceRootAndData;", "source", "Ljava/nio/file/Path;", "toScalaTestClassesItem", "Lch/epfl/scala/bsp4j/ScalaTestClassesItem;", "module", "Lorg/jetbrains/bsp/bazel/server/model/Module;", "toScalaMainClassesItem", "Lch/epfl/scala/bsp4j/ScalaMainClassesItem;", "withScalaAndJavaModules", "T", "f", "Lkotlin/Function2;", "Lorg/jetbrains/bsp/bazel/server/sync/languages/java/JavaModule;", "(Lorg/jetbrains/bsp/bazel/server/model/Module;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "withScalaAndJavaModulesOpt", "getScalaAndJavaModules", "Lkotlin/Pair;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_languages-languages"})
@SourceDebugExtension(value={"SMAP\nScalaLanguagePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScalaLanguagePlugin.kt\norg/jetbrains/bsp/bazel/server/sync/languages/scala/ScalaLanguagePlugin\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n693#2:133\n726#2,4:134\n693#2:138\n726#2,2:139\n729#2:145\n1557#3:141\n1628#3,3:142\n1246#3,4:155\n1557#3:159\n1628#3,3:160\n503#4,7:146\n462#4:153\n412#4:154\n1#5:163\n*S KotlinDebug\n*F\n+ 1 ScalaLanguagePlugin.kt\norg/jetbrains/bsp/bazel/server/sync/languages/scala/ScalaLanguagePlugin\n*L\n35#1:133\n35#1:134,4\n42#1:138\n42#1:139,2\n42#1:145\n46#1:141\n46#1:142,3\n52#1:155,4\n75#1:159\n75#1:160,3\n52#1:146,7\n52#1:153\n52#1:154\n*E\n"})
public final class ScalaLanguagePlugin
extends LanguagePlugin<ScalaModule> {
    @NotNull
    private final JavaLanguagePlugin javaLanguagePlugin;
    @NotNull
    private final BazelPathsResolver bazelPathsResolver;
    @NotNull
    private Map<Label, ScalaSdk> scalaSdks;
    @NotNull
    private Map<Label, ? extends Set<URI>> scalaTestJars;

    public ScalaLanguagePlugin(@NotNull JavaLanguagePlugin javaLanguagePlugin, @NotNull BazelPathsResolver bazelPathsResolver) {
        Intrinsics.checkNotNullParameter((Object)javaLanguagePlugin, (String)"javaLanguagePlugin");
        Intrinsics.checkNotNullParameter((Object)bazelPathsResolver, (String)"bazelPathsResolver");
        this.javaLanguagePlugin = javaLanguagePlugin;
        this.bazelPathsResolver = bazelPathsResolver;
        this.scalaSdks = MapsKt.emptyMap();
        this.scalaTestJars = MapsKt.emptyMap();
    }

    @NotNull
    public final Map<Label, ScalaSdk> getScalaSdks() {
        return this.scalaSdks;
    }

    public final void setScalaSdks(@NotNull Map<Label, ScalaSdk> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.scalaSdks = map;
    }

    @NotNull
    public final Map<Label, Set<URI>> getScalaTestJars() {
        return this.scalaTestJars;
    }

    public final void setScalaTestJars(@NotNull Map<Label, ? extends Set<URI>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.scalaTestJars = map;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void prepareSync(@NotNull Sequence<BspTargetInfo.TargetInfo> targets2) {
        void $this$associateByTo$iv$iv;
        Object object;
        Object object2;
        void $this$associateByTo$iv$iv2;
        Sequence $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        Sequence<BspTargetInfo.TargetInfo> sequence = targets2;
        ScalaSdkResolver scalaSdkResolver = new ScalaSdkResolver(this.bazelPathsResolver);
        Object object3 = this;
        ScalaLanguagePlugin scalaLanguagePlugin = this;
        boolean $i$f$associateBy22 = false;
        void var5_9 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv2) {
            void p0;
            BspTargetInfo.TargetInfo targetInfo = (BspTargetInfo.TargetInfo)element$iv$iv2;
            object2 = destination$iv$iv;
            boolean bl = false;
            BspTargetInfo.TargetInfo it = (BspTargetInfo.TargetInfo)element$iv$iv2;
            object = LabelKt.label(it);
            boolean bl2 = false;
            ScalaSdk scalaSdk = scalaSdkResolver.resolveSdk((BspTargetInfo.TargetInfo)p0);
            object2.put(object, scalaSdk);
        }
        object2 = destination$iv$iv;
        scalaLanguagePlugin.scalaSdks = ((ScalaLanguagePlugin)object3).filterValuesNotNull((Map)object2);
        $this$associateBy$iv = SequencesKt.filter(targets2, (Function1)prepareSync.3.INSTANCE);
        scalaLanguagePlugin = this;
        boolean $i$f$associateBy = false;
        Sequence $i$f$associateBy22 = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object element$iv$iv2;
            element$iv$iv2 = (BspTargetInfo.TargetInfo)element$iv$iv;
            object3 = destination$iv$iv2;
            boolean bl = false;
            BspTargetInfo.TargetInfo it = (BspTargetInfo.TargetInfo)element$iv$iv;
            object2 = LabelKt.label(it);
            boolean bl3 = false;
            List<BspTargetInfo.FileLocation> list = it.getScalaTargetInfo().getScalatestClasspathList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getScalatestClasspathList(...)");
            Iterable bl2 = list;
            BazelPathsResolver bazelPathsResolver = this.bazelPathsResolver;
            boolean $i$f$map = false;
            void var14_27 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                BspTargetInfo.FileLocation fileLocation = (BspTargetInfo.FileLocation)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl4 = false;
                collection.add(bazelPathsResolver.resolveUri((BspTargetInfo.FileLocation)p0));
            }
            object = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
            object3.put(object2, object);
        }
        scalaLanguagePlugin.scalaTestJars = destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final <K, V> Map<K, V> filterValuesNotNull(Map<K, ? extends V> $this$filterValuesNotNull) {
        void $this$mapValuesTo$iv$iv;
        Map<K, V> $this$filterValues$iv = $this$filterValuesNotNull;
        boolean $i$f$filterValues = false;
        Map<K, V> result$iv = new LinkedHashMap();
        for (Map.Entry<K, V> entry$iv : $this$filterValues$iv.entrySet()) {
            V it = entry$iv.getValue();
            boolean bl = false;
            if (!(it != null)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$mapValues$iv = result$iv;
        boolean $i$f$mapValues = false;
        result$iv = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Object v;
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl2 = false;
            Intrinsics.checkNotNull(it.getValue());
            map2.put(k, v);
        }
        return destination$iv$iv;
    }

    @Override
    @Nullable
    public ScalaModule resolveModule(@NotNull BspTargetInfo.TargetInfo targetInfo) {
        Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
        if (!targetInfo.hasScalaTargetInfo()) {
            return null;
        }
        BspTargetInfo.ScalaTargetInfo scalaTargetInfo = targetInfo.getScalaTargetInfo();
        ScalaSdk scalaSdk = this.scalaSdks.get(LabelKt.label(targetInfo));
        if (scalaSdk == null) {
            return null;
        }
        ScalaSdk sdk = scalaSdk;
        ProtocolStringList scalacOpts = scalaTargetInfo.getScalacOptsList();
        Intrinsics.checkNotNull((Object)scalacOpts);
        return new ScalaModule(sdk, (List)scalacOpts, this.javaLanguagePlugin.resolveModule(targetInfo));
    }

    @Override
    @NotNull
    public Set<URI> dependencySources(@NotNull BspTargetInfo.TargetInfo targetInfo, @NotNull DependencyGraph dependencyGraph2) {
        Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
        Intrinsics.checkNotNullParameter((Object)dependencyGraph2, (String)"dependencyGraph");
        return this.javaLanguagePlugin.dependencySources(targetInfo, dependencyGraph2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void applyModuleData(@NotNull ScalaModule moduleData, @NotNull BuildTarget buildTarget) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        JavaLanguagePlugin $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        Intrinsics.checkNotNullParameter((Object)buildTarget, (String)"buildTarget");
        ScalaSdk $this$applyModuleData_u24lambda_u247 = moduleData.getSdk();
        boolean bl = false;
        Iterable iterable = $this$applyModuleData_u24lambda_u247.getCompilerJars();
        ScalaPlatform scalaPlatform = ScalaPlatform.JVM;
        String string = $this$applyModuleData_u24lambda_u247.getBinaryVersion();
        String string2 = $this$applyModuleData_u24lambda_u247.getVersion();
        String string3 = $this$applyModuleData_u24lambda_u247.getOrganization();
        boolean $i$f$map = false;
        void var12_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            URI uRI = (URI)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.toString());
        }
        collection = (List)destination$iv$iv;
        List list = CollectionsKt.toList((Iterable)collection);
        ScalaPlatform scalaPlatform2 = scalaPlatform;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        ScalaBuildTarget scalaBuildTarget = new ScalaBuildTarget(string6, string5, string4, scalaPlatform2, list);
        JavaModule javaModule = moduleData.getJavaModule();
        if (javaModule != null) {
            JavaModule javaModule2 = javaModule;
            $this$map$iv = this.javaLanguagePlugin;
            JavaModule p0 = javaModule2;
            boolean bl3 = false;
            JvmBuildTarget jvmBuildTarget = $this$map$iv.toJvmBuildTarget(p0);
            javaModule = jvmBuildTarget;
            if (jvmBuildTarget != null) {
                JavaModule it = javaModule;
                boolean bl4 = false;
                scalaBuildTarget.setJvmBuildTarget((JvmBuildTarget)it);
            }
        }
        buildTarget.setDataKind("scala");
        buildTarget.setData((Object)scalaBuildTarget);
    }

    @Override
    @NotNull
    public SourceRootAndData calculateSourceRootAndAdditionalData(@NotNull Path source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return JVMLanguagePluginParser.INSTANCE.calculateJVMSourceRootAndAdditionalData(source, true);
    }

    @Nullable
    public final ScalaTestClassesItem toScalaTestClassesItem(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return !module.getTags().contains((Object)Tag.TEST) || !module.getLanguages().contains((Object)Language.SCALA) ? null : (ScalaTestClassesItem)this.withScalaAndJavaModules(module, (Function2)new Function2<ScalaModule, JavaModule, ScalaTestClassesItem>(module){
            final /* synthetic */ Module $module;
            {
                this.$module = $module;
                super(2);
            }

            public final ScalaTestClassesItem invoke(ScalaModule scalaModule, JavaModule javaModule) {
                Intrinsics.checkNotNullParameter((Object)scalaModule, (String)"<unused var>");
                Intrinsics.checkNotNullParameter((Object)javaModule, (String)"javaModule");
                List mainClasses = CollectionsKt.listOfNotNull((Object)javaModule.getMainClass());
                BuildTargetIdentifier id = BspMappings.INSTANCE.toBspId(this.$module);
                return new ScalaTestClassesItem(id, mainClasses);
            }
        });
    }

    @Nullable
    public final ScalaMainClassesItem toScalaMainClassesItem(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return !module.getTags().contains((Object)Tag.APPLICATION) || !module.getLanguages().contains((Object)Language.SCALA) ? null : (ScalaMainClassesItem)this.withScalaAndJavaModulesOpt(module, (Function2)new Function2<ScalaModule, JavaModule, ScalaMainClassesItem>(module){
            final /* synthetic */ Module $module;
            {
                this.$module = $module;
                super(2);
            }

            public final ScalaMainClassesItem invoke(ScalaModule scalaModule, JavaModule javaModule) {
                ScalaMainClassesItem scalaMainClassesItem;
                Intrinsics.checkNotNullParameter((Object)scalaModule, (String)"<unused var>");
                Intrinsics.checkNotNullParameter((Object)javaModule, (String)"javaModule");
                String string = javaModule.getMainClass();
                if (string != null) {
                    String string2 = string;
                    Module module = this.$module;
                    String mainClass = string2;
                    boolean bl = false;
                    BuildTargetIdentifier id = BspMappings.INSTANCE.toBspId(module);
                    List<String> args = javaModule.getArgs();
                    List<String> jvmOpts = javaModule.getJvmOps();
                    ScalaMainClass scalaMainClass = new ScalaMainClass(mainClass, CollectionsKt.toList((Iterable)args), CollectionsKt.toList((Iterable)jvmOpts));
                    List mainClasses = CollectionsKt.listOf((Object)scalaMainClass);
                    scalaMainClassesItem = new ScalaMainClassesItem(id, mainClasses);
                } else {
                    scalaMainClassesItem = null;
                }
                return scalaMainClassesItem;
            }
        });
    }

    private final <T> T withScalaAndJavaModules(Module module, Function2<? super ScalaModule, ? super JavaModule, ? extends T> f) {
        Object object;
        Pair<ScalaModule, JavaModule> pair = this.getScalaAndJavaModules(module);
        if (pair != null) {
            Pair<ScalaModule, JavaModule> pair2 = pair;
            boolean bl = false;
            ScalaModule a = (ScalaModule)pair2.component1();
            JavaModule b = (JavaModule)pair2.component2();
            object = f.invoke((Object)a, (Object)b);
        } else {
            object = null;
        }
        return (T)object;
    }

    private final <T> T withScalaAndJavaModulesOpt(Module module, Function2<? super ScalaModule, ? super JavaModule, ? extends T> f) {
        Object object;
        Pair<ScalaModule, JavaModule> pair = this.getScalaAndJavaModules(module);
        if (pair != null) {
            Pair<ScalaModule, JavaModule> pair2 = pair;
            boolean bl = false;
            ScalaModule a = (ScalaModule)pair2.component1();
            JavaModule b = (JavaModule)pair2.component2();
            object = f.invoke((Object)a, (Object)b);
        } else {
            object = null;
        }
        return (T)object;
    }

    private final Pair<ScalaModule, JavaModule> getScalaAndJavaModules(Module module) {
        Pair pair;
        LanguageData languageData = module.getLanguageData();
        ScalaModule scalaModule = languageData instanceof ScalaModule ? (ScalaModule)languageData : null;
        if (scalaModule != null) {
            ScalaModule scala = scalaModule;
            boolean bl = false;
            JavaModule javaModule = scala.getJavaModule();
            if (javaModule != null) {
                JavaModule it = javaModule;
                boolean bl2 = false;
                pair = new Pair((Object)scala, (Object)it);
            } else {
                pair = null;
            }
        } else {
            pair = null;
        }
        return pair;
    }
}

