/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.sync.languages.scala;

import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bsp.bazel.info.BspTargetInfo;
import org.jetbrains.bsp.bazel.server.paths.BazelPathsResolver;
import org.jetbrains.bsp.bazel.server.sync.languages.scala.ScalaSdk;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/languages/scala/ScalaSdkResolver;", "", "bazelPathsResolver", "Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;", "<init>", "(Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;)V", "resolveSdk", "Lorg/jetbrains/bsp/bazel/server/sync/languages/scala/ScalaSdk;", "targetInfo", "Lorg/jetbrains/bsp/bazel/info/BspTargetInfo$TargetInfo;", "extractVersion", "", "path", "Ljava/nio/file/Path;", "toBinaryVersion", "version", "Companion", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_languages-languages"})
@SourceDebugExtension(value={"SMAP\nScalaSdkResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScalaSdkResolver.kt\norg/jetbrains/bsp/bazel/server/sync/languages/scala/ScalaSdkResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,48:1\n1611#2,9:49\n1863#2:58\n1864#2:60\n1620#2:61\n1557#2:63\n1628#2,3:64\n1#3:59\n1#3:62\n37#4:67\n36#4,3:68\n*S KotlinDebug\n*F\n+ 1 ScalaSdkResolver.kt\norg/jetbrains/bsp/bazel/server/sync/languages/scala/ScalaSdkResolver\n*L\n16#1:49,9\n16#1:58\n16#1:60\n16#1:61\n26#1:63\n26#1:64,3\n16#1:59\n39#1:67\n39#1:68,3\n*E\n"})
public final class ScalaSdkResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BazelPathsResolver bazelPathsResolver;
    private static final Pattern VERSION_PATTERN = Pattern.compile("(?:processed_)?scala3?-(?:library|compiler|reflect)(?:_3)?-([.\\d]+)\\.jar");

    public ScalaSdkResolver(@NotNull BazelPathsResolver bazelPathsResolver) {
        Intrinsics.checkNotNullParameter((Object)bazelPathsResolver, (String)"bazelPathsResolver");
        this.bazelPathsResolver = bazelPathsResolver;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ScalaSdk resolveSdk(@NotNull BspTargetInfo.TargetInfo targetInfo) {
        Collection<URI> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterator $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
        if (!targetInfo.hasScalaTargetInfo()) {
            return null;
        }
        BspTargetInfo.ScalaTargetInfo scalaTarget = targetInfo.getScalaTargetInfo();
        List<BspTargetInfo.FileLocation> list = scalaTarget.getCompilerClasspathList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getCompilerClasspathList(...)");
        List compilerJars = CollectionsKt.sorted((Iterable)this.bazelPathsResolver.resolvePaths(list));
        Iterable $this$mapNotNull$iv = compilerJars;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl4 = false;
            Path p0 = (Path)element$iv$iv;
            boolean bl2 = false;
            if (this.extractVersion(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List maybeVersions = (List)destination$iv$iv;
        if (CollectionsKt.none((Iterable)maybeVersions)) {
            return null;
        }
        $this$mapNotNullTo$iv$iv = ((Iterable)CollectionsKt.distinct((Iterable)maybeVersions)).iterator();
        if (!$this$mapNotNullTo$iv$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        String it = (String)$this$mapNotNullTo$iv$iv.next();
        boolean bl = false;
        Object object = (Comparable)((Object)it);
        while ($this$mapNotNullTo$iv$iv.hasNext()) {
            Object it2 = (String)$this$mapNotNullTo$iv$iv.next();
            $i$a$-maxOf-ScalaSdkResolver$resolveSdk$version$2 = false;
            if (object.compareTo(it2 = (Comparable)it2) >= 0) continue;
            object = it2;
        }
        String version2 = (String)object;
        String binaryVersion = this.toBinaryVersion(version2);
        $this$mapNotNullTo$iv$iv = compilerJars;
        object = this.bazelPathsResolver;
        String string = binaryVersion;
        String string2 = version2;
        String string3 = "org.scala-lang";
        boolean $i$f$map = false;
        void $i$a$-maxOf-ScalaSdkResolver$resolveSdk$version$2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Path bl4 = (Path)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl5 = false;
            collection.add(((BazelPathsResolver)object).resolveUri((Path)p0));
        }
        Collection<URI> collection2 = collection = (List)destination$iv$iv2;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        return new ScalaSdk(string6, string5, string4, (List<URI>)collection2);
    }

    private final String extractVersion(Path path2) {
        String name = ((Object)path2.getFileName()).toString();
        Matcher matcher = VERSION_PATTERN.matcher(name);
        return matcher.matches() ? matcher.group(1) : null;
    }

    private final String toBinaryVersion(String version2) {
        CharSequence charSequence = version2;
        Regex regex = new Regex("\\.");
        int n = 0;
        Collection $this$toTypedArray$iv = regex.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return CollectionsKt.joinToString$default((Iterable)ArraysKt.take((Object[])thisCollection$iv.toArray(new String[0]), (int)2), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/languages/scala/ScalaSdkResolver$Companion;", "", "<init>", "()V", "VERSION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_languages-languages"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

