/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.sync.languages.thrift;

import ch.epfl.scala.bsp4j.BuildTarget;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.info.BspTargetInfo;
import org.jetbrains.bsp.bazel.server.dependencygraph.DependencyGraph;
import org.jetbrains.bsp.bazel.server.label.LabelKt;
import org.jetbrains.bsp.bazel.server.paths.BazelPathsResolver;
import org.jetbrains.bsp.bazel.server.sync.languages.LanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.SourceRootAndData;
import org.jetbrains.bsp.bazel.server.sync.languages.jvm.SourceRootGuesser;
import org.jetbrains.bsp.bazel.server.sync.languages.thrift.ThriftModule;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\t0\u000fj\b\u0012\u0004\u0012\u00020\t`\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/languages/thrift/ThriftLanguagePlugin;", "Lorg/jetbrains/bsp/bazel/server/sync/languages/LanguagePlugin;", "Lorg/jetbrains/bsp/bazel/server/sync/languages/thrift/ThriftModule;", "bazelPathsResolver", "Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;", "<init>", "(Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;)V", "dependencySources", "", "Ljava/net/URI;", "targetInfo", "Lorg/jetbrains/bsp/bazel/info/BspTargetInfo$TargetInfo;", "dependencyGraph", "Lorg/jetbrains/bsp/bazel/server/dependencygraph/DependencyGraph;", "sourcesFromJvmTargetInfo", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "isThriftLibrary", "", "target", "applyModuleData", "", "moduleData", "buildTarget", "Lch/epfl/scala/bsp4j/BuildTarget;", "calculateSourceRootAndAdditionalData", "Lorg/jetbrains/bsp/bazel/server/sync/languages/SourceRootAndData;", "source", "Ljava/nio/file/Path;", "Companion", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_languages-languages"})
@SourceDebugExtension(value={"SMAP\nThriftLanguagePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThriftLanguagePlugin.kt\norg/jetbrains/bsp/bazel/server/sync/languages/thrift/ThriftLanguagePlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n774#2:53\n865#2,2:54\n1368#2:56\n1454#2,5:57\n1557#2:62\n1628#2,3:63\n1368#2:66\n1454#2,5:67\n1557#2:72\n1628#2,3:73\n*S KotlinDebug\n*F\n+ 1 ThriftLanguagePlugin.kt\norg/jetbrains/bsp/bazel/server/sync/languages/thrift/ThriftLanguagePlugin\n*L\n19#1:53\n19#1:54,2\n20#1:56\n20#1:57,5\n21#1:62\n21#1:63,3\n34#1:66\n34#1:67,5\n35#1:72\n35#1:73,3\n*E\n"})
public final class ThriftLanguagePlugin
extends LanguagePlugin<ThriftModule> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BazelPathsResolver bazelPathsResolver;
    @NotNull
    private static final String THRIFT_LIBRARY_RULE_NAME = "thrift_library";

    public ThriftLanguagePlugin(@NotNull BazelPathsResolver bazelPathsResolver) {
        Intrinsics.checkNotNullParameter((Object)bazelPathsResolver, (String)"bazelPathsResolver");
        this.bazelPathsResolver = bazelPathsResolver;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<URI> dependencySources(@NotNull BspTargetInfo.TargetInfo targetInfo, @NotNull DependencyGraph dependencyGraph2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        BspTargetInfo.TargetInfo p0;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
        Intrinsics.checkNotNullParameter((Object)dependencyGraph2, (String)"dependencyGraph");
        Iterable iterable = dependencyGraph2.transitiveDependenciesWithoutRootTargets(LabelKt.label(targetInfo));
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            p0 = (BspTargetInfo.TargetInfo)element$iv$iv;
            boolean bl = false;
            if (!this.isThriftLibrary(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            p0 = (BspTargetInfo.TargetInfo)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = p0.getSourcesList();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        BazelPathsResolver bazelPathsResolver = this.bazelPathsResolver;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p02;
            BspTargetInfo.FileLocation bl = (BspTargetInfo.FileLocation)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(bazelPathsResolver.resolveUri((BspTargetInfo.FileLocation)p02));
        }
        HashSet transitiveSourceDeps = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv2));
        HashSet<URI> directSourceDeps = this.sourcesFromJvmTargetInfo(targetInfo);
        return SetsKt.plus((Set)transitiveSourceDeps, (Iterable)directSourceDeps);
    }

    /*
     * WARNING - void declaration
     */
    private final HashSet<URI> sourcesFromJvmTargetInfo(BspTargetInfo.TargetInfo targetInfo) {
        HashSet hashSet;
        if (targetInfo.hasJvmTargetInfo()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$flatMapTo$iv$iv;
            List<BspTargetInfo.JvmOutputs> list = targetInfo.getJvmTargetInfo().getJarsList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getJarsList(...)");
            Iterable $this$flatMap$iv = list;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                BspTargetInfo.JvmOutputs it = (BspTargetInfo.JvmOutputs)element$iv$iv;
                boolean bl = false;
                List<BspTargetInfo.FileLocation> list2 = it.getSourceJarsList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getSourceJarsList(...)");
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            BazelPathsResolver bazelPathsResolver = this.bazelPathsResolver;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                BspTargetInfo.FileLocation bl = (BspTargetInfo.FileLocation)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(bazelPathsResolver.resolveUri((BspTargetInfo.FileLocation)p0));
            }
            hashSet = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv2));
        } else {
            hashSet = new HashSet();
        }
        return hashSet;
    }

    private final boolean isThriftLibrary(BspTargetInfo.TargetInfo target) {
        return Intrinsics.areEqual((Object)target.getKind(), (Object)THRIFT_LIBRARY_RULE_NAME);
    }

    @Override
    protected void applyModuleData(@NotNull ThriftModule moduleData, @NotNull BuildTarget buildTarget) {
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        Intrinsics.checkNotNullParameter((Object)buildTarget, (String)"buildTarget");
    }

    @Override
    @NotNull
    public SourceRootAndData calculateSourceRootAndAdditionalData(@NotNull Path source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new SourceRootAndData(SourceRootGuesser.INSTANCE.getSourcesRoot(source), null, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/languages/thrift/ThriftLanguagePlugin$Companion;", "", "<init>", "()V", "THRIFT_LIBRARY_RULE_NAME", "", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_languages-languages"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

