/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.sync.sharding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.bazelrunner.BazelRunner;
import org.jetbrains.bsp.bazel.bazelrunner.utils.BazelInfo;
import org.jetbrains.bsp.bazel.commons.BazelStatus;
import org.jetbrains.bsp.bazel.logger.BspClientLogger;
import org.jetbrains.bsp.bazel.server.model.FirstPhaseProject;
import org.jetbrains.bsp.bazel.server.paths.BazelPathsResolver;
import org.jetbrains.bsp.bazel.server.sync.sharding.LexicographicTargetBatcher;
import org.jetbrains.bsp.bazel.server.sync.sharding.ShardedTargetList;
import org.jetbrains.bsp.bazel.server.sync.sharding.WildcardTargetExpander;
import org.jetbrains.bsp.bazel.server.sync.sharding.WildcardTargetExpanderKt;
import org.jetbrains.bsp.bazel.workspacecontext.ShardingApproach;
import org.jetbrains.bsp.bazel.workspacecontext.TargetsSpec;
import org.jetbrains.bsp.bazel.workspacecontext.WorkspaceContext;
import org.jetbrains.bsp.protocol.FeatureFlags;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JP\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\\\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010#\u001a\u00020$2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010%\u001a\u00020\u001bH\u0002J(\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0 2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010%\u001a\u00020\u001b\u00a8\u0006("}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/sharding/BazelBuildTargetSharder;", "", "<init>", "()V", "expandAndShardTargets", "Lorg/jetbrains/bsp/bazel/server/sync/sharding/BazelBuildTargetSharder$ShardedTargetsResult;", "pathResolver", "Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;", "bazelInfo", "Lorg/jetbrains/bsp/bazel/bazelrunner/utils/BazelInfo;", "featureFlags", "Lorg/jetbrains/bsp/protocol/FeatureFlags;", "targets", "Lorg/jetbrains/bsp/bazel/workspacecontext/TargetsSpec;", "context", "Lorg/jetbrains/bsp/bazel/workspacecontext/WorkspaceContext;", "bazelRunner", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelRunner;", "cancelChecker", "Lorg/eclipse/lsp4j/jsonrpc/CancelChecker;", "bspClientLogger", "Lorg/jetbrains/bsp/bazel/logger/BspClientLogger;", "firstPhaseProject", "Lorg/jetbrains/bsp/bazel/server/model/FirstPhaseProject;", "getShardingApproach", "Lorg/jetbrains/bsp/bazel/workspacecontext/ShardingApproach;", "getTargetShardSize", "", "expandWildcardTargets", "Lorg/jetbrains/bsp/bazel/server/sync/sharding/WildcardTargetExpander$ExpandedTargetsResult;", "pathsResolver", "includes", "", "Lorg/jetbrains/bazel/label/Label;", "excludes", "shardTargetsToBatches", "Lorg/jetbrains/bsp/bazel/server/sync/sharding/ShardedTargetList;", "shardSize", "shardTargetsRetainingOrdering", "ShardedTargetsResult", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_sharding-sharding"})
@SourceDebugExtension(value={"SMAP\nBazelBuildTargetSharder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazelBuildTargetSharder.kt\norg/jetbrains/bsp/bazel/server/sync/sharding/BazelBuildTargetSharder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n774#2:193\n865#2,2:194\n774#2:196\n865#2,2:197\n*S KotlinDebug\n*F\n+ 1 BazelBuildTargetSharder.kt\norg/jetbrains/bsp/bazel/server/sync/sharding/BazelBuildTargetSharder\n*L\n129#1:193\n129#1:194,2\n165#1:196\n165#1:197,2\n*E\n"})
public final class BazelBuildTargetSharder {
    @NotNull
    public static final BazelBuildTargetSharder INSTANCE = new BazelBuildTargetSharder();

    private BazelBuildTargetSharder() {
    }

    @NotNull
    public final ShardedTargetsResult expandAndShardTargets(@NotNull BazelPathsResolver pathResolver, @NotNull BazelInfo bazelInfo, @NotNull FeatureFlags featureFlags, @NotNull TargetsSpec targets2, @NotNull WorkspaceContext context, @NotNull BazelRunner bazelRunner, @NotNull CancelChecker cancelChecker, @NotNull BspClientLogger bspClientLogger, @Nullable FirstPhaseProject firstPhaseProject) {
        Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
        Intrinsics.checkNotNullParameter((Object)bazelInfo, (String)"bazelInfo");
        Intrinsics.checkNotNullParameter((Object)featureFlags, (String)"featureFlags");
        Intrinsics.checkNotNullParameter((Object)targets2, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bazelRunner, (String)"bazelRunner");
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)bspClientLogger, (String)"bspClientLogger");
        if (firstPhaseProject != null) {
            return new ShardedTargetsResult(this.shardTargetsToBatches(CollectionsKt.toList((Iterable)firstPhaseProject.getModules().keySet()), CollectionsKt.emptyList(), this.getTargetShardSize(context)), BazelStatus.SUCCESS);
        }
        List<Label> includes = targets2.getValues();
        List<Label> excludes = targets2.getExcludedValues();
        ShardingApproach shardingApproach = this.getShardingApproach(context);
        return switch (WhenMappings.$EnumSwitchMapping$0[shardingApproach.ordinal()]) {
            case 1 -> new ShardedTargetsResult(this.shardTargetsToBatches(includes, excludes, this.getTargetShardSize(context)), BazelStatus.SUCCESS);
            case 2 -> {
                WildcardTargetExpander.ExpandedTargetsResult singleTargets = WildcardTargetExpander.INSTANCE.queryIndividualTargets(includes, excludes, bazelRunner, cancelChecker, context);
                yield new ShardedTargetsResult(this.shardTargetsToBatches(singleTargets.getSingleTargets(), CollectionsKt.emptyList(), this.getTargetShardSize(context)), singleTargets.getBuildResult());
            }
            case 3 -> {
                WildcardTargetExpander.ExpandedTargetsResult expandedTargets = this.expandWildcardTargets(pathResolver, bazelInfo, featureFlags, includes, excludes, bazelRunner, cancelChecker, bspClientLogger, context);
                if (expandedTargets.getBuildResult() == BazelStatus.FATAL_ERROR) {
                    yield new ShardedTargetsResult(new ShardedTargetList(CollectionsKt.emptyList(), null, 2, null), expandedTargets.getBuildResult());
                }
                yield new ShardedTargetsResult(this.shardTargetsToBatches(expandedTargets.getSingleTargets(), CollectionsKt.emptyList(), this.getTargetShardSize(context)), expandedTargets.getBuildResult());
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final ShardingApproach getShardingApproach(WorkspaceContext context) {
        ShardingApproach shardingApproach = context.getShardingApproachSpec().getValue();
        if (shardingApproach == null) {
            shardingApproach = ShardingApproach.QUERY_AND_SHARD;
        }
        return shardingApproach;
    }

    private final int getTargetShardSize(WorkspaceContext context) {
        int n = context.getTargetShardSize().getValue();
        int n2 = 10000;
        return Math.min(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private final WildcardTargetExpander.ExpandedTargetsResult expandWildcardTargets(BazelPathsResolver pathsResolver, BazelInfo bazelInfo, FeatureFlags featureFlags, List<? extends Label> includes, List<? extends Label> excludes, BazelRunner bazelRunner, CancelChecker cancelChecker, BspClientLogger bspClientLogger, WorkspaceContext context) {
        void $this$filterTo$iv$iv;
        Object element$iv$iv;
        Iterator<? extends Label> $this$filterTo$iv$iv2;
        Iterable $this$filter$iv = includes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            Label it = (Label)element$iv$iv;
            boolean bl = false;
            if (!it.isWildcard()) continue;
            collection.add(element$iv$iv);
        }
        List wildcardIncludes = (List)collection;
        if (wildcardIncludes.isEmpty()) {
            return new WildcardTargetExpander.ExpandedTargetsResult(includes, BazelStatus.SUCCESS);
        }
        Map<Label, List<Label>> expandedTargets = WildcardTargetExpander.INSTANCE.expandToNonRecursiveWildcardTargets(pathsResolver, bazelInfo, featureFlags, wildcardIncludes);
        ArrayList<Label> fullList = new ArrayList<Label>();
        for (Label label : includes) {
            List<Label> expanded = expandedTargets.get(label);
            boolean bl = expanded == null ? fullList.add(label) : fullList.addAll((Collection)expanded);
        }
        WildcardTargetExpander.ExpandedTargetsResult result2 = WildcardTargetExpanderKt.orEmpty(WildcardTargetExpander.INSTANCE.expandToSingleTargets((List<? extends Label>)fullList, excludes, bazelRunner, cancelChecker, bspClientLogger, context));
        Iterable $this$filter$iv2 = includes;
        boolean $i$f$filter2 = false;
        element$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
            Label it = (Label)element$iv$iv2;
            boolean bl = false;
            if (!(!it.isWildcard())) continue;
            destination$iv$iv2.add(element$iv$iv2);
        }
        List list = (List)destination$iv$iv2;
        return WildcardTargetExpander.ExpandedTargetsResult.Companion.merge(result2, new WildcardTargetExpander.ExpandedTargetsResult(list, result2.getBuildResult()));
    }

    private final ShardedTargetList shardTargetsToBatches(List<? extends Label> targets2, List<? extends Label> excludes, int shardSize) {
        return new LexicographicTargetBatcher().getShardedTargetList(CollectionsKt.toSet((Iterable)targets2), CollectionsKt.toSet((Iterable)excludes), shardSize);
    }

    @NotNull
    public final List<List<Label>> shardTargetsRetainingOrdering(@NotNull List<? extends Label> targets2, int shardSize) {
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        return CollectionsKt.chunked((Iterable)targets2, (int)shardSize);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/sharding/BazelBuildTargetSharder$ShardedTargetsResult;", "", "targets", "Lorg/jetbrains/bsp/bazel/server/sync/sharding/ShardedTargetList;", "buildResult", "Lorg/jetbrains/bsp/bazel/commons/BazelStatus;", "<init>", "(Lorg/jetbrains/bsp/bazel/server/sync/sharding/ShardedTargetList;Lorg/jetbrains/bsp/bazel/commons/BazelStatus;)V", "getTargets", "()Lorg/jetbrains/bsp/bazel/server/sync/sharding/ShardedTargetList;", "getBuildResult", "()Lorg/jetbrains/bsp/bazel/commons/BazelStatus;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_sharding-sharding"})
    public static final class ShardedTargetsResult {
        @NotNull
        private final ShardedTargetList targets;
        @NotNull
        private final BazelStatus buildResult;

        public ShardedTargetsResult(@NotNull ShardedTargetList targets2, @NotNull BazelStatus buildResult) {
            Intrinsics.checkNotNullParameter((Object)targets2, (String)"targets");
            Intrinsics.checkNotNullParameter((Object)((Object)buildResult), (String)"buildResult");
            this.targets = targets2;
            this.buildResult = buildResult;
        }

        @NotNull
        public final ShardedTargetList getTargets() {
            return this.targets;
        }

        @NotNull
        public final BazelStatus getBuildResult() {
            return this.buildResult;
        }

        @NotNull
        public final ShardedTargetList component1() {
            return this.targets;
        }

        @NotNull
        public final BazelStatus component2() {
            return this.buildResult;
        }

        @NotNull
        public final ShardedTargetsResult copy(@NotNull ShardedTargetList targets2, @NotNull BazelStatus buildResult) {
            Intrinsics.checkNotNullParameter((Object)targets2, (String)"targets");
            Intrinsics.checkNotNullParameter((Object)((Object)buildResult), (String)"buildResult");
            return new ShardedTargetsResult(targets2, buildResult);
        }

        public static /* synthetic */ ShardedTargetsResult copy$default(ShardedTargetsResult shardedTargetsResult, ShardedTargetList shardedTargetList, BazelStatus bazelStatus, int n, Object object) {
            if ((n & 1) != 0) {
                shardedTargetList = shardedTargetsResult.targets;
            }
            if ((n & 2) != 0) {
                bazelStatus = shardedTargetsResult.buildResult;
            }
            return shardedTargetsResult.copy(shardedTargetList, bazelStatus);
        }

        @NotNull
        public String toString() {
            return "ShardedTargetsResult(targets=" + this.targets + ", buildResult=" + this.buildResult + ")";
        }

        public int hashCode() {
            int result2 = this.targets.hashCode();
            result2 = result2 * 31 + this.buildResult.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ShardedTargetsResult)) {
                return false;
            }
            ShardedTargetsResult shardedTargetsResult = (ShardedTargetsResult)other;
            if (!Intrinsics.areEqual((Object)this.targets, (Object)shardedTargetsResult.targets)) {
                return false;
            }
            return this.buildResult == shardedTargetsResult.buildResult;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShardingApproach.values().length];
            try {
                nArray[ShardingApproach.SHARD_ONLY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShardingApproach.QUERY_AND_SHARD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShardingApproach.EXPAND_AND_SHARD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

