/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.sync.sharding;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bazel.commons.symlinks.BazelSymlinksCalculator;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.bazelrunner.utils.BazelInfo;
import org.jetbrains.bsp.bazel.server.paths.BazelPathsResolver;
import org.jetbrains.bsp.bazel.server.sync.sharding.PackageLister;
import org.jetbrains.bsp.protocol.FeatureFlags;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007JK\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0082\u0010J \u0010\u0016\u001a\u00020\u0017*\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007J\n\u0010\u0018\u001a\u00020\u0017*\u00020\u0012\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/sharding/PackageLister;", "", "<init>", "()V", "expandPackageTargets", "", "Lorg/jetbrains/bazel/label/Label;", "", "pathResolver", "Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;", "bazelInfo", "Lorg/jetbrains/bsp/bazel/bazelrunner/utils/BazelInfo;", "featureFlags", "Lorg/jetbrains/bsp/protocol/FeatureFlags;", "wildcardPatterns", "traversePackageRecursively", "", "calculatedBazelSymlinks", "Ljava/nio/file/Path;", "dirs", "", "output", "isEligibleForTraversal", "", "containsBuildFile", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_sharding-sharding"})
@SourceDebugExtension(value={"SMAP\nPackageLister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageLister.kt\norg/jetbrains/bsp/bazel/server/sync/sharding/PackageLister\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n774#2:96\n865#2,2:97\n1611#2,9:99\n1863#2:108\n1864#2:110\n1620#2:111\n1755#2,3:112\n1755#2,3:115\n1#3:109\n*S KotlinDebug\n*F\n+ 1 PackageLister.kt\norg/jetbrains/bsp/bazel/server/sync/sharding/PackageLister\n*L\n49#1:96\n49#1:97,2\n50#1:99,9\n50#1:108\n50#1:110\n50#1:111\n88#1:112,3\n92#1:115,3\n50#1:109\n*E\n"})
public final class PackageLister {
    @NotNull
    public static final PackageLister INSTANCE = new PackageLister();

    private PackageLister() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Label, List<Label>> expandPackageTargets(@NotNull BazelPathsResolver pathResolver, @NotNull BazelInfo bazelInfo, @NotNull FeatureFlags featureFlags, @NotNull List<? extends Label> wildcardPatterns) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
        Intrinsics.checkNotNullParameter((Object)bazelInfo, (String)"bazelInfo");
        Intrinsics.checkNotNullParameter((Object)featureFlags, (String)"featureFlags");
        Intrinsics.checkNotNullParameter(wildcardPatterns, (String)"wildcardPatterns");
        List<Path> calculatedBazelSymlinks = BazelSymlinksCalculator.INSTANCE.calculateBazelSymlinksToExclude(bazelInfo.getWorkspaceRoot(), featureFlags.getBazelSymlinksScanMaxDepth());
        Iterable iterable = wildcardPatterns;
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Label it = (Label)element$iv$iv;
            boolean bl = false;
            if (!it.isRecursive()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Label pattern = (Label)element$iv$iv;
            boolean bl2 = false;
            Iterable iterable2 = pattern.getPackagePath().getPathSegments();
            String string = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
            Path dir = pathResolver.relativePathToWorkspaceAbsolute(CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string, null, null, (int)0, null, null, (int)62, null));
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(dir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                pair = null;
            } else {
                List expandedTargets = new ArrayList();
                Object[] objectArray = new Path[]{dir};
                INSTANCE.traversePackageRecursively(pathResolver, bazelInfo, featureFlags, calculatedBazelSymlinks, CollectionsKt.mutableListOf((Object[])objectArray), expandedTargets);
                pair = TuplesKt.to((Object)pattern, (Object)expandedTargets);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final void traversePackageRecursively(BazelPathsResolver pathResolver, BazelInfo bazelInfo, FeatureFlags featureFlags, List<? extends Path> calculatedBazelSymlinks, List<Path> dirs, List<Label> output) {
        PackageLister packageLister = this;
        while ((Path)CollectionsKt.removeFirstOrNull(dirs) != null) {
            Path dir;
            if (packageLister.isEligibleForTraversal(dir, bazelInfo, calculatedBazelSymlinks)) {
                Object[] objectArray;
                String path2 = pathResolver.getWorkspaceRelativePath(dir);
                if (packageLister.containsBuildFile(dir)) {
                    output.add(Label.Companion.parse("//" + path2 + ":all"));
                }
                if ((objectArray = dir.toFile().listFiles()) == null) {
                    objectArray = new File[]{};
                }
                Object[] children = objectArray;
                CollectionsKt.addAll((Collection)dirs, (Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])children), (Function1)traversePackageRecursively.1.INSTANCE), (Function1)traversePackageRecursively.2.INSTANCE));
            }
            PackageLister packageLister2 = packageLister;
            BazelPathsResolver bazelPathsResolver = pathResolver;
            BazelInfo bazelInfo2 = bazelInfo;
            FeatureFlags featureFlags2 = featureFlags;
            List<? extends Path> list = calculatedBazelSymlinks;
            List<Path> list2 = dirs;
            List<Label> list3 = output;
            packageLister = packageLister2;
            pathResolver = bazelPathsResolver;
            bazelInfo = bazelInfo2;
            featureFlags = featureFlags2;
            calculatedBazelSymlinks = list;
            dirs = list2;
            output = list3;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEligibleForTraversal(@NotNull Path $this$isEligibleForTraversal, @NotNull BazelInfo bazelInfo, @NotNull List<? extends Path> calculatedBazelSymlinks) {
        Path it;
        Intrinsics.checkNotNullParameter((Object)$this$isEligibleForTraversal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bazelInfo, (String)"bazelInfo");
        Intrinsics.checkNotNullParameter(calculatedBazelSymlinks, (String)"calculatedBazelSymlinks");
        if (Intrinsics.areEqual((Object)$this$isEligibleForTraversal, (Object)bazelInfo.dotBazelBsp())) return false;
        Iterable $this$any$iv = calculatedBazelSymlinks;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (Path)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)it, (Object)$this$isEligibleForTraversal));
        return false;
    }

    public final boolean containsBuildFile(@NotNull Path $this$containsBuildFile) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$containsBuildFile, (String)"<this>");
            Object[] objectArray = new String[]{"BUILD", "BUILD.bazel"};
            List possibleBuildFileNames = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$any$iv = possibleBuildFileNames;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Path path2;
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$containsBuildFile.resolve(it), (String)"resolve(...)");
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.isRegularFile(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

