/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.sync.sharding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.bazelrunner.BazelCommand;
import org.jetbrains.bsp.bazel.bazelrunner.BazelProcessResult;
import org.jetbrains.bsp.bazel.bazelrunner.BazelRunner;
import org.jetbrains.bsp.bazel.bazelrunner.utils.BazelInfo;
import org.jetbrains.bsp.bazel.commons.BazelStatus;
import org.jetbrains.bsp.bazel.logger.BspClientLogger;
import org.jetbrains.bsp.bazel.server.paths.BazelPathsResolver;
import org.jetbrains.bsp.bazel.server.sync.sharding.BazelBuildTargetSharder;
import org.jetbrains.bsp.bazel.server.sync.sharding.PackageLister;
import org.jetbrains.bsp.bazel.workspacecontext.TargetsSpec;
import org.jetbrains.bsp.bazel.workspacecontext.WorkspaceContext;
import org.jetbrains.bsp.protocol.FeatureFlags;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007JD\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ:\u0010\u001b\u001a\u00020\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u00072\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/sharding/WildcardTargetExpander;", "", "<init>", "()V", "expandToNonRecursiveWildcardTargets", "", "Lorg/jetbrains/bazel/label/Label;", "", "pathResolver", "Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;", "bazelInfo", "Lorg/jetbrains/bsp/bazel/bazelrunner/utils/BazelInfo;", "featureFlags", "Lorg/jetbrains/bsp/protocol/FeatureFlags;", "wildcardIncludes", "expandToSingleTargets", "Lorg/jetbrains/bsp/bazel/server/sync/sharding/WildcardTargetExpander$ExpandedTargetsResult;", "packageTargets", "excludes", "bazelRunner", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelRunner;", "cancelChecker", "Lorg/eclipse/lsp4j/jsonrpc/CancelChecker;", "bspClientLogger", "Lorg/jetbrains/bsp/bazel/logger/BspClientLogger;", "context", "Lorg/jetbrains/bsp/bazel/workspacecontext/WorkspaceContext;", "queryIndividualTargets", "includedPatterns", "excludedTargets", "ExpandedTargetsResult", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_sharding-sharding"})
@SourceDebugExtension(value={"SMAP\nWildcardTargetExpander.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WildcardTargetExpander.kt\norg/jetbrains/bsp/bazel/server/sync/sharding/WildcardTargetExpander\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1557#2:138\n1628#2,3:139\n*S KotlinDebug\n*F\n+ 1 WildcardTargetExpander.kt\norg/jetbrains/bsp/bazel/server/sync/sharding/WildcardTargetExpander\n*L\n117#1:138\n117#1:139,3\n*E\n"})
public final class WildcardTargetExpander {
    @NotNull
    public static final WildcardTargetExpander INSTANCE = new WildcardTargetExpander();

    private WildcardTargetExpander() {
    }

    @NotNull
    public final Map<Label, List<Label>> expandToNonRecursiveWildcardTargets(@NotNull BazelPathsResolver pathResolver, @NotNull BazelInfo bazelInfo, @NotNull FeatureFlags featureFlags, @NotNull List<? extends Label> wildcardIncludes) {
        Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
        Intrinsics.checkNotNullParameter((Object)bazelInfo, (String)"bazelInfo");
        Intrinsics.checkNotNullParameter((Object)featureFlags, (String)"featureFlags");
        Intrinsics.checkNotNullParameter(wildcardIncludes, (String)"wildcardIncludes");
        return PackageLister.INSTANCE.expandPackageTargets(pathResolver, bazelInfo, featureFlags, wildcardIncludes);
    }

    @Nullable
    public final ExpandedTargetsResult expandToSingleTargets(@NotNull List<? extends Label> packageTargets, @NotNull List<? extends Label> excludes, @NotNull BazelRunner bazelRunner, @NotNull CancelChecker cancelChecker, @NotNull BspClientLogger bspClientLogger, @NotNull WorkspaceContext context) {
        Intrinsics.checkNotNullParameter(packageTargets, (String)"packageTargets");
        Intrinsics.checkNotNullParameter(excludes, (String)"excludes");
        Intrinsics.checkNotNullParameter((Object)bazelRunner, (String)"bazelRunner");
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)bspClientLogger, (String)"bspClientLogger");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<List<Label>> shards = BazelBuildTargetSharder.INSTANCE.shardTargetsRetainingOrdering(packageTargets, 500);
        ExpandedTargetsResult output = null;
        for (List<Label> shard : shards) {
            ExpandedTargetsResult result2 = this.queryIndividualTargets(shard, excludes, bazelRunner, cancelChecker, context);
            if ((output = output == null ? result2 : ExpandedTargetsResult.Companion.merge(output, result2)).getBuildResult() != BazelStatus.FATAL_ERROR) continue;
            bspClientLogger.warn("Bazel query for expanding package targets failed with fatal error. Skipping further expanding queries.");
            return output;
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExpandedTargetsResult queryIndividualTargets(@NotNull List<? extends Label> includedPatterns, @NotNull List<? extends Label> excludedTargets2, @NotNull BazelRunner bazelRunner, @NotNull CancelChecker cancelChecker, @NotNull WorkspaceContext context) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(includedPatterns, (String)"includedPatterns");
        Intrinsics.checkNotNullParameter(excludedTargets2, (String)"excludedTargets");
        Intrinsics.checkNotNullParameter((Object)bazelRunner, (String)"bazelRunner");
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TargetsSpec targetsSpec = new TargetsSpec(includedPatterns, excludedTargets2);
        BazelCommand command2 = BazelRunner.buildBazelCommand$default(bazelRunner, null, (Function1)new Function1<BazelRunner.CommandBuilder, BazelCommand>(context, targetsSpec){
            final /* synthetic */ WorkspaceContext $context;
            final /* synthetic */ TargetsSpec $targetsSpec;
            {
                this.$context = $context;
                this.$targetsSpec = $targetsSpec;
                super(1);
            }

            public final BazelCommand invoke(BazelRunner.CommandBuilder $this$buildBazelCommand) {
                Intrinsics.checkNotNullParameter((Object)$this$buildBazelCommand, (String)"$this$buildBazelCommand");
                return $this$buildBazelCommand.query(this.$context.getAllowManualTargetsSync().getValue(), (Function1<? super BazelCommand.Query, Unit>)((Function1)new Function1<BazelCommand.Query, Unit>(this.$targetsSpec){
                    final /* synthetic */ TargetsSpec $targetsSpec;
                    {
                        this.$targetsSpec = $targetsSpec;
                        super(1);
                    }

                    public final void invoke(BazelCommand.Query $this$query) {
                        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
                        $this$query.addTargetsFromSpec(this.$targetsSpec);
                        Object[] objectArray = new String[]{"--output=label", "--keep_going"};
                        $this$query.getOptions().addAll(CollectionsKt.listOf((Object[])objectArray));
                    }
                }));
            }
        }, 1, null);
        BazelProcessResult queryResult = BazelRunner.runBazelCommand$default(bazelRunner, command2, null, false, null, false, 2, null).waitAndGetResult(cancelChecker, true);
        Iterable $this$map$iv = queryResult.getStdoutLines();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Label.Companion.parse((String)it));
        }
        BazelStatus bazelStatus = queryResult.getBazelStatus();
        List list = (List)destination$iv$iv;
        return new ExpandedTargetsResult(list, bazelStatus);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/sharding/WildcardTargetExpander$ExpandedTargetsResult;", "", "singleTargets", "", "Lorg/jetbrains/bazel/label/Label;", "buildResult", "Lorg/jetbrains/bsp/bazel/commons/BazelStatus;", "<init>", "(Ljava/util/List;Lorg/jetbrains/bsp/bazel/commons/BazelStatus;)V", "getSingleTargets", "()Ljava/util/List;", "getBuildResult", "()Lorg/jetbrains/bsp/bazel/commons/BazelStatus;", "Companion", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_sharding-sharding"})
    public static final class ExpandedTargetsResult {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<Label> singleTargets;
        @NotNull
        private final BazelStatus buildResult;

        public ExpandedTargetsResult(@NotNull List<? extends Label> singleTargets, @NotNull BazelStatus buildResult) {
            Intrinsics.checkNotNullParameter(singleTargets, (String)"singleTargets");
            Intrinsics.checkNotNullParameter((Object)((Object)buildResult), (String)"buildResult");
            this.singleTargets = singleTargets;
            this.buildResult = buildResult;
        }

        @NotNull
        public final List<Label> getSingleTargets() {
            return this.singleTargets;
        }

        @NotNull
        public final BazelStatus getBuildResult() {
            return this.buildResult;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005\u00a8\u0006\b"}, d2={"Lorg/jetbrains/bsp/bazel/server/sync/sharding/WildcardTargetExpander$ExpandedTargetsResult$Companion;", "", "<init>", "()V", "merge", "Lorg/jetbrains/bsp/bazel/server/sync/sharding/WildcardTargetExpander$ExpandedTargetsResult;", "first", "second", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_sync_sharding-sharding"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ExpandedTargetsResult merge(@NotNull ExpandedTargetsResult first, @NotNull ExpandedTargetsResult second) {
                Intrinsics.checkNotNullParameter((Object)first, (String)"first");
                Intrinsics.checkNotNullParameter((Object)second, (String)"second");
                BazelStatus buildResult = first.getBuildResult().merge(second.getBuildResult());
                List targets2 = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)first.getSingleTargets(), (Iterable)second.getSingleTargets()));
                return new ExpandedTargetsResult(targets2, buildResult);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

