/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.workspacecontext;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bazel.commons.utils.OsArch;
import org.jetbrains.bazel.commons.utils.OsFamily;
import org.jetbrains.bsp.bazel.executioncontext.api.ExecutionContextEntityExtractor;
import org.jetbrains.bsp.bazel.executioncontext.api.ExecutionContextEntityExtractorException;
import org.jetbrains.bsp.bazel.projectview.model.ProjectView;
import org.jetbrains.bsp.bazel.projectview.model.sections.ProjectViewBazelBinarySection;
import org.jetbrains.bsp.bazel.workspacecontext.BazelBinarySpec;
import org.jetbrains.bsp.bazel.workspacecontext.BazelBinarySpecKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\n\u0010\f\u001a\u0004\u0018\u00010\tH\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/bsp/bazel/workspacecontext/BazelBinarySpecExtractor;", "Lorg/jetbrains/bsp/bazel/executioncontext/api/ExecutionContextEntityExtractor;", "Lorg/jetbrains/bsp/bazel/workspacecontext/BazelBinarySpec;", "<init>", "()V", "fromProjectView", "projectView", "Lorg/jetbrains/bsp/bazel/projectview/model/ProjectView;", "downloadBazelisk", "Ljava/nio/file/Path;", "calculateBazeliskDownloadLink", "", "findBazelOnPathOrNull", "splitPath", "", "bazelFile", "path", "executable", "calculateExecutableName", "name", "server_executioncontext_workspacecontext_src_main_kotlin_org_jetbrains_bsp_bazel_workspacecontext-workspacecontext"})
@SourceDebugExtension(value={"SMAP\nBazelBinarySpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazelBinarySpec.kt\norg/jetbrains/bsp/bazel/workspacecontext/BazelBinarySpecExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1368#2:122\n1454#2,5:123\n*S KotlinDebug\n*F\n+ 1 BazelBinarySpec.kt\norg/jetbrains/bsp/bazel/workspacecontext/BazelBinarySpecExtractor\n*L\n101#1:122\n101#1:123,5\n*E\n"})
public final class BazelBinarySpecExtractor
implements ExecutionContextEntityExtractor<BazelBinarySpec> {
    @NotNull
    public static final BazelBinarySpecExtractor INSTANCE = new BazelBinarySpecExtractor();

    private BazelBinarySpecExtractor() {
    }

    @Override
    @NotNull
    public BazelBinarySpec fromProjectView(@NotNull ProjectView projectView) {
        BazelBinarySpec bazelBinarySpec;
        Path extracted;
        Intrinsics.checkNotNullParameter((Object)projectView, (String)"projectView");
        ProjectViewBazelBinarySection projectViewBazelBinarySection = projectView.getBazelBinary();
        Path path2 = extracted = projectViewBazelBinarySection != null ? projectViewBazelBinarySection.getValue() : null;
        if (extracted != null) {
            bazelBinarySpec = new BazelBinarySpec(extracted);
        } else {
            Path path3 = this.findBazelOnPathOrNull();
            if (path3 == null && (path3 = this.downloadBazelisk()) == null) {
                throw new ExecutionContextEntityExtractorException("bazel path", "Could not find bazel on your PATH nor download bazelisk");
            }
            Path path4 = path3;
            bazelBinarySpec = new BazelBinarySpec(path4);
        }
        return bazelBinarySpec;
    }

    private final Path downloadBazelisk() {
        URL downloadLink;
        BazelBinarySpecKt.access$getLog$p().info("Downloading bazelisk");
        String string = this.calculateBazeliskDownloadLink();
        if (string != null) {
            URL uRL;
            String it = string;
            boolean bl = false;
            try {
                uRL = new URI(it).toURL();
            }
            catch (Exception e) {
                BazelBinarySpecKt.access$getLog$p().error("Could not parse bazelisk download link: " + it);
                return null;
            }
            v1 = uRL;
        } else {
            v1 = downloadLink = null;
        }
        if (downloadLink == null) {
            BazelBinarySpecKt.access$getLog$p().error("Could not calculate bazelisk download link (your OS should be one of: windows-amd64, linux-amd64, linux-arm64, darwin)");
            return null;
        }
        File cache = org.jetbrains.bsp.bazel.commons.FileUtils.INSTANCE.getCacheDirectory("bazelbsp");
        if (cache == null) {
            BazelBinarySpecKt.access$getLog$p().error("Could not find cache directory");
            return null;
        }
        File bazeliskFile = new File(cache, "bazelisk");
        if (bazeliskFile.exists()) {
            BazelBinarySpecKt.access$getLog$p().info("Bazelisk already exists in the cache folder: " + bazeliskFile.getPath());
        } else {
            BazelBinarySpecKt.access$getLog$p().info("Downloading bazelisk to the cache folder: " + bazeliskFile.getPath());
            FileUtils.copyURLToFile((URL)downloadLink, (File)bazeliskFile, (int)60000, (int)60000);
            BazelBinarySpecKt.access$getLog$p().info("Downloaded bazelisk");
            bazeliskFile.setExecutable(true);
            BazelBinarySpecKt.access$getLog$p().info("Set bazelisk binary to be executable");
        }
        return bazeliskFile.toPath();
    }

    private final String calculateBazeliskDownloadLink() {
        String suffix;
        OsArch arch;
        String base = "https://github.com/bazelbuild/bazelisk/releases/latest/download/bazelisk-";
        OsFamily os = OsFamily.Companion.inferFromSystem();
        Pair pair = new Pair((Object)os, (Object)(arch = OsArch.Companion.inferFromSystem()));
        String string = Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)OsFamily.WINDOWS, (Object)OsArch.X64)) ? "windows-amd64.exe" : (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)OsFamily.LINUX, (Object)OsArch.X64)) ? "linux-amd64" : (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)OsFamily.LINUX, (Object)OsArch.ARM64)) ? "linux-arm64" : (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)OsFamily.MACOS, (Object)OsArch.X64)) ? "darwin" : (suffix = Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)OsFamily.MACOS, (Object)OsArch.ARM64)) ? "darwin" : null))));
        if (suffix == null) {
            BazelBinarySpecKt.access$getLog$p().error("Could not calculate bazelisk download link (your OS should be one of: windows-amd64, linux-amd64, linux-arm64, linux-aarch64, darwin)");
            return null;
        }
        return base + suffix;
    }

    /*
     * WARNING - void declaration
     */
    private final Path findBazelOnPathOrNull() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.splitPath();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new Path[]{INSTANCE.bazelFile(it, "bazel"), INSTANCE.bazelFile(it, "bazelisk")};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (Path)CollectionsKt.firstOrNull((List)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
    }

    private final List<String> splitPath() {
        List list;
        List list2;
        String path2;
        String string = path2 = System.getenv("PATH");
        if (string != null) {
            String[] stringArray = new String[]{File.pathSeparator};
            list2 = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final Path bazelFile(String path2, String executable) {
        File file = new File(path2, this.calculateExecutableName(executable));
        return file.exists() && file.canExecute() ? file.toPath() : null;
    }

    private final String calculateExecutableName(String name) {
        return OsFamily.Companion.inferFromSystem() == OsFamily.WINDOWS ? name + ".exe" : name;
    }
}

