/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.workspacecontext;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.projectview.generator.DefaultProjectViewGenerator;
import org.jetbrains.bsp.bazel.projectview.model.ProjectView;
import org.jetbrains.bsp.bazel.projectview.parser.DefaultProjectViewParser;
import org.jetbrains.bsp.bazel.workspacecontext.WorkspaceContext;
import org.jetbrains.bsp.bazel.workspacecontext.WorkspaceContextConstructor;
import org.jetbrains.bsp.bazel.workspacecontext.WorkspaceContextProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/bsp/bazel/workspacecontext/DefaultWorkspaceContextProvider;", "Lorg/jetbrains/bsp/bazel/workspacecontext/WorkspaceContextProvider;", "workspaceRoot", "Ljava/nio/file/Path;", "projectViewPath", "dotBazelBspDirPath", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "workspaceContextConstructor", "Lorg/jetbrains/bsp/bazel/workspacecontext/WorkspaceContextConstructor;", "currentWorkspaceContext", "Lorg/jetbrains/bsp/bazel/workspacecontext/WorkspaceContext;", "ensureProjectViewExistsAndParse", "Lorg/jetbrains/bsp/bazel/projectview/model/ProjectView;", "generateEmptyProjectView", "", "server_executioncontext_workspacecontext_src_main_kotlin_org_jetbrains_bsp_bazel_workspacecontext-workspacecontext"})
public final class DefaultWorkspaceContextProvider
implements WorkspaceContextProvider {
    @NotNull
    private final Path workspaceRoot;
    @NotNull
    private final Path projectViewPath;
    @NotNull
    private final WorkspaceContextConstructor workspaceContextConstructor;

    public DefaultWorkspaceContextProvider(@NotNull Path workspaceRoot, @NotNull Path projectViewPath, @NotNull Path dotBazelBspDirPath) {
        Intrinsics.checkNotNullParameter((Object)workspaceRoot, (String)"workspaceRoot");
        Intrinsics.checkNotNullParameter((Object)projectViewPath, (String)"projectViewPath");
        Intrinsics.checkNotNullParameter((Object)dotBazelBspDirPath, (String)"dotBazelBspDirPath");
        this.workspaceRoot = workspaceRoot;
        this.projectViewPath = projectViewPath;
        this.workspaceContextConstructor = new WorkspaceContextConstructor(this.workspaceRoot, dotBazelBspDirPath);
    }

    @Override
    @NotNull
    public WorkspaceContext currentWorkspaceContext() {
        ProjectView projectView = this.ensureProjectViewExistsAndParse();
        return this.workspaceContextConstructor.construct(projectView);
    }

    private final ProjectView ensureProjectViewExistsAndParse() {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(this.projectViewPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            this.generateEmptyProjectView();
        }
        return new DefaultProjectViewParser(this.workspaceRoot).parse(this.projectViewPath);
    }

    private final void generateEmptyProjectView() {
        ProjectView emptyProjectView = new ProjectView.Builder(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 524287, null).build();
        DefaultProjectViewGenerator.INSTANCE.generatePrettyStringAndSaveInFile(emptyProjectView, this.projectViewPath);
    }
}

