/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.workspacecontext;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.executioncontext.api.ExecutionContextExcludableListEntity;
import org.jetbrains.bsp.bazel.workspacecontext.IllegalTargetsSizeException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/bsp/bazel/workspacecontext/TargetsSpec;", "Lorg/jetbrains/bsp/bazel/executioncontext/api/ExecutionContextExcludableListEntity;", "Lorg/jetbrains/bazel/label/Label;", "values", "", "excludedValues", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getValues", "()Ljava/util/List;", "getExcludedValues", "halve", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "server_executioncontext_workspacecontext_src_main_kotlin_org_jetbrains_bsp_bazel_workspacecontext-workspacecontext"})
public final class TargetsSpec
extends ExecutionContextExcludableListEntity<Label> {
    @NotNull
    private final List<Label> values;
    @NotNull
    private final List<Label> excludedValues;

    public TargetsSpec(@NotNull List<? extends Label> values, @NotNull List<? extends Label> excludedValues) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter(excludedValues, (String)"excludedValues");
        this.values = values;
        this.excludedValues = excludedValues;
    }

    @Override
    @NotNull
    public List<Label> getValues() {
        return this.values;
    }

    @Override
    @NotNull
    public List<Label> getExcludedValues() {
        return this.excludedValues;
    }

    @NotNull
    public final List<TargetsSpec> halve() {
        int valueSize = this.getValues().size();
        if (valueSize <= 1) {
            throw new IllegalTargetsSizeException("Cannot halve further, size is " + valueSize);
        }
        int firstHalfSize = valueSize / 2;
        TargetsSpec firstHalf = new TargetsSpec(this.getValues().subList(0, firstHalfSize), this.getExcludedValues());
        TargetsSpec secondHalf = new TargetsSpec(this.getValues().subList(firstHalfSize, valueSize), this.getExcludedValues());
        Object[] objectArray = new TargetsSpec[]{firstHalf, secondHalf};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<Label> component1() {
        return this.values;
    }

    @NotNull
    public final List<Label> component2() {
        return this.excludedValues;
    }

    @NotNull
    public final TargetsSpec copy(@NotNull List<? extends Label> values, @NotNull List<? extends Label> excludedValues) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter(excludedValues, (String)"excludedValues");
        return new TargetsSpec(values, excludedValues);
    }

    public static /* synthetic */ TargetsSpec copy$default(TargetsSpec targetsSpec, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list = targetsSpec.values;
        }
        if ((n & 2) != 0) {
            list2 = targetsSpec.excludedValues;
        }
        return targetsSpec.copy(list, list2);
    }

    @NotNull
    public String toString() {
        return "TargetsSpec(values=" + this.values + ", excludedValues=" + this.excludedValues + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.values).hashCode();
        result2 = result2 * 31 + ((Object)this.excludedValues).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TargetsSpec)) {
            return false;
        }
        TargetsSpec targetsSpec = (TargetsSpec)other;
        if (!Intrinsics.areEqual(this.values, targetsSpec.values)) {
            return false;
        }
        return Intrinsics.areEqual(this.excludedValues, targetsSpec.excludedValues);
    }
}

