/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.workspacecontext;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.executioncontext.api.ExecutionContextEntityExtractor;
import org.jetbrains.bsp.bazel.executioncontext.api.ExecutionContextEntityExtractorException;
import org.jetbrains.bsp.bazel.projectview.model.ProjectView;
import org.jetbrains.bsp.bazel.projectview.model.sections.ProjectViewDeriveTargetsFromDirectoriesSection;
import org.jetbrains.bsp.bazel.projectview.model.sections.ProjectViewDirectoriesSection;
import org.jetbrains.bsp.bazel.projectview.model.sections.ProjectViewTargetsSection;
import org.jetbrains.bsp.bazel.workspacecontext.TargetsSpec;
import org.jetbrains.bsp.bazel.workspacecontext.TargetsSpecKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0016\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/bsp/bazel/workspacecontext/TargetsSpecExtractor;", "Lorg/jetbrains/bsp/bazel/executioncontext/api/ExecutionContextEntityExtractor;", "Lorg/jetbrains/bsp/bazel/workspacecontext/TargetsSpec;", "<init>", "()V", "NAME", "", "fromProjectView", "projectView", "Lorg/jetbrains/bsp/bazel/projectview/model/ProjectView;", "deriveTargetsFromDirectoriesSectionTrue", "deriveTargetsFromDirectoriesSectionFalse", "hasEmptyIncludedValuesAndEmptyExcludedValues", "", "targetsSection", "Lorg/jetbrains/bsp/bazel/projectview/model/sections/ProjectViewTargetsSection;", "hasEmptyIncludedValuesAndNonEmptyExcludedValues", "hasEmptyIncludedValuesAndEmptyExcludedValuesDirectories", "directoriesSection", "Lorg/jetbrains/bsp/bazel/projectview/model/sections/ProjectViewDirectoriesSection;", "hasEmptyIncludedValuesAndNonEmptyExcludedValuesDirectories", "mapNotEmptyNotDerivedTargetsSection", "mapNotEmptyDerivedTargetSection", "mapDirectoryToTarget", "Lorg/jetbrains/bazel/label/Label;", "buildDirectoryIdentifier", "Ljava/nio/file/Path;", "server_executioncontext_workspacecontext_src_main_kotlin_org_jetbrains_bsp_bazel_workspacecontext-workspacecontext"})
@SourceDebugExtension(value={"SMAP\nTargetsSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetsSpec.kt\norg/jetbrains/bsp/bazel/workspacecontext/TargetsSpecExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1557#2:110\n1628#2,3:111\n1557#2:114\n1628#2,3:115\n*S KotlinDebug\n*F\n+ 1 TargetsSpec.kt\norg/jetbrains/bsp/bazel/workspacecontext/TargetsSpecExtractor\n*L\n93#1:110\n93#1:111,3\n94#1:114\n94#1:115,3\n*E\n"})
public final class TargetsSpecExtractor
implements ExecutionContextEntityExtractor<TargetsSpec> {
    @NotNull
    public static final TargetsSpecExtractor INSTANCE = new TargetsSpecExtractor();
    @NotNull
    private static final String NAME = "targets";

    private TargetsSpecExtractor() {
    }

    @Override
    @NotNull
    public TargetsSpec fromProjectView(@NotNull ProjectView projectView) {
        Intrinsics.checkNotNullParameter((Object)projectView, (String)"projectView");
        ProjectViewDeriveTargetsFromDirectoriesSection projectViewDeriveTargetsFromDirectoriesSection = projectView.getDeriveTargetsFromDirectories();
        return (projectViewDeriveTargetsFromDirectoriesSection != null ? projectViewDeriveTargetsFromDirectoriesSection.getValue().booleanValue() : false) ? this.deriveTargetsFromDirectoriesSectionTrue(projectView) : this.deriveTargetsFromDirectoriesSectionFalse(projectView);
    }

    private final TargetsSpec deriveTargetsFromDirectoriesSectionTrue(ProjectView projectView) {
        TargetsSpec targetsSpec;
        ProjectViewDirectoriesSection projectViewDirectoriesSection = projectView.getDirectories();
        if (projectViewDirectoriesSection == null) {
            return this.deriveTargetsFromDirectoriesSectionFalse(projectView);
        }
        ProjectViewDirectoriesSection directories = projectViewDirectoriesSection;
        if (this.hasEmptyIncludedValuesAndEmptyExcludedValuesDirectories(directories)) {
            targetsSpec = this.deriveTargetsFromDirectoriesSectionFalse(projectView);
        } else {
            if (this.hasEmptyIncludedValuesAndNonEmptyExcludedValuesDirectories(directories)) {
                throw new ExecutionContextEntityExtractorException(NAME, "'directories' section has no included targets.");
            }
            targetsSpec = this.mapNotEmptyDerivedTargetSection(projectView.getTargets(), directories);
        }
        return targetsSpec;
    }

    private final TargetsSpec deriveTargetsFromDirectoriesSectionFalse(ProjectView projectView) {
        TargetsSpec targetsSpec;
        ProjectViewTargetsSection projectViewTargetsSection = projectView.getTargets();
        if (projectViewTargetsSection == null) {
            return TargetsSpecKt.access$getDefaultTargetsSpec$p();
        }
        ProjectViewTargetsSection targets2 = projectViewTargetsSection;
        if (this.hasEmptyIncludedValuesAndEmptyExcludedValues(targets2)) {
            targetsSpec = TargetsSpecKt.access$getDefaultTargetsSpec$p();
        } else {
            if (this.hasEmptyIncludedValuesAndNonEmptyExcludedValues(targets2)) {
                throw new ExecutionContextEntityExtractorException(NAME, "'targets' section has no included targets.");
            }
            targetsSpec = this.mapNotEmptyNotDerivedTargetsSection(targets2);
        }
        return targetsSpec;
    }

    private final boolean hasEmptyIncludedValuesAndEmptyExcludedValues(ProjectViewTargetsSection targetsSection) {
        return targetsSection.getValues().isEmpty() & targetsSection.getExcludedValues().isEmpty();
    }

    private final boolean hasEmptyIncludedValuesAndNonEmptyExcludedValues(ProjectViewTargetsSection targetsSection) {
        return targetsSection.getValues().isEmpty() & !((Collection)targetsSection.getExcludedValues()).isEmpty();
    }

    private final boolean hasEmptyIncludedValuesAndEmptyExcludedValuesDirectories(ProjectViewDirectoriesSection directoriesSection) {
        return directoriesSection.getValues().isEmpty() & directoriesSection.getExcludedValues().isEmpty();
    }

    private final boolean hasEmptyIncludedValuesAndNonEmptyExcludedValuesDirectories(ProjectViewDirectoriesSection directoriesSection) {
        return directoriesSection.getValues().isEmpty() & !((Collection)directoriesSection.getExcludedValues()).isEmpty();
    }

    private final TargetsSpec mapNotEmptyNotDerivedTargetsSection(ProjectViewTargetsSection targetsSection) {
        return new TargetsSpec(targetsSection.getValues(), targetsSection.getExcludedValues());
    }

    /*
     * WARNING - void declaration
     */
    private final TargetsSpec mapNotEmptyDerivedTargetSection(ProjectViewTargetsSection targetsSection, ProjectViewDirectoriesSection directoriesSection) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = directoriesSection.getValues();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Path path2 = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.mapDirectoryToTarget((Path)it));
        }
        List directoriesValues = (List)destination$iv$iv;
        Iterable $this$map$iv2 = directoriesSection.getExcludedValues();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path bl = (Path)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(INSTANCE.mapDirectoryToTarget((Path)it));
        }
        List directoriesExcludedValues = (List)destination$iv$iv2;
        ProjectViewTargetsSection projectViewTargetsSection = targetsSection;
        List list = projectViewTargetsSection != null ? projectViewTargetsSection.getValues() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List list2 = CollectionsKt.plus((Collection)list, (Iterable)directoriesValues);
        ProjectViewTargetsSection projectViewTargetsSection2 = targetsSection;
        List list3 = projectViewTargetsSection2 != null ? projectViewTargetsSection2.getExcludedValues() : null;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return new TargetsSpec(list2, CollectionsKt.plus((Collection)list3, (Iterable)directoriesExcludedValues));
    }

    private final Label mapDirectoryToTarget(Path buildDirectoryIdentifier) {
        return Intrinsics.areEqual((Object)((Object)buildDirectoryIdentifier).toString(), (Object)".") ? Label.Companion.parse("//...") : Label.Companion.parse("//" + ((Object)buildDirectoryIdentifier).toString() + "/...");
    }
}

