/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.workspacecontext;

import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.executioncontext.api.ExecutionContextConstructor;
import org.jetbrains.bsp.bazel.projectview.model.ProjectView;
import org.jetbrains.bsp.bazel.workspacecontext.AllowManualTargetsSyncSpecExtractor;
import org.jetbrains.bsp.bazel.workspacecontext.AndroidMinSdkSpecExtractor;
import org.jetbrains.bsp.bazel.workspacecontext.BazelBinarySpecExtractor;
import org.jetbrains.bsp.bazel.workspacecontext.BuildFlagsSpecExtractor;
import org.jetbrains.bsp.bazel.workspacecontext.DirectoriesSpecExtractor;
import org.jetbrains.bsp.bazel.workspacecontext.DotBazelBspDirPathSpec;
import org.jetbrains.bsp.bazel.workspacecontext.EnableNativeAndroidRulesExtractor;
import org.jetbrains.bsp.bazel.workspacecontext.EnabledRulesSpecExtractor;
import org.jetbrains.bsp.bazel.workspacecontext.ExperimentalAddTransitiveCompileTimeJarsExtractor;
import org.jetbrains.bsp.bazel.workspacecontext.ExperimentalNoPruneTransitiveCompileTimeJarsPatternsExtractor;
import org.jetbrains.bsp.bazel.workspacecontext.ExperimentalTransitiveCompileTimeJarsTargetKindsExtractor;
import org.jetbrains.bsp.bazel.workspacecontext.IdeJavaHomeOverrideSpecExtractor;
import org.jetbrains.bsp.bazel.workspacecontext.ImportDepthSpecExtractor;
import org.jetbrains.bsp.bazel.workspacecontext.ShardSyncSpecExtractor;
import org.jetbrains.bsp.bazel.workspacecontext.ShardingApproachSpecExtractor;
import org.jetbrains.bsp.bazel.workspacecontext.SyncFlagsSpecExtractor;
import org.jetbrains.bsp.bazel.workspacecontext.TargetShardSizeSpecExtractor;
import org.jetbrains.bsp.bazel.workspacecontext.TargetsSpecExtractor;
import org.jetbrains.bsp.bazel.workspacecontext.WorkspaceContext;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/bsp/bazel/workspacecontext/WorkspaceContextConstructor;", "Lorg/jetbrains/bsp/bazel/executioncontext/api/ExecutionContextConstructor;", "Lorg/jetbrains/bsp/bazel/workspacecontext/WorkspaceContext;", "workspaceRoot", "Ljava/nio/file/Path;", "dotBazelBspDirPath", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "directoriesSpecExtractor", "Lorg/jetbrains/bsp/bazel/workspacecontext/DirectoriesSpecExtractor;", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/apache/logging/log4j/Logger;", "construct", "projectView", "Lorg/jetbrains/bsp/bazel/projectview/model/ProjectView;", "server_executioncontext_workspacecontext_src_main_kotlin_org_jetbrains_bsp_bazel_workspacecontext-workspacecontext"})
public final class WorkspaceContextConstructor
implements ExecutionContextConstructor<WorkspaceContext> {
    @NotNull
    private final Path dotBazelBspDirPath;
    @NotNull
    private final DirectoriesSpecExtractor directoriesSpecExtractor;
    private final Logger log;

    public WorkspaceContextConstructor(@NotNull Path workspaceRoot, @NotNull Path dotBazelBspDirPath) {
        Intrinsics.checkNotNullParameter((Object)workspaceRoot, (String)"workspaceRoot");
        Intrinsics.checkNotNullParameter((Object)dotBazelBspDirPath, (String)"dotBazelBspDirPath");
        this.dotBazelBspDirPath = dotBazelBspDirPath;
        this.directoriesSpecExtractor = new DirectoriesSpecExtractor(workspaceRoot);
        this.log = LogManager.getLogger(WorkspaceContextConstructor.class);
    }

    @Override
    @NotNull
    public WorkspaceContext construct(@NotNull ProjectView projectView) {
        Intrinsics.checkNotNullParameter((Object)projectView, (String)"projectView");
        this.log.info("Constructing workspace context for: {}.", (Object)projectView);
        return new WorkspaceContext(TargetsSpecExtractor.INSTANCE.fromProjectView(projectView), this.directoriesSpecExtractor.fromProjectView(projectView), BuildFlagsSpecExtractor.INSTANCE.fromProjectView(projectView), SyncFlagsSpecExtractor.INSTANCE.fromProjectView(projectView), BazelBinarySpecExtractor.INSTANCE.fromProjectView(projectView), AllowManualTargetsSyncSpecExtractor.INSTANCE.fromProjectView(projectView), new DotBazelBspDirPathSpec(this.dotBazelBspDirPath), ImportDepthSpecExtractor.INSTANCE.fromProjectView(projectView), EnabledRulesSpecExtractor.INSTANCE.fromProjectView(projectView), IdeJavaHomeOverrideSpecExtractor.INSTANCE.fromProjectView(projectView), ExperimentalAddTransitiveCompileTimeJarsExtractor.INSTANCE.fromProjectView(projectView), ExperimentalTransitiveCompileTimeJarsTargetKindsExtractor.INSTANCE.fromProjectView(projectView), ExperimentalNoPruneTransitiveCompileTimeJarsPatternsExtractor.INSTANCE.fromProjectView(projectView), EnableNativeAndroidRulesExtractor.INSTANCE.fromProjectView(projectView), AndroidMinSdkSpecExtractor.INSTANCE.fromProjectView(projectView), ShardSyncSpecExtractor.INSTANCE.fromProjectView(projectView), TargetShardSizeSpecExtractor.INSTANCE.fromProjectView(projectView), ShardingApproachSpecExtractor.INSTANCE.fromProjectView(projectView));
    }
}

