/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.protocol.utils;

import ch.epfl.scala.bsp4j.BuildTarget;
import ch.epfl.scala.bsp4j.JvmBuildTarget;
import ch.epfl.scala.bsp4j.PythonBuildTarget;
import ch.epfl.scala.bsp4j.ScalaBuildTarget;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bsp.protocol.AndroidBuildTarget;
import org.jetbrains.bsp.protocol.GoBuildTarget;
import org.jetbrains.bsp.protocol.KotlinBuildTarget;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\u0006\b\u0000\u0010\u0001\u0018\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0082\b\u00a2\u0006\u0002\u0010\u0006\u001a\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0013"}, d2={"extractData", "Data", "target", "Lch/epfl/scala/bsp4j/BuildTarget;", "kind", "", "(Lch/epfl/scala/bsp4j/BuildTarget;Ljava/lang/String;)Ljava/lang/Object;", "extractPythonBuildTarget", "Lch/epfl/scala/bsp4j/PythonBuildTarget;", "extractScalaBuildTarget", "Lch/epfl/scala/bsp4j/ScalaBuildTarget;", "extractAndroidBuildTarget", "Lorg/jetbrains/bsp/protocol/AndroidBuildTarget;", "extractGoBuildTarget", "Lorg/jetbrains/bsp/protocol/GoBuildTarget;", "extractKotlinBuildTarget", "Lorg/jetbrains/bsp/protocol/KotlinBuildTarget;", "extractJvmBuildTarget", "Lch/epfl/scala/bsp4j/JvmBuildTarget;", "protocol-protocol"})
@SourceDebugExtension(value={"SMAP\nExtractors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extractors.kt\norg/jetbrains/bsp/protocol/utils/ExtractorsKt\n*L\n1#1,45:1\n15#1,12:46\n15#1,12:58\n15#1,12:70\n15#1,12:82\n15#1,12:94\n15#1,12:106\n*S KotlinDebug\n*F\n+ 1 Extractors.kt\norg/jetbrains/bsp/protocol/utils/ExtractorsKt\n*L\n28#1:46,12\n30#1:58,12\n32#1:70,12\n34#1:82,12\n37#1:94,12\n41#1:106,12\n*E\n"})
public final class ExtractorsKt {
    private static final /* synthetic */ <Data> Data extractData(BuildTarget target, String kind) {
        Object object;
        boolean $i$f$extractData = false;
        if (Intrinsics.areEqual((Object)target.getDataKind(), (Object)kind)) {
            Object object2 = target.getData();
            Intrinsics.reifiedOperationMarker((int)3, (String)"Data");
            if (object2 instanceof Object) {
                Object object3 = target.getData();
                Intrinsics.reifiedOperationMarker((int)1, (String)"Data");
                object = object3;
            } else {
                Gson gson = new Gson();
                Object object4 = target.getData();
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
                JsonElement jsonElement = (JsonElement)((JsonObject)object4);
                Intrinsics.reifiedOperationMarker((int)4, (String)"Data");
                object = gson.fromJson(jsonElement, Object.class);
            }
        } else {
            object = null;
        }
        return (Data)object;
    }

    @Nullable
    public static final PythonBuildTarget extractPythonBuildTarget(@NotNull BuildTarget target) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String kind$iv = "python";
        boolean $i$f$extractData = false;
        if (Intrinsics.areEqual((Object)target.getDataKind(), (Object)kind$iv)) {
            Object object2 = target.getData();
            if (object2 != null ? object2 instanceof PythonBuildTarget : true) {
                object = (PythonBuildTarget)target.getData();
            } else {
                Gson gson = new Gson();
                Object object3 = target.getData();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
                object = gson.fromJson((JsonElement)((JsonObject)object3), PythonBuildTarget.class);
            }
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final ScalaBuildTarget extractScalaBuildTarget(@NotNull BuildTarget target) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String kind$iv = "scala";
        boolean $i$f$extractData = false;
        if (Intrinsics.areEqual((Object)target.getDataKind(), (Object)kind$iv)) {
            Object object2 = target.getData();
            if (object2 != null ? object2 instanceof ScalaBuildTarget : true) {
                object = (ScalaBuildTarget)target.getData();
            } else {
                Gson gson = new Gson();
                Object object3 = target.getData();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
                object = gson.fromJson((JsonElement)((JsonObject)object3), ScalaBuildTarget.class);
            }
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final AndroidBuildTarget extractAndroidBuildTarget(@NotNull BuildTarget target) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String kind$iv = "android";
        boolean $i$f$extractData = false;
        if (Intrinsics.areEqual((Object)target.getDataKind(), (Object)kind$iv)) {
            Object object2 = target.getData();
            if (object2 != null ? object2 instanceof AndroidBuildTarget : true) {
                object = (AndroidBuildTarget)target.getData();
            } else {
                Gson gson = new Gson();
                Object object3 = target.getData();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
                object = gson.fromJson((JsonElement)((JsonObject)object3), AndroidBuildTarget.class);
            }
        } else {
            object = null;
        }
        return (AndroidBuildTarget)object;
    }

    @Nullable
    public static final GoBuildTarget extractGoBuildTarget(@NotNull BuildTarget target) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String kind$iv = "go";
        boolean $i$f$extractData = false;
        if (Intrinsics.areEqual((Object)target.getDataKind(), (Object)kind$iv)) {
            Object object2 = target.getData();
            if (object2 != null ? object2 instanceof GoBuildTarget : true) {
                object = (GoBuildTarget)target.getData();
            } else {
                Gson gson = new Gson();
                Object object3 = target.getData();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
                object = gson.fromJson((JsonElement)((JsonObject)object3), GoBuildTarget.class);
            }
        } else {
            object = null;
        }
        return (GoBuildTarget)object;
    }

    @Nullable
    public static final KotlinBuildTarget extractKotlinBuildTarget(@NotNull BuildTarget target) {
        KotlinBuildTarget kotlinBuildTarget;
        Object object;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String kind$iv = "kotlin";
        boolean $i$f$extractData = false;
        if (Intrinsics.areEqual((Object)target.getDataKind(), (Object)kind$iv)) {
            Object object2 = target.getData();
            if (object2 != null ? object2 instanceof KotlinBuildTarget : true) {
                object = (KotlinBuildTarget)target.getData();
            } else {
                Gson gson = new Gson();
                Object object3 = target.getData();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
                object = gson.fromJson((JsonElement)((JsonObject)object3), KotlinBuildTarget.class);
            }
        } else {
            object = null;
        }
        if ((kotlinBuildTarget = (KotlinBuildTarget)object) == null) {
            AndroidBuildTarget androidBuildTarget = ExtractorsKt.extractAndroidBuildTarget(target);
            kotlinBuildTarget = androidBuildTarget != null ? androidBuildTarget.getKotlinBuildTarget() : null;
        }
        return kotlinBuildTarget;
    }

    @Nullable
    public static final JvmBuildTarget extractJvmBuildTarget(@NotNull BuildTarget target) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String kind$iv = "jvm";
        boolean $i$f$extractData = false;
        if (Intrinsics.areEqual((Object)target.getDataKind(), (Object)kind$iv)) {
            Object object3 = target.getData();
            if (object3 != null ? object3 instanceof JvmBuildTarget : true) {
                object2 = (JvmBuildTarget)target.getData();
            } else {
                Gson gson = new Gson();
                Object object4 = target.getData();
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
                object2 = gson.fromJson((JsonElement)((JsonObject)object4), JvmBuildTarget.class);
            }
        } else {
            object2 = null;
        }
        if ((object = (JvmBuildTarget)object2) == null) {
            AndroidBuildTarget androidBuildTarget = ExtractorsKt.extractAndroidBuildTarget(target);
            object = androidBuildTarget != null ? androidBuildTarget.getJvmBuildTarget() : null;
            if (object == null) {
                KotlinBuildTarget kotlinBuildTarget = ExtractorsKt.extractKotlinBuildTarget(target);
                object = kotlinBuildTarget != null ? kotlinBuildTarget.getJvmBuildTarget() : null;
                if (object == null) {
                    ScalaBuildTarget scalaBuildTarget = ExtractorsKt.extractScalaBuildTarget(target);
                    object = scalaBuildTarget != null ? scalaBuildTarget.getJvmBuildTarget() : null;
                }
            }
        }
        return object;
    }
}

