/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.bazelsteward.bazel.rules;

import java.io.Closeable;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.virtuslab.bazelsteward.bazel.rules.GithubRulesResolver;
import org.virtuslab.bazelsteward.bazel.rules.RuleLibraryId;
import org.virtuslab.bazelsteward.bazel.rules.RuleVersion;
import org.virtuslab.bazelsteward.bazel.rules.RulesResolver;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\u0007H\u0016J$\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f*\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/virtuslab/bazelsteward/bazel/rules/GithubRulesResolver;", "Lorg/virtuslab/bazelsteward/bazel/rules/RulesResolver;", "gitHubClient", "Lorg/kohsuke/github/GitHub;", "(Lorg/kohsuke/github/GitHub;)V", "resolveRuleVersions", "", "Lorg/virtuslab/bazelsteward/bazel/rules/RuleLibraryId;", "Lorg/virtuslab/bazelsteward/bazel/rules/RuleVersion;", "ruleId", "shaFromBodyAndCurrentUrl", "Lkotlin/Pair;", "release", "Lorg/kohsuke/github/GHRelease;", "listReleases", "Lkotlin/sequences/Sequence;", "Lorg/virtuslab/bazelsteward/bazel/rules/GithubRulesResolver$Companion$RepositoryId;", "Companion", "kinds_bazel_rules_src_main_kotlin_org_virtuslab_bazelsteward_bazel_rules-rules"})
public final class GithubRulesResolver
implements RulesResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitHub gitHubClient;
    @NotNull
    private static final Regex sha256Regex = new Regex("\\b[A-Fa-f0-9]{64}\\b");

    public GithubRulesResolver(@NotNull GitHub gitHubClient) {
        Intrinsics.checkNotNullParameter((Object)gitHubClient, (String)"gitHubClient");
        this.gitHubClient = gitHubClient;
    }

    @NotNull
    public Map<RuleLibraryId, RuleVersion> resolveRuleVersions(@NotNull RuleLibraryId ruleId) {
        Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
        return MapsKt.toMap((Sequence)SequencesKt.map(this.listReleases(GithubRulesResolver.Companion.toRepositoryId(ruleId)), (Function1)((Function1)new Function1<GHRelease, Pair<? extends RuleLibraryId, ? extends RuleVersion>>(this, ruleId){
            final /* synthetic */ GithubRulesResolver this$0;
            final /* synthetic */ RuleLibraryId $ruleId;
            {
                this.this$0 = $receiver;
                this.$ruleId = $ruleId;
                super(1);
            }

            @NotNull
            public final Pair<RuleLibraryId, RuleVersion> invoke(@NotNull GHRelease it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GithubRulesResolver.access$shaFromBodyAndCurrentUrl(this.this$0, this.$ruleId, it);
            }
        })));
    }

    private final Pair<RuleLibraryId, RuleVersion> shaFromBodyAndCurrentUrl(RuleLibraryId ruleId, GHRelease release) {
        String string = release.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"release.body");
        String sha = (String)SequencesKt.singleOrNull((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)sha256Regex, (CharSequence)string, (int)0, (int)2, null), (Function1)shaFromBodyAndCurrentUrl.1.INSTANCE));
        boolean bl = false;
        String string2 = ruleId.getArtifactName();
        String string3 = ruleId.getTag();
        String string4 = release.getTagName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"release.tagName");
        String newArtifactName = StringsKt.replace$default((String)string2, (String)string3, (String)string4, (boolean)false, (int)4, null);
        String string5 = release.getTagName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"release.tagName");
        RuleLibraryId rule = GithubRulesResolver.Companion.copy(ruleId, string5, newArtifactName);
        String string6 = rule.getDownloadUrl();
        String string7 = release.getTagName();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"release.tagName");
        return TuplesKt.to((Object)rule, (Object)RuleVersion.Companion.create(string6, sha, string7, release.getPublished_at().toInstant()));
    }

    private final Sequence<GHRelease> listReleases(Companion.RepositoryId $this$listReleases) {
        PagedIterable pagedIterable = this.gitHubClient.getRepository($this$listReleases.toString()).listReleases();
        Intrinsics.checkNotNullExpressionValue((Object)pagedIterable, (String)"gitHubClient.getReposito\u2026oString()).listReleases()");
        return CollectionsKt.asSequence((Iterable)((Iterable)pagedIterable));
    }

    public static final /* synthetic */ Pair access$shaFromBodyAndCurrentUrl(GithubRulesResolver $this, RuleLibraryId ruleId, GHRelease release) {
        return $this.shaFromBodyAndCurrentUrl(ruleId, release);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u001c\u0010\n\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0019\u0010\u000f\u001a\u00020\r*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\f\u0010\u0014\u001a\u00020\r*\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/virtuslab/bazelsteward/bazel/rules/GithubRulesResolver$Companion;", "", "()V", "sha256Regex", "Lkotlin/text/Regex;", "levenshtein", "", "lhs", "", "rhs", "copy", "Lorg/virtuslab/bazelsteward/bazel/rules/RuleLibraryId;", "tag", "", "artifactName", "getFileChecksum", "Ljava/net/URL;", "digest", "Ljava/security/MessageDigest;", "getFileChecksum$kinds_bazel_rules_src_main_kotlin_org_virtuslab_bazelsteward_bazel_rules_rules", "sha256", "Lorg/kohsuke/github/GHAsset;", "toRepositoryId", "Lorg/virtuslab/bazelsteward/bazel/rules/GithubRulesResolver$Companion$RepositoryId;", "RepositoryId", "kinds_bazel_rules_src_main_kotlin_org_virtuslab_bazelsteward_bazel_rules-rules"})
    public static final class Companion {
        private Companion() {
        }

        private final RepositoryId toRepositoryId(RuleLibraryId $this$toRepositoryId) {
            return new RepositoryId($this$toRepositoryId.getRepoName(), $this$toRepositoryId.getRuleName());
        }

        private final String sha256(GHAsset $this$sha256) {
            URL uRL = new URL($this$sha256.getBrowserDownloadUrl());
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(\"SHA-256\")");
            return this.getFileChecksum$kinds_bazel_rules_src_main_kotlin_org_virtuslab_bazelsteward_bazel_rules_rules(uRL, messageDigest);
        }

        private final RuleLibraryId copy(RuleLibraryId $this$copy, String tag, String artifactName) {
            RuleLibraryId ruleLibraryId;
            RuleLibraryId ruleLibraryId2 = $this$copy;
            if (ruleLibraryId2 instanceof RuleLibraryId.ReleaseArtifact) {
                ruleLibraryId = RuleLibraryId.ReleaseArtifact.copy$default((RuleLibraryId.ReleaseArtifact)$this$copy, tag, artifactName, null, null, 12, null);
            } else if (ruleLibraryId2 instanceof RuleLibraryId.ArchiveTagRuleId) {
                ruleLibraryId = RuleLibraryId.ArchiveTagRuleId.copy$default((RuleLibraryId.ArchiveTagRuleId)$this$copy, tag, artifactName, null, null, 12, null);
            } else if (ruleLibraryId2 instanceof RuleLibraryId.ArchiveRuleId) {
                ruleLibraryId = RuleLibraryId.ArchiveRuleId.copy$default((RuleLibraryId.ArchiveRuleId)$this$copy, tag, artifactName, null, null, 12, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return ruleLibraryId;
        }

        private final int levenshtein(CharSequence lhs, CharSequence rhs) {
            if (Intrinsics.areEqual((Object)lhs, (Object)rhs)) {
                return 0;
            }
            if (lhs.length() == 0) {
                return rhs.length();
            }
            if (rhs.length() == 0) {
                return lhs.length();
            }
            int lhsLength = lhs.length() + 1;
            int rhsLength = rhs.length() + 1;
            int n = 0;
            Integer[] integerArray = new Integer[lhsLength];
            while (n < lhsLength) {
                int n2 = n++;
                integerArray[n2] = n2;
            }
            Integer[] cost = integerArray;
            int n3 = 0;
            Integer[] integerArray2 = new Integer[lhsLength];
            while (n3 < lhsLength) {
                int n4 = n3++;
                integerArray2[n4] = 0;
            }
            Integer[] newCost = integerArray2;
            for (int i = 1; i < rhsLength; ++i) {
                newCost[0] = i;
                for (int j = 1; j < lhsLength; ++j) {
                    int match = lhs.charAt(j - 1) == rhs.charAt(i - 1) ? 0 : 1;
                    int costReplace = cost[j - 1] + match;
                    int costInsert = cost[j] + 1;
                    int costDelete = newCost[j - 1] + 1;
                    newCost[j] = Math.min(Math.min(costInsert, costDelete), costReplace);
                }
                Integer[] swap = cost;
                cost = newCost;
                newCost = swap;
            }
            return cost[lhsLength - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String getFileChecksum$kinds_bazel_rules_src_main_kotlin_org_virtuslab_bazelsteward_bazel_rules_rules(@NotNull URL $this$getFileChecksum, @NotNull MessageDigest digest) {
            Intrinsics.checkNotNullParameter((Object)$this$getFileChecksum, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
            MessageDigest messageDigest = null;
            Closeable closeable = new DigestInputStream($this$getFileChecksum.openStream(), digest);
            Object object = null;
            try {
                DigestInputStream dis = (DigestInputStream)closeable;
                boolean bl = false;
                while (dis.read() != -1) {
                }
                MessageDigest messageDigest2 = dis.getMessageDigest();
                Intrinsics.checkNotNullExpressionValue((Object)messageDigest2, (String)"dis.messageDigest");
                messageDigest = messageDigest2;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            StringBuilder result = new StringBuilder();
            byte[] byArray = messageDigest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"messageDigest.digest()");
            for (Object b : (Object)byArray) {
                String string = "%02x";
                Object[] objectArray = new Object[]{(byte)b};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                result.append(string2);
            }
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/virtuslab/bazelsteward/bazel/rules/GithubRulesResolver$Companion$RepositoryId;", "", "user", "", "repository", "(Ljava/lang/String;Ljava/lang/String;)V", "getRepository", "()Ljava/lang/String;", "getUser", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kinds_bazel_rules_src_main_kotlin_org_virtuslab_bazelsteward_bazel_rules-rules"})
        private static final class RepositoryId {
            @NotNull
            private final String user;
            @NotNull
            private final String repository;

            public RepositoryId(@NotNull String user, @NotNull String repository) {
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                this.user = user;
                this.repository = repository;
            }

            @NotNull
            public final String getUser() {
                return this.user;
            }

            @NotNull
            public final String getRepository() {
                return this.repository;
            }

            @NotNull
            public String toString() {
                return this.user + "/" + this.repository;
            }

            @NotNull
            public final String component1() {
                return this.user;
            }

            @NotNull
            public final String component2() {
                return this.repository;
            }

            @NotNull
            public final RepositoryId copy(@NotNull String user, @NotNull String repository) {
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                return new RepositoryId(user, repository);
            }

            public static /* synthetic */ RepositoryId copy$default(RepositoryId repositoryId, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = repositoryId.user;
                }
                if ((n & 2) != 0) {
                    string2 = repositoryId.repository;
                }
                return repositoryId.copy(string, string2);
            }

            public int hashCode() {
                int result = this.user.hashCode();
                result = result * 31 + this.repository.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RepositoryId)) {
                    return false;
                }
                RepositoryId repositoryId = (RepositoryId)other;
                if (!Intrinsics.areEqual((Object)this.user, (Object)repositoryId.user)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.repository, (Object)repositoryId.repository);
            }
        }
    }
}

