/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.bazelsteward.github;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestCommitDetail;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHubBuilder;
import org.virtuslab.bazelsteward.core.Environment;
import org.virtuslab.bazelsteward.core.GitBranch;
import org.virtuslab.bazelsteward.core.GitHostClient;
import org.virtuslab.bazelsteward.core.NewPullRequest;
import org.virtuslab.bazelsteward.core.PullRequest;
import org.virtuslab.bazelsteward.core.common.GitClient;
import org.virtuslab.bazelsteward.github.GithubClient;
import org.virtuslab.bazelsteward.github.GithubClientKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B;\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\fH\u0016J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0003H\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\fH\u0016J!\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\"H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Lorg/virtuslab/bazelsteward/github/GithubClient;", "Lorg/virtuslab/bazelsteward/core/GitHostClient;", "url", "", "baseBranch", "gitAuthor", "Lorg/virtuslab/bazelsteward/core/common/GitClient$GitAuthor;", "repository", "token", "personalToken", "(Ljava/lang/String;Ljava/lang/String;Lorg/virtuslab/bazelsteward/core/common/GitClient$GitAuthor;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "bazelPRs", "", "Lorg/kohsuke/github/GHPullRequest;", "branchToGHPR", "", "ghPatRepository", "Lorg/kohsuke/github/GHRepository;", "ghRepository", "checkPrStatus", "Lorg/virtuslab/bazelsteward/core/GitHostClient$PrStatus;", "pr", "branch", "Lorg/virtuslab/bazelsteward/core/GitBranch;", "closePrs", "", "pullRequests", "Lorg/virtuslab/bazelsteward/core/PullRequest;", "createClient", "getOpenPrs", "onPrChange", "prStatusBefore", "(Lorg/virtuslab/bazelsteward/core/PullRequest;Lorg/virtuslab/bazelsteward/core/GitHostClient$PrStatus;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "openNewPr", "Lorg/virtuslab/bazelsteward/core/NewPullRequest;", "Companion", "github_src_main_kotlin_org_virtuslab_bazelsteward_github-github"})
public final class GithubClient
implements GitHostClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final String baseBranch;
    @NotNull
    private final GitClient.GitAuthor gitAuthor;
    @NotNull
    private final String repository;
    @NotNull
    private final GHRepository ghRepository;
    @Nullable
    private final GHRepository ghPatRepository;
    @NotNull
    private final List<GHPullRequest> bazelPRs;
    @NotNull
    private final Map<String, GHPullRequest> branchToGHPR;

    /*
     * WARNING - void declaration
     */
    private GithubClient(String url, String baseBranch, GitClient.GitAuthor gitAuthor2, String repository, String token, String personalToken) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        GHRepository gHRepository;
        GithubClient githubClient;
        this.url = url;
        this.baseBranch = baseBranch;
        this.gitAuthor = gitAuthor2;
        this.repository = repository;
        this.ghRepository = this.createClient(token);
        GithubClient githubClient2 = this;
        String string = personalToken;
        if (string != null) {
            void it;
            String string2 = string;
            githubClient = githubClient2;
            boolean bl = false;
            gHRepository = this.createClient((String)it);
            githubClient2 = githubClient;
        } else {
            gHRepository = null;
        }
        githubClient2.ghPatRepository = gHRepository;
        List list = this.ghRepository.queryPullRequests().state(GHIssueState.ALL).list().toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ghRepository.queryPullRe\u2026tate.ALL).list().toList()");
        this.bazelPRs = list;
        Iterable iterable = this.bazelPRs;
        githubClient = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var10_12 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            GHPullRequest gHPullRequest = (GHPullRequest)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            String string3 = it.getHead().getRef();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.head.ref");
            map.put(string3, element$iv$iv);
        }
        githubClient.branchToGHPR = destination$iv$iv;
    }

    /* synthetic */ GithubClient(String string, String string2, GitClient.GitAuthor gitAuthor2, String string3, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            string5 = null;
        }
        this(string, string2, gitAuthor2, string3, string4, string5);
    }

    @Override
    @NotNull
    public GitHostClient.PrStatus checkPrStatus(@NotNull GitBranch branch) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        return this.checkPrStatus(this.branchToGHPR.get(branch.getName()));
    }

    @Override
    @NotNull
    public PullRequest openNewPr(@NotNull NewPullRequest pr) {
        Intrinsics.checkNotNullParameter((Object)pr, (String)"pr");
        GithubClientKt.access$getLogger$p().info((Function0)new Function0<Object>(pr){
            final /* synthetic */ NewPullRequest $pr;
            {
                this.$pr = $pr;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Creating pull request for " + this.$pr.getBranch();
            }
        });
        GHPullRequest newPr = this.ghRepository.createPullRequest(pr.getTitle(), pr.getBranch().getName(), this.baseBranch, pr.getBody());
        if (!((Collection)pr.getLabels()).isEmpty()) {
            Collection $this$toTypedArray$iv = pr.getLabels();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            newPr.addLabels(Arrays.copyOf(stringArray, stringArray.length));
        }
        return new PullRequest(pr.getBranch());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PullRequest> getOpenPrs() {
        void $this$mapTo$iv$iv;
        GHPullRequest it;
        Iterable $this$filterTo$iv$iv;
        GitHostClient.PrStatus[] prStatusArray = new GitHostClient.PrStatus[]{GitHostClient.PrStatus.OPEN_MERGEABLE, GitHostClient.PrStatus.OPEN_NOT_MERGEABLE};
        Set openStatuses = SetsKt.setOf((Object[])prStatusArray);
        Iterable $this$filter$iv = this.bazelPRs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GHPullRequest)element$iv$iv;
            boolean bl = false;
            if (!openStatuses.contains((Object)this.checkPrStatus(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (GHPullRequest)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getHead().getRef();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.head.ref");
            collection.add(new PullRequest(new GitBranch(string)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closePrs(@NotNull List<PullRequest> pullRequests) {
        void $this$filterTo$iv$iv;
        GHPullRequest it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(pullRequests, (String)"pullRequests");
        Iterable $this$map$iv = pullRequests;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PullRequest pullRequest = (PullRequest)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getBranch().getName());
        }
        List names = (List)destination$iv$iv;
        Iterable $this$filter$iv = this.bazelPRs;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GHPullRequest)element$iv$iv;
            boolean bl = false;
            if (!names.contains(it.getHead().getRef())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GHPullRequest it2 = (GHPullRequest)element$iv;
            boolean bl = false;
            it2.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object onPrChange(@NotNull PullRequest var1_1, @NotNull GitHostClient.PrStatus var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof onPrChange.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ GithubClient this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.onPrChange(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.ghPatRepository;
                if (v0 == null) break;
                repository = v0;
                $i$a$-let-GithubClient$onPrChange$2 = false;
                if (prStatusBefore != GitHostClient.PrStatus.NONE) {
                    $continuation.L$0 = pr;
                    $continuation.L$1 = repository;
                    $continuation.label = 1;
                    v1 = DelayKt.delay((long)10000L, (Continuation)$continuation);
                    if (v1 == var10_6) {
                        return var10_6;
                    }
                }
                ** GOTO lbl30
            }
            case 1: {
                $i$a$-let-GithubClient$onPrChange$2 = false;
                repository = (GHRepository)$continuation.L$1;
                pr = (PullRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl30:
                // 2 sources

                var6_11 = repository.queryPullRequests().state(GHIssueState.OPEN).head(pr.getBranch().getName()).list();
                Intrinsics.checkNotNullExpressionValue((Object)var6_11, (String)"repository.queryPullRequ\u2026ad(pr.branch.name).list()");
                v2 = (GHPullRequest)CollectionsKt.firstOrNull((Iterable)((Iterable)var6_11));
                if (v2 == null) {
                    throw new RuntimeException("PR for branch " + pr.getBranch().getName() + " not found");
                }
                ghPr = v2;
                ghPr.close();
                $continuation.L$0 = ghPr;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v3 = DelayKt.delay((long)1000L, (Continuation)$continuation);
                if (v3 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl49
            }
            case 2: {
                $i$a$-let-GithubClient$onPrChange$2 = false;
                ghPr = (GHPullRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl49:
                // 2 sources

                ghPr.reopen();
                break;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final GitHostClient.PrStatus checkPrStatus(GHPullRequest pr) {
        GitHostClient.PrStatus prStatus;
        if (pr == null) {
            prStatus = GitHostClient.PrStatus.NONE;
        } else if (pr.isMerged()) {
            prStatus = GitHostClient.PrStatus.MERGED;
        } else if (pr.getState() == GHIssueState.CLOSED) {
            prStatus = GitHostClient.PrStatus.CLOSED;
        } else {
            boolean bl;
            block17: {
                List list = pr.listCommits().toList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pr.listCommits().toList()");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GHPullRequestCommitDetail it = (GHPullRequestCommitDetail)element$iv;
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual((Object)it.getCommit().getAuthor().getName(), (Object)this.gitAuthor.getName()))) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            if (bl) {
                prStatus = GitHostClient.PrStatus.OPEN_MODIFIED;
            } else {
                Boolean bl3 = pr.getMergeable();
                if (bl3 == null) {
                    prStatus = GitHostClient.PrStatus.OPEN_MODIFIED;
                } else if (Intrinsics.areEqual((Object)bl3, (Object)true)) {
                    prStatus = GitHostClient.PrStatus.OPEN_MERGEABLE;
                } else if (Intrinsics.areEqual((Object)bl3, (Object)false)) {
                    prStatus = GitHostClient.PrStatus.OPEN_NOT_MERGEABLE;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return prStatus;
    }

    private final GHRepository createClient(String token) {
        GHRepository gHRepository = new GitHubBuilder().withOAuthToken(token).withEndpoint(this.url).build().getRepository(this.repository);
        if (gHRepository == null) {
            throw new IllegalStateException("Github repository must exist");
        }
        return gHRepository;
    }

    public /* synthetic */ GithubClient(String url, String baseBranch, GitClient.GitAuthor gitAuthor2, String repository, String token, String personalToken, DefaultConstructorMarker $constructor_marker) {
        this(url, baseBranch, gitAuthor2, repository, token, personalToken);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lorg/virtuslab/bazelsteward/github/GithubClient$Companion;", "", "()V", "getClient", "Lorg/virtuslab/bazelsteward/github/GithubClient;", "env", "Lorg/virtuslab/bazelsteward/core/Environment;", "baseBranch", "", "gitAuthor", "Lorg/virtuslab/bazelsteward/core/common/GitClient$GitAuthor;", "getRepoPath", "Ljava/nio/file/Path;", "github_src_main_kotlin_org_virtuslab_bazelsteward_github-github"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GithubClient getClient(@NotNull Environment env, @NotNull String baseBranch, @NotNull GitClient.GitAuthor gitAuthor2) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Intrinsics.checkNotNullParameter((Object)baseBranch, (String)"baseBranch");
            Intrinsics.checkNotNullParameter((Object)gitAuthor2, (String)"gitAuthor");
            String url = env.getOrThrow("GITHUB_API_URL");
            String repository = env.getOrThrow("GITHUB_REPOSITORY");
            String token = env.getOrThrow("GITHUB_TOKEN");
            String it = env.get("PERSONAL_TOKEN");
            boolean bl = false;
            CharSequence charSequence = it;
            String personalToken = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : it;
            return new GithubClient(url, baseBranch, gitAuthor2, repository, token, personalToken, null);
        }

        @NotNull
        public final Path getRepoPath(@NotNull Environment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            String workspace = env.getOrThrow("GITHUB_WORKSPACE");
            Path path = Paths.get(workspace, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(path)");
            return path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

