/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.bazelsteward.bazel.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.virtuslab.bazelsteward.bazel.rules.GithubRulesResolver;
import org.virtuslab.bazelsteward.bazel.rules.GithubRulesResolverKt;
import org.virtuslab.bazelsteward.bazel.rules.LevenshteinKt;
import org.virtuslab.bazelsteward.bazel.rules.RuleLibraryId;
import org.virtuslab.bazelsteward.bazel.rules.RuleVersion;
import org.virtuslab.bazelsteward.bazel.rules.RulesResolver;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/virtuslab/bazelsteward/bazel/rules/GithubRulesResolver;", "Lorg/virtuslab/bazelsteward/bazel/rules/RulesResolver;", "gitHubClient", "Lorg/kohsuke/github/GitHub;", "(Lorg/kohsuke/github/GitHub;)V", "resolveRuleVersions", "", "Lorg/virtuslab/bazelsteward/bazel/rules/RuleVersion;", "ruleId", "Lorg/virtuslab/bazelsteward/bazel/rules/RuleLibraryId;", "resolveUrl", "", "release", "Lorg/kohsuke/github/GHRelease;", "toVersion", "Companion", "kinds_bazel_rules_src_main_kotlin_org_virtuslab_bazelsteward_bazel_rules-rules"})
public final class GithubRulesResolver
implements RulesResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitHub gitHubClient;
    @NotNull
    private static final Regex sha256Regex = new Regex("\\b[A-Fa-f0-9]{64}\\b");
    @NotNull
    private static final Regex urlRegex = new Regex("(?<=\")(https://github\\.com/.*?)(?=\")");

    public GithubRulesResolver(@NotNull GitHub gitHubClient) {
        Intrinsics.checkNotNullParameter((Object)gitHubClient, (String)"gitHubClient");
        this.gitHubClient = gitHubClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<RuleVersion> resolveRuleVersions(@NotNull RuleLibraryId ruleId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
        String repositoryId = ruleId.getRepoName() + "/" + ruleId.getRuleName();
        GHRepository repository = this.gitHubClient.getRepository(repositoryId);
        PagedIterable releases = repository.listReleases();
        Intrinsics.checkNotNullExpressionValue((Object)releases, (String)"releases");
        Iterable $this$map$iv = (Iterable)releases;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GHRelease gHRelease = (GHRelease)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(this.toVersion(ruleId, (GHRelease)it));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final RuleVersion toVersion(RuleLibraryId ruleId, GHRelease release) {
        String string = release.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"release.body");
        String sha2 = (String)SequencesKt.singleOrNull((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)sha256Regex, (CharSequence)string, (int)0, (int)2, null), (Function1)toVersion.sha.1.INSTANCE));
        String downloadUrl = this.resolveUrl(ruleId, release);
        String string2 = release.getTagName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"release.tagName");
        return RuleVersion.Companion.create(downloadUrl, sha2, string2, release.getPublished_at().toInstant());
    }

    /*
     * WARNING - void declaration
     */
    private final String resolveUrl(RuleLibraryId ruleId, GHRelease release) {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        String string = ruleId.getArtifactName();
        String string2 = ruleId.getTag();
        String string3 = release.getTagName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"release.tagName");
        String newArtifactName = StringsKt.replace$default((String)string, (String)string2, (String)string3, (boolean)false, (int)4, null);
        String string4 = release.getTagName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"release.tagName");
        String defaultUrl = GithubRulesResolver.Companion.copy(ruleId, string4, newArtifactName).getDownloadUrl();
        if (GithubRulesResolverKt.access$testUrl(defaultUrl)) {
            return defaultUrl;
        }
        List list = release.assets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"release.assets()");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GHAsset gHAsset = (GHAsset)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getBrowserDownloadUrl());
        }
        Sequence urlsFromAssets = CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
        String string5 = release.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"release.body");
        Sequence urlsFromBody2 = SequencesKt.filter((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)urlRegex, (CharSequence)string5, (int)0, (int)2, null), (Function1)resolveUrl.urlsFromBody.1.INSTANCE), (Function1)((Function1)new Function1<String, Boolean>((Sequence<String>)urlsFromAssets){
            final /* synthetic */ Sequence<String> $urlsFromAssets;
            {
                this.$urlsFromAssets = $urlsFromAssets;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return SequencesKt.contains(this.$urlsFromAssets, (Object)it);
            }
        })), (Function1)resolveUrl.urlsFromBody.3.INSTANCE);
        Sequence urlCandidates = SequencesKt.plus((Sequence)urlsFromAssets, (Sequence)urlsFromBody2);
        destination$iv$iv = SequencesKt.mapNotNull((Sequence)urlCandidates, (Function1)((Function1)new Function1<String, RuleLibraryId>(this){
            final /* synthetic */ GithubRulesResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final RuleLibraryId invoke(String it) {
                Object object;
                Object object2 = this.this$0;
                try {
                    GithubRulesResolver $this$invoke_u24lambda_u240 = object2;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    object = Result.constructor-impl((Object)RuleLibraryId.Companion.from(it));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                return (RuleLibraryId)(Result.isFailure-impl((Object)object2) ? null : object2);
            }
        }));
        boolean $i$f$sortedBy = false;
        Object object = (RuleLibraryId)SequencesKt.firstOrNull((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(ruleId){
            final /* synthetic */ RuleLibraryId $ruleId$inlined;
            {
                this.$ruleId$inlined = ruleLibraryId;
            }

            public final int compare(T a, T b) {
                RuleLibraryId it = (RuleLibraryId)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(LevenshteinKt.levenshtein(it.getArtifactName(), this.$ruleId$inlined.getArtifactName()));
                it = (RuleLibraryId)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(LevenshteinKt.levenshtein(it.getArtifactName(), this.$ruleId$inlined.getArtifactName())));
            }
        }));
        if (object == null || (object = ((RuleLibraryId)object).getDownloadUrl()) == null) {
            object = defaultUrl;
        }
        return object;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/virtuslab/bazelsteward/bazel/rules/GithubRulesResolver$Companion;", "", "()V", "sha256Regex", "Lkotlin/text/Regex;", "urlRegex", "copy", "Lorg/virtuslab/bazelsteward/bazel/rules/RuleLibraryId;", "tag", "", "artifactName", "kinds_bazel_rules_src_main_kotlin_org_virtuslab_bazelsteward_bazel_rules-rules"})
    public static final class Companion {
        private Companion() {
        }

        private final RuleLibraryId copy(RuleLibraryId $this$copy, String tag, String artifactName) {
            RuleLibraryId ruleLibraryId;
            RuleLibraryId ruleLibraryId2 = $this$copy;
            if (ruleLibraryId2 instanceof RuleLibraryId.ReleaseArtifact) {
                ruleLibraryId = RuleLibraryId.ReleaseArtifact.copy$default((RuleLibraryId.ReleaseArtifact)$this$copy, tag, artifactName, null, null, 12, null);
            } else if (ruleLibraryId2 instanceof RuleLibraryId.ArchiveTagRuleId) {
                ruleLibraryId = RuleLibraryId.ArchiveTagRuleId.copy$default((RuleLibraryId.ArchiveTagRuleId)$this$copy, tag, artifactName, null, null, 12, null);
            } else if (ruleLibraryId2 instanceof RuleLibraryId.ArchiveRuleId) {
                ruleLibraryId = RuleLibraryId.ArchiveRuleId.copy$default((RuleLibraryId.ArchiveRuleId)$this$copy, tag, artifactName, null, null, 12, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return ruleLibraryId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

