/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.bazelsteward.bazel.rules;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u00a8\u0006\u0005"}, d2={"levenshtein", "", "lhs", "", "rhs", "kinds_bazel_rules_src_main_kotlin_org_virtuslab_bazelsteward_bazel_rules-rules"})
public final class LevenshteinKt {
    public static final int levenshtein(@NotNull CharSequence lhs, @NotNull CharSequence rhs) {
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        if (Intrinsics.areEqual((Object)lhs, (Object)rhs)) {
            return 0;
        }
        if (lhs.length() == 0) {
            return rhs.length();
        }
        if (rhs.length() == 0) {
            return lhs.length();
        }
        int lhsLength = lhs.length() + 1;
        int rhsLength = rhs.length() + 1;
        int n = 0;
        Integer[] integerArray = new Integer[lhsLength];
        while (n < lhsLength) {
            int n2 = n++;
            integerArray[n2] = n2;
        }
        Integer[] cost = integerArray;
        int n3 = 0;
        Integer[] integerArray2 = new Integer[lhsLength];
        while (n3 < lhsLength) {
            int n4 = n3++;
            integerArray2[n4] = 0;
        }
        Integer[] newCost = integerArray2;
        for (int i = 1; i < rhsLength; ++i) {
            newCost[0] = i;
            for (int j = 1; j < lhsLength; ++j) {
                int match = lhs.charAt(j - 1) == rhs.charAt(i - 1) ? 0 : 1;
                int costReplace = cost[j - 1] + match;
                int costInsert = cost[j] + 1;
                int costDelete = newCost[j - 1] + 1;
                newCost[j] = Math.min(Math.min(costInsert, costDelete), costReplace);
            }
            Integer[] swap = cost;
            cost = newCost;
            newCost = swap;
        }
        return cost[lhsLength - 1];
    }
}

