/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.bazelsteward.config.repo;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.virtuslab.bazelsteward.config.repo.BumpingStrategyDeserializer;
import org.virtuslab.bazelsteward.config.repo.DependencyNameFilter;
import org.virtuslab.bazelsteward.config.repo.DependencyNameFilterDeserializer;
import org.virtuslab.bazelsteward.config.repo.HookRunForDeserializer;
import org.virtuslab.bazelsteward.config.repo.PathPatternDeserializer;
import org.virtuslab.bazelsteward.config.repo.PinningStrategyDeserializer;
import org.virtuslab.bazelsteward.config.repo.RepoConfig;
import org.virtuslab.bazelsteward.config.repo.RepoConfigParser;
import org.virtuslab.bazelsteward.config.repo.RepoConfigParserKt;
import org.virtuslab.bazelsteward.config.repo.VersioningSchemaDeserializer;
import org.virtuslab.bazelsteward.core.PathPattern;
import org.virtuslab.bazelsteward.core.common.HookRunFor;
import org.virtuslab.bazelsteward.core.common.PinningStrategy;
import org.virtuslab.bazelsteward.core.library.BumpingStrategy;
import org.virtuslab.bazelsteward.core.library.VersioningSchema;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0019\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0004H\u0002J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lorg/virtuslab/bazelsteward/config/repo/RepoConfigParser;", "", "()V", "schema", "Lcom/networknt/schema/JsonSchema;", "configureObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "load", "Lorg/virtuslab/bazelsteward/config/repo/RepoConfig;", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadSchema", "parse", "text", "", "removeComments", "repo-config_src_main_kotlin_org_virtuslab_bazelsteward_config_repo-repo"})
public final class RepoConfigParser {
    @NotNull
    private final JsonSchema schema = this.loadSchema();

    @Nullable
    public final Object load(@NotNull Path path, @NotNull Continuation<? super RepoConfig> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super RepoConfig>, Object>(path, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Path $path;
            final /* synthetic */ RepoConfigParser this$0;
            {
                this.$path = $path;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        CoroutineScope $this$withContext;
                        ResultKt.throwOnFailure((Object)object);
                        Object object2 = $this$withContext = (CoroutineScope)this.L$0;
                        Path path = this.$path;
                        RepoConfigParser repoConfigParser = this.this$0;
                        try {
                            boolean bl = false;
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                                return new RepoConfig(null, null, null, null, 15, null);
                            }
                            return repoConfigParser.parse(PathsKt.readText$default((Path)path, null, (int)1, null));
                        }
                        catch (Throwable throwable) {
                            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                            path = this.$path;
                            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object2);
                            if (throwable2 != null) {
                                Throwable it = throwable2;
                                boolean bl = false;
                                RepoConfigParserKt.access$getLogger$p().error((Function0)new Function0<Object>(path){
                                    final /* synthetic */ Path $path;
                                    {
                                        this.$path = $path;
                                        super(0);
                                    }

                                    @Nullable
                                    public final Object invoke() {
                                        return "Could not parse " + this.$path + " file.";
                                    }
                                });
                                throw it;
                            }
                            throw new KotlinNothingValueException();
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super RepoConfig> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public final RepoConfig parse(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = this.removeComments(text);
        if (charSequence.length() == 0) {
            boolean bl = false;
            return new RepoConfig(null, null, null, null, 15, null);
        }
        String configContent = (String)charSequence;
        ObjectMapper yamlMapper = this.configureObjectMapper();
        Set validationResult = this.schema.validate(yamlMapper.readTree(configContent));
        if (validationResult.isEmpty()) {
            Object object = yamlMapper.readValue(configContent, RepoConfig.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"yamlMapper.readValue(con\u2026, RepoConfig::class.java)");
            return (RepoConfig)object;
        }
        Intrinsics.checkNotNullExpressionValue((Object)validationResult, (String)"validationResult");
        Iterable iterable = validationResult;
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
        throw new Exception(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)parse.1.INSTANCE, (int)30, null));
    }

    private final JsonSchema loadSchema() {
        URL uRL = this.getClass().getClassLoader().getResource("repo-config-schema.json");
        if (uRL == null) {
            throw new Exception("Could not find schema to validate configuration file");
        }
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        String schemaText = new String(byArray, charset);
        JsonSchema jsonSchema = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V201909).getSchema(schemaText);
        Intrinsics.checkNotNullExpressionValue((Object)jsonSchema, (String)"getInstance(SpecVersion.\u202609).getSchema(schemaText)");
        return jsonSchema;
    }

    /*
     * WARNING - void declaration
     */
    private final String removeComments(String text) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = StringsKt.lines((CharSequence)text);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (String)"#", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
        return ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string, null, null, (int)0, null, null, (int)62, null))).toString();
    }

    private final ObjectMapper configureObjectMapper() {
        KotlinModule kotlinModule;
        KotlinModule $this$configureObjectMapper_u24lambda_u242 = kotlinModule = new KotlinModule.Builder().build();
        boolean bl = false;
        $this$configureObjectMapper_u24lambda_u242.addDeserializer(VersioningSchema.class, (JsonDeserializer)new VersioningSchemaDeserializer());
        $this$configureObjectMapper_u24lambda_u242.addDeserializer(PinningStrategy.class, (JsonDeserializer)new PinningStrategyDeserializer());
        $this$configureObjectMapper_u24lambda_u242.addDeserializer(BumpingStrategy.class, (JsonDeserializer)new BumpingStrategyDeserializer());
        $this$configureObjectMapper_u24lambda_u242.addDeserializer(DependencyNameFilter.class, (JsonDeserializer)new DependencyNameFilterDeserializer());
        $this$configureObjectMapper_u24lambda_u242.addDeserializer(PathPattern.class, (JsonDeserializer)new PathPatternDeserializer());
        $this$configureObjectMapper_u24lambda_u242.addDeserializer(HookRunFor.class, (JsonDeserializer)new HookRunForDeserializer());
        KotlinModule kotlinModule2 = kotlinModule;
        KotlinModule $this$configureObjectMapper_u24lambda_u243 = kotlinModule = new ObjectMapper((JsonFactory)new YAMLFactory());
        boolean bl2 = false;
        $this$configureObjectMapper_u24lambda_u243.setPropertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE);
        $this$configureObjectMapper_u24lambda_u243.registerModule((Module)kotlinModule2);
        return kotlinModule;
    }
}

