/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.bazelsteward.bazel.rules;

import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.virtuslab.bazelsteward.bazel.rules.GithubRulesResolver;
import org.virtuslab.bazelsteward.bazel.rules.GithubRulesResolverKt;
import org.virtuslab.bazelsteward.bazel.rules.LevenshteinKt;
import org.virtuslab.bazelsteward.bazel.rules.RuleLibraryId;
import org.virtuslab.bazelsteward.bazel.rules.RuleVersion;
import org.virtuslab.bazelsteward.bazel.rules.RulesResolver;
import org.virtuslab.bazelsteward.bazel.rules.Sha256Kt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/virtuslab/bazelsteward/bazel/rules/GithubRulesResolver;", "Lorg/virtuslab/bazelsteward/bazel/rules/RulesResolver;", "gitHubClient", "Lorg/kohsuke/github/GitHub;", "(Lorg/kohsuke/github/GitHub;)V", "candidateByNameReplacement", "Lorg/virtuslab/bazelsteward/bazel/rules/GithubRulesResolver$RuleDetailsCandidate;", "ruleId", "Lorg/virtuslab/bazelsteward/bazel/rules/RuleLibraryId;", "release", "Lorg/kohsuke/github/GHRelease;", "candidatesFromAssetsAndBody", "Lkotlin/sequences/Sequence;", "resolveDetails", "Lorg/virtuslab/bazelsteward/bazel/rules/RuleVersion$Details;", "sha256", "", "resolveRuleVersions", "", "Lorg/virtuslab/bazelsteward/bazel/rules/RuleVersion;", "toVersion", "Companion", "RuleDetailsCandidate", "kinds_bazel_rules_src_main_kotlin_org_virtuslab_bazelsteward_bazel_rules-rules"})
public final class GithubRulesResolver
implements RulesResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitHub gitHubClient;
    @NotNull
    private static final Regex sha256Regex = new Regex("\\b[A-Fa-f0-9]{64}\\b");
    @NotNull
    private static final Regex urlRegex = new Regex("(?<=\")(https://github\\.com/.*?)(?=\")");

    public GithubRulesResolver(@NotNull GitHub gitHubClient) {
        Intrinsics.checkNotNullParameter((Object)gitHubClient, (String)"gitHubClient");
        this.gitHubClient = gitHubClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<RuleVersion> resolveRuleVersions(@NotNull RuleLibraryId ruleId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
        String repositoryId = ruleId.getRepoName() + "/" + ruleId.getRuleName();
        GHRepository repository = this.gitHubClient.getRepository(repositoryId);
        PagedIterable releases = repository.listReleases();
        Intrinsics.checkNotNullExpressionValue((Object)releases, (String)"releases");
        Iterable $this$map$iv = (Iterable)releases;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GHRelease gHRelease = (GHRelease)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(this.toVersion(ruleId, (GHRelease)it));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final RuleVersion toVersion(RuleLibraryId ruleId, GHRelease release) {
        String string = release.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"release.body");
        String sha2 = (String)SequencesKt.singleOrNull((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)sha256Regex, (CharSequence)string, (int)0, (int)2, null), (Function1)toVersion.sha.1.INSTANCE));
        String string2 = release.getTagName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"release.tagName");
        Instant instant = release.getPublished_at().toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"release.published_at.toInstant()");
        return RuleVersion.Companion.create(string2, instant, (Function0<RuleVersion.Details>)((Function0)new Function0<RuleVersion.Details>(this, ruleId, release, sha2){
            final /* synthetic */ GithubRulesResolver this$0;
            final /* synthetic */ RuleLibraryId $ruleId;
            final /* synthetic */ GHRelease $release;
            final /* synthetic */ String $sha;
            {
                this.this$0 = $receiver;
                this.$ruleId = $ruleId;
                this.$release = $release;
                this.$sha = $sha;
                super(0);
            }

            @NotNull
            public final RuleVersion.Details invoke() {
                return GithubRulesResolver.access$resolveDetails(this.this$0, this.$ruleId, this.$release, this.$sha);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final RuleVersion.Details resolveDetails(RuleLibraryId ruleId, GHRelease release, String sha2562) {
        void $this$sortedBy$iv;
        RuleDetailsCandidate defaultCandidate = this.candidateByNameReplacement(ruleId, release);
        if (defaultCandidate.isUrlAccessible() && (sha2562 == null || Intrinsics.areEqual((Object)sha2562, (Object)defaultCandidate.getSha256()))) {
            return defaultCandidate.toDetails();
        }
        Sequence<RuleDetailsCandidate> sequence = this.candidatesFromAssetsAndBody(release);
        boolean $i$f$sortedBy = false;
        Sequence otherCandidates = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(ruleId){
            final /* synthetic */ RuleLibraryId $ruleId$inlined;
            {
                this.$ruleId$inlined = ruleLibraryId;
            }

            public final int compare(T a, T b) {
                RuleDetailsCandidate it = (RuleDetailsCandidate)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(LevenshteinKt.levenshtein(it.getArtifactName(), this.$ruleId$inlined.getArtifactName()));
                it = (RuleDetailsCandidate)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(LevenshteinKt.levenshtein(it.getArtifactName(), this.$ruleId$inlined.getArtifactName())));
            }
        });
        RuleDetailsCandidate secondaryCandidate2 = (RuleDetailsCandidate)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)otherCandidates, (Function1)resolveDetails.secondaryCandidate.1.INSTANCE), (Function1)((Function1)new Function1<RuleDetailsCandidate, Boolean>(sha2562){
            final /* synthetic */ String $sha256;
            {
                this.$sha256 = $sha256;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull RuleDetailsCandidate it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$sha256 == null || Intrinsics.areEqual((Object)this.$sha256, (Object)it.getSha256());
            }
        })));
        if (secondaryCandidate2 != null) {
            return secondaryCandidate2.toDetails();
        }
        if (sha2562 != null) {
            Object v0;
            block5: {
                List allCandidates = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)defaultCandidate), (Sequence)otherCandidates);
                Iterable iterable = allCandidates;
                for (Object t : iterable) {
                    RuleDetailsCandidate it = (RuleDetailsCandidate)t;
                    boolean bl = false;
                    if (!it.isUrlAccessible()) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            RuleDetailsCandidate candidate = v0;
            if (candidate != null) {
                GithubRulesResolverKt.access$getLogger$p().warn((Function0)resolveDetails.1.INSTANCE);
                return RuleVersion.Details.copy$default(candidate.toDetails(), sha2562, null, 2, null);
            }
            GithubRulesResolverKt.access$getLogger$p().warn((Function0)new Function0<Object>(ruleId, release){
                final /* synthetic */ RuleLibraryId $ruleId;
                final /* synthetic */ GHRelease $release;
                {
                    this.$ruleId = $ruleId;
                    this.$release = $release;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Could not resolve any working URL for updating " + this.$ruleId.getDownloadUrl() + " to " + this.$release.getTagName() + ". The URL may be invalid.";
                }
            });
            return defaultCandidate.toDetails();
        }
        GithubRulesResolverKt.access$getLogger$p().warn((Function0)new Function0<Object>(ruleId, release){
            final /* synthetic */ RuleLibraryId $ruleId;
            final /* synthetic */ GHRelease $release;
            {
                this.$ruleId = $ruleId;
                this.$release = $release;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Could not resolve any working URL for updating " + this.$ruleId.getDownloadUrl() + " to " + this.$release.getTagName() + ". The URL may be invalid.";
            }
        });
        return defaultCandidate.toDetails();
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<RuleDetailsCandidate> candidatesFromAssetsAndBody(GHRelease release) {
        void $this$mapTo$iv$iv;
        List list = release.assets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"release.assets()");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GHAsset gHAsset = (GHAsset)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getBrowserDownloadUrl());
        }
        Sequence urlsFromAssets = CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
        String string = release.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"release.body");
        Sequence urlsFromBody2 = SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)urlRegex, (CharSequence)string, (int)0, (int)2, null), (Function1)candidatesFromAssetsAndBody.urlsFromBody.1.INSTANCE), (Function1)((Function1)new Function1<String, Boolean>((Sequence<String>)urlsFromAssets){
            final /* synthetic */ Sequence<String> $urlsFromAssets;
            {
                this.$urlsFromAssets = $urlsFromAssets;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return SequencesKt.contains(this.$urlsFromAssets, (Object)it);
            }
        }));
        Sequence urlCandidates = SequencesKt.plus((Sequence)urlsFromAssets, (Sequence)urlsFromBody2);
        return SequencesKt.mapNotNull((Sequence)urlCandidates, (Function1)((Function1)new Function1<String, RuleDetailsCandidate>(this){
            final /* synthetic */ GithubRulesResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final RuleDetailsCandidate invoke(String it) {
                Object object;
                Object object2 = this.this$0;
                try {
                    GithubRulesResolver $this$invoke_u24lambda_u240 = object2;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    object = Result.constructor-impl((Object)new RuleDetailsCandidate(RuleLibraryId.Companion.from(it)));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                return (RuleDetailsCandidate)(Result.isFailure-impl((Object)object2) ? null : object2);
            }
        }));
    }

    private final RuleDetailsCandidate candidateByNameReplacement(RuleLibraryId ruleId, GHRelease release) {
        String string = ruleId.getArtifactName();
        String string2 = ruleId.getTag();
        String string3 = release.getTagName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"release.tagName");
        String newArtifactName = StringsKt.replace$default((String)string, (String)string2, (String)string3, (boolean)false, (int)4, null);
        String string4 = release.getTagName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"release.tagName");
        return new RuleDetailsCandidate(GithubRulesResolver.Companion.copy(ruleId, string4, newArtifactName));
    }

    public static final /* synthetic */ RuleVersion.Details access$resolveDetails(GithubRulesResolver $this, RuleLibraryId ruleId, GHRelease release, String sha2562) {
        return $this.resolveDetails(ruleId, release, sha2562);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\t\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/virtuslab/bazelsteward/bazel/rules/GithubRulesResolver$RuleDetailsCandidate;", "", "ruleId", "Lorg/virtuslab/bazelsteward/bazel/rules/RuleLibraryId;", "(Lorg/virtuslab/bazelsteward/bazel/rules/RuleLibraryId;)V", "artifactName", "", "getArtifactName", "()Ljava/lang/String;", "isUrlAccessible", "", "()Z", "isUrlAccessible$delegate", "Lkotlin/Lazy;", "sha256", "getSha256", "sha256$delegate", "url", "getUrl", "toDetails", "Lorg/virtuslab/bazelsteward/bazel/rules/RuleVersion$Details;", "kinds_bazel_rules_src_main_kotlin_org_virtuslab_bazelsteward_bazel_rules-rules"})
    private static final class RuleDetailsCandidate {
        @NotNull
        private final String artifactName;
        @NotNull
        private final String url;
        @NotNull
        private final Lazy isUrlAccessible$delegate;
        @NotNull
        private final Lazy sha256$delegate;

        public RuleDetailsCandidate(@NotNull RuleLibraryId ruleId) {
            Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
            this.artifactName = ruleId.getArtifactName();
            this.url = ruleId.getDownloadUrl();
            this.isUrlAccessible$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
                final /* synthetic */ RuleDetailsCandidate this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    return GithubRulesResolverKt.access$testUrl(this.this$0.getUrl());
                }
            }));
            this.sha256$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ RuleDetailsCandidate this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return Sha256Kt.computeSha256(new URL(this.this$0.getUrl()));
                }
            }));
        }

        @NotNull
        public final String getArtifactName() {
            return this.artifactName;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public final boolean isUrlAccessible() {
            Lazy lazy = this.isUrlAccessible$delegate;
            return (Boolean)lazy.getValue();
        }

        @NotNull
        public final String getSha256() {
            Lazy lazy = this.sha256$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final RuleVersion.Details toDetails() {
            return new RuleVersion.Details(this.getSha256(), this.url);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/virtuslab/bazelsteward/bazel/rules/GithubRulesResolver$Companion;", "", "()V", "sha256Regex", "Lkotlin/text/Regex;", "urlRegex", "copy", "Lorg/virtuslab/bazelsteward/bazel/rules/RuleLibraryId;", "tag", "", "artifactName", "kinds_bazel_rules_src_main_kotlin_org_virtuslab_bazelsteward_bazel_rules-rules"})
    public static final class Companion {
        private Companion() {
        }

        private final RuleLibraryId copy(RuleLibraryId $this$copy, String tag, String artifactName) {
            RuleLibraryId ruleLibraryId;
            RuleLibraryId ruleLibraryId2 = $this$copy;
            if (ruleLibraryId2 instanceof RuleLibraryId.ReleaseArtifact) {
                ruleLibraryId = RuleLibraryId.ReleaseArtifact.copy$default((RuleLibraryId.ReleaseArtifact)$this$copy, tag, artifactName, null, null, 12, null);
            } else if (ruleLibraryId2 instanceof RuleLibraryId.ArchiveTagRuleId) {
                ruleLibraryId = RuleLibraryId.ArchiveTagRuleId.copy$default((RuleLibraryId.ArchiveTagRuleId)$this$copy, tag, artifactName, null, null, 12, null);
            } else if (ruleLibraryId2 instanceof RuleLibraryId.ArchiveRuleId) {
                ruleLibraryId = RuleLibraryId.ArchiveRuleId.copy$default((RuleLibraryId.ArchiveRuleId)$this$copy, tag, artifactName, null, null, 12, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return ruleLibraryId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

