/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.bazelsteward.app;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.text.StringSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.virtuslab.bazelsteward.app.BazelStewardGitBranch;
import org.virtuslab.bazelsteward.app.PullRequestSuggestion;
import org.virtuslab.bazelsteward.app.provider.PullRequestConfig;
import org.virtuslab.bazelsteward.app.provider.PullRequestConfigProvider;
import org.virtuslab.bazelsteward.core.GitBranch;
import org.virtuslab.bazelsteward.core.NewPullRequest;
import org.virtuslab.bazelsteward.core.common.CommitRequest;
import org.virtuslab.bazelsteward.core.library.LibraryId;
import org.virtuslab.bazelsteward.core.library.Version;
import org.virtuslab.bazelsteward.core.replacement.LibraryUpdate;
import org.virtuslab.bazelsteward.maven.MavenLibraryId;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/virtuslab/bazelsteward/app/PullRequestSuggester;", "", "provider", "Lorg/virtuslab/bazelsteward/app/provider/PullRequestConfigProvider;", "(Lorg/virtuslab/bazelsteward/app/provider/PullRequestConfigProvider;)V", "suggestPullRequests", "", "Lorg/virtuslab/bazelsteward/app/PullRequestSuggestion;", "updates", "Lorg/virtuslab/bazelsteward/core/replacement/LibraryUpdate;", "app_src_main-main"})
public final class PullRequestSuggester {
    @NotNull
    private final PullRequestConfigProvider provider;

    public PullRequestSuggester(@NotNull PullRequestConfigProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.provider = provider;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PullRequestSuggestion> suggestPullRequests(@NotNull List<LibraryUpdate> updates2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(updates2, (String)"updates");
        Iterable $this$map$iv = updates2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            StringSubstitutor stringSubstitutor;
            void update;
            LibraryUpdate libraryUpdate = (LibraryUpdate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Version versionFrom = update.getSuggestion().getCurrentLibrary().getVersion();
            Version versionTo = update.getSuggestion().getSuggestedVersion();
            LibraryId libraryId = update.getSuggestion().getCurrentLibrary().getId();
            BazelStewardGitBranch branch = new BazelStewardGitBranch(libraryId, versionTo);
            PullRequestConfig config = this.provider.resolveForLibrary(update.getSuggestion().getCurrentLibrary());
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"versionFrom", (Object)versionFrom.getValue()), TuplesKt.to((Object)"versionTo", (Object)versionTo.getValue()), TuplesKt.to((Object)"dependencyId", (Object)libraryId.getName())};
            Map params = MapsKt.mutableMapOf((Pair[])pairArray);
            if (libraryId instanceof MavenLibraryId) {
                params.put("group", ((MavenLibraryId)libraryId).getGroup());
                params.put("artifact", ((MavenLibraryId)libraryId).getArtifact());
            }
            StringSubstitutor it = stringSubstitutor = new StringSubstitutor(params);
            boolean bl2 = false;
            it.setEnableUndefinedVariableException(false);
            StringSubstitutor substitutor = stringSubstitutor;
            String title2 = substitutor.replace(config.getTitleTemplate());
            String body2 = substitutor.replace(config.getBodyTemplate());
            Intrinsics.checkNotNullExpressionValue((Object)title2, (String)"title");
            List commits = CollectionsKt.listOf((Object)new CommitRequest(title2, update.getFileChanges()));
            GitBranch gitBranch = branch.getGitBranch();
            Intrinsics.checkNotNullExpressionValue((Object)body2, (String)"body");
            collection.add(new PullRequestSuggestion(new NewPullRequest(gitBranch, title2, body2, config.getLabels()), branch.getPrefix(), commits, update.getSuggestion().getCurrentLibrary()));
        }
        return (List)destination$iv$iv;
    }
}

