/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.bazelsteward.core.common;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.virtuslab.bazelsteward.core.common.UpdateRules;
import org.virtuslab.bazelsteward.core.common.UpdateSuggestion;
import org.virtuslab.bazelsteward.core.library.BumpingStrategy;
import org.virtuslab.bazelsteward.core.library.Library;
import org.virtuslab.bazelsteward.core.library.SemanticVersion;
import org.virtuslab.bazelsteward.core.library.Version;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/virtuslab/bazelsteward/core/common/UpdateLogic;", "", "()V", "selectUpdate", "Lorg/virtuslab/bazelsteward/core/common/UpdateSuggestion;", "library", "Lorg/virtuslab/bazelsteward/core/library/Library;", "availableVersions", "", "Lorg/virtuslab/bazelsteward/core/library/Version;", "updateRules", "Lorg/virtuslab/bazelsteward/core/common/UpdateRules;", "core_src_main_kotlin_org_virtuslab_bazelsteward_core-core"})
@SourceDebugExtension(value={"SMAP\nUpdateLogic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateLogic.kt\norg/virtuslab/bazelsteward/core/common/UpdateLogic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n766#2:84\n857#2,2:85\n1603#2,9:87\n1855#2:96\n1856#2:99\n1612#2:100\n766#2:101\n857#2,2:102\n766#2:104\n857#2,2:105\n1963#2,14:107\n1549#2:121\n1620#2,3:122\n766#2:125\n857#2,2:126\n1963#2,14:128\n1#3:97\n1#3:98\n*S KotlinDebug\n*F\n+ 1 UpdateLogic.kt\norg/virtuslab/bazelsteward/core/common/UpdateLogic\n*L\n27#1:84\n27#1:85,2\n28#1:87,9\n28#1:96\n28#1:99\n28#1:100\n29#1:101\n29#1:102,2\n33#1:104\n33#1:105,2\n34#1:107,14\n56#1:121\n56#1:122,3\n57#1:125\n57#1:126,2\n58#1:128,14\n28#1:98\n*E\n"})
public final class UpdateLogic {
    @Nullable
    public final UpdateSuggestion selectUpdate(@NotNull Library library, @NotNull List<? extends Version> availableVersions2, @NotNull UpdateRules updateRules) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter(availableVersions2, (String)"availableVersions");
        Intrinsics.checkNotNullParameter((Object)updateRules, (String)"updateRules");
        if (!updateRules.getEnabled()) {
            return null;
        }
        return updateRules.getBumpingStrategy() == BumpingStrategy.LatestByDate ? UpdateLogic.selectUpdate$selectByDate(library, updateRules, availableVersions2) : UpdateLogic.selectUpdate$selectDefault(library, updateRules, availableVersions2);
    }

    private static final List<Pair<Version, SemanticVersion>> selectUpdate$checkPreRelease(List<? extends Version> $availableVersions, UpdateRules $updateRules) {
        Iterable $this$mapNotNullTo$iv$iv;
        Object version;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $availableVersions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            version = (Version)element$iv$iv;
            boolean bl = false;
            if (!$updateRules.getPinningStrategy().test((Version)version)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        version = $this$forEach$iv$iv$iv.iterator();
        while (version.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = version.next();
            boolean bl = false;
            Version version2 = (Version)element$iv$iv;
            boolean bl2 = false;
            if (version2.toSemVer($updateRules.getVersioningSchema()) != null) {
                SemanticVersion it;
                boolean bl3 = false;
                pair = TuplesKt.to((Object)version2, (Object)it);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)((SemanticVersion)it.getSecond()).getPrerelease())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Version selectUpdate$maxAvailableVersion(List<? extends Version> $availableVersions, UpdateRules $updateRules, Function1<? super SemanticVersion, Boolean> filterVersionComponent) {
        Object v0;
        void $this$maxByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = UpdateLogic.selectUpdate$checkPreRelease($availableVersions, $updateRules);
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)filterVersionComponent.invoke(it.getSecond())).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Pair it = (Pair)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = (SemanticVersion)it.getSecond();
                do {
                    Object e$iv = iterator$iv.next();
                    Pair it2 = (Pair)e$iv;
                    $i$a$-maxByOrNull-UpdateLogic$selectUpdate$maxAvailableVersion$2 = false;
                    Comparable v$iv = (SemanticVersion)it2.getSecond();
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Pair pair = v0;
        return pair != null ? (Version)pair.getFirst() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final UpdateSuggestion selectUpdate$selectDefault(Library $library, UpdateRules $updateRules, List<? extends Version> $availableVersions) {
        Version nextVersion;
        Version version;
        SemanticVersion semanticVersion;
        SemanticVersion semanticVersion2 = $library.getVersion().toSemVer($updateRules.getVersioningSchema());
        if (semanticVersion2 == null) return null;
        SemanticVersion version2 = semanticVersion = semanticVersion2;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)version2.getPrerelease())) return null;
        SemanticVersion semanticVersion3 = semanticVersion;
        SemanticVersion semanticVersion4 = semanticVersion3;
        if (semanticVersion4 == null) return null;
        version2 = semanticVersion4;
        boolean bl2 = false;
        Version maxPatch2 = UpdateLogic.selectUpdate$maxAvailableVersion($availableVersions, $updateRules, (Function1<? super SemanticVersion, Boolean>)((Function1)new Function1<SemanticVersion, Boolean>(version2){
            final /* synthetic */ SemanticVersion $version;
            {
                this.$version = $version;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SemanticVersion a) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                return a.getMajor() == this.$version.getMajor() && a.getMinor() == this.$version.getMinor() && a.getPatch() > this.$version.getPatch();
            }
        }));
        Version maxMinor2 = UpdateLogic.selectUpdate$maxAvailableVersion($availableVersions, $updateRules, (Function1<? super SemanticVersion, Boolean>)((Function1)new Function1<SemanticVersion, Boolean>(version2){
            final /* synthetic */ SemanticVersion $version;
            {
                this.$version = $version;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SemanticVersion a) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                return a.getMajor() == this.$version.getMajor() && a.getMinor() > this.$version.getMinor();
            }
        }));
        Version maxMajor2 = UpdateLogic.selectUpdate$maxAvailableVersion($availableVersions, $updateRules, (Function1<? super SemanticVersion, Boolean>)((Function1)new Function1<SemanticVersion, Boolean>(version2){
            final /* synthetic */ SemanticVersion $version;
            {
                this.$version = $version;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SemanticVersion a) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                return a.getMajor() > this.$version.getMajor();
            }
        }));
        switch (WhenMappings.$EnumSwitchMapping$0[$updateRules.getBumpingStrategy().ordinal()]) {
            case 1: {
                version = maxPatch2;
                if (version != null || (version = maxMinor2) != null) break;
                version = maxMajor2;
                break;
            }
            case 2: {
                version = maxMajor2;
                if (version != null || (version = maxMinor2) != null) break;
                version = maxPatch2;
                break;
            }
            case 3: {
                version = maxMinor2;
                if (version != null || (version = maxPatch2) != null) break;
                version = maxMajor2;
                break;
            }
            default: {
                return null;
            }
        }
        Version version3 = nextVersion = version;
        if (version3 == null) return null;
        Version it = version3;
        boolean bl3 = false;
        UpdateSuggestion updateSuggestion = new UpdateSuggestion($library, it);
        return updateSuggestion;
    }

    /*
     * WARNING - void declaration
     */
    private static final Version selectUpdate$maxAvailableVersionByDate(List<? extends Version> $availableVersions, UpdateRules $updateRules) {
        Object v0;
        void $this$filterTo$iv$iv;
        Version it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = UpdateLogic.selectUpdate$checkPreRelease($availableVersions, $updateRules);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Version)it.getFirst());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Version)element$iv$iv;
            boolean bl = false;
            if (!(it.getDate() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Version it2 = (Version)maxElem$iv;
                boolean bl = false;
                Instant instant = it2.getDate();
                Intrinsics.checkNotNull((Object)instant);
                Comparable maxValue$iv = instant;
                do {
                    Object e$iv = iterator$iv.next();
                    Version it3 = (Version)e$iv;
                    $i$a$-maxByOrNull-UpdateLogic$selectUpdate$maxAvailableVersionByDate$3 = false;
                    Instant instant2 = it3.getDate();
                    Intrinsics.checkNotNull((Object)instant2);
                    Comparable v$iv = instant2;
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final UpdateSuggestion selectUpdate$selectByDate(Library $library, UpdateRules $updateRules, List<? extends Version> $availableVersions) {
        SemanticVersion semanticVersion;
        SemanticVersion semanticVersion2 = $library.getVersion().toSemVer($updateRules.getVersioningSchema());
        if (semanticVersion2 == null) return null;
        SemanticVersion version = semanticVersion = semanticVersion2;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)version.getPrerelease())) return null;
        SemanticVersion semanticVersion3 = semanticVersion;
        SemanticVersion semanticVersion4 = semanticVersion3;
        if (semanticVersion4 == null) return null;
        SemanticVersion it = semanticVersion4;
        boolean bl2 = false;
        Version version2 = UpdateLogic.selectUpdate$maxAvailableVersionByDate($availableVersions, $updateRules);
        if (version2 == null) return null;
        Version it2 = version2;
        boolean bl3 = false;
        if (Intrinsics.areEqual((Object)it2.getValue(), (Object)$library.getVersion().getValue())) return null;
        UpdateSuggestion updateSuggestion = new UpdateSuggestion($library, it2);
        return updateSuggestion;
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BumpingStrategy.values().length];
            try {
                nArray[BumpingStrategy.Patch.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BumpingStrategy.Latest.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BumpingStrategy.Minor.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

