/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.bazelsteward.core.replacement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.virtuslab.bazelsteward.core.common.FileChange;
import org.virtuslab.bazelsteward.core.common.TextFile;
import org.virtuslab.bazelsteward.core.common.UpdateSuggestion;
import org.virtuslab.bazelsteward.core.replacement.LibraryUpdate;
import org.virtuslab.bazelsteward.core.replacement.MatchedText;
import org.virtuslab.bazelsteward.core.replacement.VersionReplacementHeuristic;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/virtuslab/bazelsteward/core/replacement/WholeLibraryHeuristic;", "Lorg/virtuslab/bazelsteward/core/replacement/VersionReplacementHeuristic;", "()V", "name", "", "getName", "()Ljava/lang/String;", "apply", "Lorg/virtuslab/bazelsteward/core/replacement/LibraryUpdate;", "files", "", "Lorg/virtuslab/bazelsteward/core/common/TextFile;", "updateSuggestion", "Lorg/virtuslab/bazelsteward/core/common/UpdateSuggestion;", "core_src_main_kotlin_org_virtuslab_bazelsteward_core-core"})
@SourceDebugExtension(value={"SMAP\nWholeLibraryHeuristic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WholeLibraryHeuristic.kt\norg/virtuslab/bazelsteward/core/replacement/WholeLibraryHeuristic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,39:1\n1549#2:40\n1620#2,2:41\n1549#2:43\n1620#2,3:44\n2661#2,7:47\n1622#2:54\n603#3:55\n*S KotlinDebug\n*F\n+ 1 WholeLibraryHeuristic.kt\norg/virtuslab/bazelsteward/core/replacement/WholeLibraryHeuristic\n*L\n13#1:40\n13#1:41,2\n14#1:43\n14#1:44,3\n14#1:47,7\n13#1:54\n20#1:55\n*E\n"})
public final class WholeLibraryHeuristic
implements VersionReplacementHeuristic {
    @NotNull
    public static final WholeLibraryHeuristic INSTANCE = new WholeLibraryHeuristic();
    @NotNull
    private static final String name = "whole-library";

    private WholeLibraryHeuristic() {
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public LibraryUpdate apply(@NotNull List<? extends TextFile> files, @NotNull UpdateSuggestion updateSuggestion) {
        MatchedText matchedText;
        block9: {
            Object $this$reduce$iv;
            Object object;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Intrinsics.checkNotNullParameter((Object)updateSuggestion, (String)"updateSuggestion");
            List<List<String>> markers = updateSuggestion.getCurrentLibrary().getId().associatedStrings();
            String currentVersion = updateSuggestion.getCurrentLibrary().getVersion().getValue();
            Iterable $this$map$iv = markers;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void marker;
                object = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv2 = CollectionsKt.plus((Collection)((Collection)marker), (Object)currentVersion);
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo22 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    String string = (String)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add("(" + Regex.Companion.escape((String)it) + ")");
                }
                $this$map$iv2 = (List)destination$iv$iv2;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void s;
                    String $i$f$mapTo22 = (String)iterator$iv.next();
                    String acc = (String)accumulator$iv;
                    boolean bl3 = false;
                    accumulator$iv = acc + ".*" + (String)s;
                }
                $this$reduce$iv = (String)accumulator$iv;
                collection.add(new Regex((String)$this$reduce$iv));
            }
            List regexes = (List)destination$iv$iv;
            for (Regex regex : (Iterable)regexes) {
                Object object2;
                Object object3;
                block8: {
                    boolean bl = false;
                    for (TextFile textFile : (Iterable)files) {
                        void $this$sortedBy$iv;
                        boolean bl4 = false;
                        $this$reduce$iv = SequencesKt.map((Sequence)Regex.findAll$default((Regex)regex, (CharSequence)textFile.getContent(), (int)0, (int)2, null), (Function1)((Function1)new Function1<MatchResult, MatchedText>(textFile){
                            final /* synthetic */ TextFile $textFile;
                            {
                                this.$textFile = $textFile;
                                super(1);
                            }

                            @NotNull
                            public final MatchedText invoke(@NotNull MatchResult it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return new MatchedText(it, this.$textFile.getPath(), 0, 4, null);
                            }
                        }));
                        boolean $i$f$sortedBy = false;
                        object = (MatchedText)SequencesKt.firstOrNull((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                MatchedText it = (MatchedText)a;
                                boolean bl = false;
                                Comparable comparable = Integer.valueOf(it.getMatchedText().length());
                                it = (MatchedText)b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getMatchedText().length()));
                            }
                        }));
                        if (object == null) continue;
                        object3 = object;
                        break block8;
                    }
                    object3 = null;
                }
                if ((object2 = object3) == null) continue;
                matchedText = object2;
                break block9;
            }
            matchedText = null;
        }
        if (matchedText == null) {
            return null;
        }
        MatchedText matchResult2 = matchedText;
        Integer n = matchResult2.getOffsetLastMatchGroup();
        if (n == null) {
            return null;
        }
        int versionOffset = n;
        return new LibraryUpdate(updateSuggestion, CollectionsKt.listOf((Object)new FileChange(matchResult2.getOrigin(), versionOffset, updateSuggestion.getCurrentLibrary().getVersion().getValue().length(), updateSuggestion.getSuggestedVersion().getValue())));
    }
}

