/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.bazelsteward.bazel.rules;

import java.io.Closeable;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.virtuslab.bazelsteward.bazel.rules.Sha256Kt;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"logger", "Lmu/KLogger;", "computeSha256", "", "url", "Ljava/net/URL;", "kinds_bazel_rules_src_main_kotlin_org_virtuslab_bazelsteward_bazel_rules-rules"})
public final class Sha256Kt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String computeSha256(@NotNull URL url2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        logger.info((Function0)new Function0<Object>(url2){
            final /* synthetic */ URL $url;
            {
                this.$url = $url;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Computing sha256 for " + this.$url;
            }
        });
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        MessageDigest messageDigest = null;
        Closeable closeable = new DigestInputStream(url2.openStream(), digest);
        Object object = null;
        try {
            DigestInputStream dis = (DigestInputStream)closeable;
            boolean bl = false;
            while (dis.read() != -1) {
            }
            MessageDigest messageDigest2 = dis.getMessageDigest();
            Intrinsics.checkNotNullExpressionValue((Object)messageDigest2, (String)"dis.messageDigest");
            messageDigest = messageDigest2;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        StringBuilder result = new StringBuilder();
        byte[] byArray = messageDigest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"messageDigest.digest()");
        for (Object b : (Object)byArray) {
            String string = "%02x";
            Object[] objectArray = new Object[]{(byte)b};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            result.append(string2);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }
}

