/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.bazelsteward.core.library;

import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchNamedGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.virtuslab.bazelsteward.core.library.Version;
import org.virtuslab.bazelsteward.core.library.VersioningSchema;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ,2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001,B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0011\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0019\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003J;\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010\u0018\u001a\u0004\u0018\u00010!H\u00d6\u0003J\u001a\u0010\"\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\b2\u0006\u0010$\u001a\u00020\bH\u0002J&\u0010%\u001a\u0004\u0018\u00010\b2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040'2\u0006\u0010$\u001a\u00020\bH\u0002J\t\u0010(\u001a\u00020\u0004H\u00d6\u0001J\u0010\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+H\u0016R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0014\u0010\u0012\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\f\u00a8\u0006-"}, d2={"Lorg/virtuslab/bazelsteward/core/library/SemanticVersion;", "Lorg/virtuslab/bazelsteward/core/library/Version;", "", "major", "", "minor", "patch", "prerelease", "", "buildmetadata", "(IIILjava/lang/String;Ljava/lang/String;)V", "getBuildmetadata", "()Ljava/lang/String;", "getMajor", "()I", "getMinor", "getPatch", "getPrerelease", "value", "getValue", "comparePreReleases", "first", "second", "compareTo", "other", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "", "getPreReleaseWithoutQualifier", "qualifier", "preRelease", "getQualifierForPreRelease", "qualifiers", "", "hashCode", "toSemVer", "versioning", "Lorg/virtuslab/bazelsteward/core/library/VersioningSchema;", "Companion", "core_src_main_kotlin_org_virtuslab_bazelsteward_core-core"})
@SourceDebugExtension(value={"SMAP\nSemanticVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemanticVersion.kt\norg/virtuslab/bazelsteward/core/library/SemanticVersion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n288#2,2:123\n*S KotlinDebug\n*F\n+ 1 SemanticVersion.kt\norg/virtuslab/bazelsteward/core/library/SemanticVersion\n*L\n72#1:123,2\n*E\n"})
public final class SemanticVersion
extends Version
implements Comparable<SemanticVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int patch;
    @NotNull
    private final String prerelease;
    @NotNull
    private final String buildmetadata;
    @NotNull
    private final String value;
    @NotNull
    private static final Regex strictSemVerRegex = new Regex("^(?<major>0|[1-9]\\d*)\\.(?<minor>0|[1-9]\\d*)\\.(?<patch>0|[1-9]\\d*)(?:-(?<preRelease>(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+(?<buildMetaData>[0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    @NotNull
    private static final Regex looseSemVerRegex = new Regex("^[vV]?\\.?(?<major>0|[1-9]\\d*)(?:[.-](?<minor>(0|[1-9]\\d*)))?(?:[.-]?(?<patch>(0|[1-9]\\d*)))?(?:[-.]?(?<preRelease>((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*)))?(?:\\+(?<buildMetaData>([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*)))?$");
    @NotNull
    private static final SemanticVersion MIN = new SemanticVersion(-1, 0, 0, "", "");

    /*
     * WARNING - void declaration
     */
    public SemanticVersion(int major, int minor, int patch, @NotNull String prerelease, @NotNull String buildmetadata) {
        void $this$value_u24lambda_u240;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)prerelease, (String)"prerelease");
        Intrinsics.checkNotNullParameter((Object)buildmetadata, (String)"buildmetadata");
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.prerelease = prerelease;
        this.buildmetadata = buildmetadata;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder(this.major + "." + this.minor + "." + this.patch);
        SemanticVersion semanticVersion = this;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)this.prerelease)) {
            $this$value_u24lambda_u240.append("-" + this.prerelease);
        }
        if (!StringsKt.isBlank((CharSequence)this.buildmetadata)) {
            $this$value_u24lambda_u240.append("+" + this.buildmetadata);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(\"$major.$m\u2026\n      }\n    }.toString()");
        semanticVersion.value = string;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @NotNull
    public final String getPrerelease() {
        return this.prerelease;
    }

    @NotNull
    public final String getBuildmetadata() {
        return this.buildmetadata;
    }

    @Override
    @NotNull
    public String getValue() {
        return this.value;
    }

    @Override
    public int compareTo(@NotNull SemanticVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.major != other.major ? Intrinsics.compare((int)this.major, (int)other.major) : (this.minor != other.minor ? Intrinsics.compare((int)this.minor, (int)other.minor) : (this.patch != other.patch ? Intrinsics.compare((int)this.patch, (int)other.patch) : (!Intrinsics.areEqual((Object)this.prerelease, (Object)other.prerelease) ? this.comparePreReleases(this.prerelease, other.prerelease) : 0)));
    }

    private final int comparePreReleases(String first, String second) {
        int n;
        int n2;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"alpha", (Object)1), TuplesKt.to((Object)"beta", (Object)2), TuplesKt.to((Object)"milestone", (Object)3), TuplesKt.to((Object)"rc", (Object)4), TuplesKt.to((Object)"cr", (Object)4), TuplesKt.to((Object)"snapshot", (Object)5), TuplesKt.to((Object)"ga", (Object)6), TuplesKt.to((Object)"final", (Object)6), TuplesKt.to((Object)"release", (Object)6), TuplesKt.to((Object)"sp", (Object)7), TuplesKt.to((Object)"", (Object)6)};
        Map qualifiers = MapsKt.mapOf((Pair[])pairArray);
        String firstQualifier = this.getQualifierForPreRelease(qualifiers, first);
        String otherQualifier = this.getQualifierForPreRelease(qualifiers, second);
        if (qualifiers.get(firstQualifier) == null) {
            n2 = qualifiers.get(otherQualifier) == null ? first.compareTo(second) : -1;
        } else if (qualifiers.get(otherQualifier) == null) {
            n2 = 1;
        } else {
            Object v = qualifiers.get(firstQualifier);
            Intrinsics.checkNotNull(v);
            int n3 = ((Number)v).intValue();
            Object v2 = qualifiers.get(otherQualifier);
            Intrinsics.checkNotNull(v2);
            n2 = Intrinsics.compare((int)n3, (int)((Number)v2).intValue());
        }
        int it = n2;
        boolean bl = false;
        if (it == 0) {
            String firstWithoutQualifier = this.getPreReleaseWithoutQualifier(firstQualifier, first);
            String secondWithoutQualifier = this.getPreReleaseWithoutQualifier(otherQualifier, second);
            n = firstWithoutQualifier.compareTo(secondWithoutQualifier);
        } else {
            n = it;
        }
        return n;
    }

    private final String getQualifierForPreRelease(Map<String, Integer> qualifiers, String preRelease) {
        String string;
        if (StringsKt.startsWith$default((CharSequence)preRelease, (char)'a', (boolean)false, (int)2, null)) {
            string = "alpha";
        } else if (StringsKt.startsWith$default((CharSequence)preRelease, (char)'b', (boolean)false, (int)2, null)) {
            string = "beta";
        } else if (StringsKt.startsWith$default((CharSequence)preRelease, (char)'m', (boolean)false, (int)2, null)) {
            string = "milestone";
        } else {
            Object v1;
            block7: {
                Iterable $this$firstOrNull$iv = qualifiers.keySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.contains$default((CharSequence)preRelease, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    v1 = element$iv;
                    break block7;
                }
                v1 = null;
            }
            string = v1;
        }
        return string;
    }

    private final String getPreReleaseWithoutQualifier(String qualifier, String preRelease) {
        String string;
        block4: {
            block3: {
                string = qualifier;
                if (string == null) break block3;
                String it = string;
                boolean bl = false;
                String string2 = StringsKt.contains$default((CharSequence)preRelease, (CharSequence)it, (boolean)false, (int)2, null) ? StringsKt.replaceFirst$default((String)preRelease, (String)it, (String)"", (boolean)false, (int)4, null) : StringsKt.replaceFirst$default((String)preRelease, (String)String.valueOf(StringsKt.first((CharSequence)it)), (String)"", (boolean)false, (int)4, null);
                string = string2;
                if (string2 != null) break block4;
            }
            string = preRelease;
        }
        return string;
    }

    @Override
    @NotNull
    public SemanticVersion toSemVer(@NotNull VersioningSchema versioning) {
        Intrinsics.checkNotNullParameter((Object)versioning, (String)"versioning");
        return this;
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.patch;
    }

    @NotNull
    public final String component4() {
        return this.prerelease;
    }

    @NotNull
    public final String component5() {
        return this.buildmetadata;
    }

    @NotNull
    public final SemanticVersion copy(int major, int minor, int patch, @NotNull String prerelease, @NotNull String buildmetadata) {
        Intrinsics.checkNotNullParameter((Object)prerelease, (String)"prerelease");
        Intrinsics.checkNotNullParameter((Object)buildmetadata, (String)"buildmetadata");
        return new SemanticVersion(major, minor, patch, prerelease, buildmetadata);
    }

    public static /* synthetic */ SemanticVersion copy$default(SemanticVersion semanticVersion, int n, int n2, int n3, String string, String string2, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = semanticVersion.major;
        }
        if ((n4 & 2) != 0) {
            n2 = semanticVersion.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = semanticVersion.patch;
        }
        if ((n4 & 8) != 0) {
            string = semanticVersion.prerelease;
        }
        if ((n4 & 0x10) != 0) {
            string2 = semanticVersion.buildmetadata;
        }
        return semanticVersion.copy(n, n2, n3, string, string2);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.major);
        result = result * 31 + Integer.hashCode(this.minor);
        result = result * 31 + Integer.hashCode(this.patch);
        result = result * 31 + this.prerelease.hashCode();
        result = result * 31 + this.buildmetadata.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SemanticVersion)) {
            return false;
        }
        SemanticVersion semanticVersion = (SemanticVersion)other;
        if (this.major != semanticVersion.major) {
            return false;
        }
        if (this.minor != semanticVersion.minor) {
            return false;
        }
        if (this.patch != semanticVersion.patch) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.prerelease, (Object)semanticVersion.prerelease)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.buildmetadata, (Object)semanticVersion.buildmetadata);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/virtuslab/bazelsteward/core/library/SemanticVersion$Companion;", "", "()V", "MIN", "Lorg/virtuslab/bazelsteward/core/library/SemanticVersion;", "getMIN", "()Lorg/virtuslab/bazelsteward/core/library/SemanticVersion;", "looseSemVerRegex", "Lkotlin/text/Regex;", "strictSemVerRegex", "fromString", "value", "", "versioningScheme", "Lorg/virtuslab/bazelsteward/core/library/VersioningSchema;", "core_src_main_kotlin_org_virtuslab_bazelsteward_core-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SemanticVersion getMIN() {
            return MIN;
        }

        @Nullable
        public final SemanticVersion fromString(@NotNull String value, @NotNull VersioningSchema versioningScheme) {
            SemanticVersion semanticVersion;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)versioningScheme, (String)"versioningScheme");
            VersioningSchema versioningSchema = versioningScheme;
            if (versioningSchema instanceof VersioningSchema.SemVer) {
                semanticVersion = org.virtuslab.bazelsteward.core.library.SemanticVersion$Companion.fromString$matchToSemanticVersion(value, strictSemVerRegex);
            } else if (versioningSchema instanceof VersioningSchema.Loose) {
                semanticVersion = org.virtuslab.bazelsteward.core.library.SemanticVersion$Companion.fromString$matchToSemanticVersion(value, looseSemVerRegex);
            } else if (versioningSchema instanceof VersioningSchema.Regex) {
                semanticVersion = org.virtuslab.bazelsteward.core.library.SemanticVersion$Companion.fromString$matchToSemanticVersion(value, ((VersioningSchema.Regex)versioningScheme).getRegex());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return semanticVersion;
        }

        public static /* synthetic */ SemanticVersion fromString$default(Companion companion, String string, VersioningSchema versioningSchema, int n, Object object) {
            if ((n & 2) != 0) {
                versioningSchema = VersioningSchema.SemVer.INSTANCE;
            }
            return companion.fromString(string, versioningSchema);
        }

        private static final String fromString$matchToSemanticVersion$lambda$0$extract(MatchNamedGroupCollection values, String name) {
            String string;
            try {
                MatchGroup matchGroup = values.get(name);
                string = matchGroup != null ? matchGroup.getValue() : null;
            }
            catch (IllegalArgumentException e) {
                string = null;
            }
            return string;
        }

        private static final SemanticVersion fromString$matchToSemanticVersion(String $value, Regex regex) {
            SemanticVersion semanticVersion;
            MatchResult matchResult2 = regex.matchEntire((CharSequence)$value);
            if (matchResult2 != null) {
                String string;
                MatchResult matchResult3 = matchResult2;
                boolean bl = false;
                MatchGroupCollection matchGroupCollection = matchResult3.getGroups();
                Intrinsics.checkNotNull((Object)matchGroupCollection, (String)"null cannot be cast to non-null type kotlin.text.MatchNamedGroupCollection");
                MatchNamedGroupCollection values = (MatchNamedGroupCollection)matchGroupCollection;
                Object object = org.virtuslab.bazelsteward.core.library.SemanticVersion$Companion.fromString$matchToSemanticVersion$lambda$0$extract(values, "major");
                int n = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
                Object object2 = org.virtuslab.bazelsteward.core.library.SemanticVersion$Companion.fromString$matchToSemanticVersion$lambda$0$extract(values, "minor");
                int n2 = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 0;
                Object object3 = org.virtuslab.bazelsteward.core.library.SemanticVersion$Companion.fromString$matchToSemanticVersion$lambda$0$extract(values, "patch");
                int n3 = object3 != null && (object3 = StringsKt.toIntOrNull((String)object3)) != null ? (Integer)object3 : 0;
                String string2 = org.virtuslab.bazelsteward.core.library.SemanticVersion$Companion.fromString$matchToSemanticVersion$lambda$0$extract(values, "preRelease");
                if (string2 == null) {
                    string2 = "";
                }
                if ((string = org.virtuslab.bazelsteward.core.library.SemanticVersion$Companion.fromString$matchToSemanticVersion$lambda$0$extract(values, "buildMetaData")) == null) {
                    string = "";
                }
                semanticVersion = new SemanticVersion(n, n2, n3, string2, string);
            } else {
                semanticVersion = null;
            }
            return semanticVersion;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

