package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class Account private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  accountId: Output[String],
  createTime: Output[String],
  isAccountOwner: Output[Boolean],
  name: Output[String],
  ownerTeamId: Output[String],
  primaryBillingGroupId: Output[Option[String]],
  tenantId: Output[String],
  updateTime: Output[String]
) extends CustomResource derives ResourceDecoder

object Account:
  given outputOps: {} with
    extension(output: Output[Account])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def accountId: Output[String] = output.flatMap(_.accountId)
      def createTime: Output[String] = output.flatMap(_.createTime)
      def isAccountOwner: Output[Boolean] = output.flatMap(_.isAccountOwner)
      def name: Output[String] = output.flatMap(_.name)
      def ownerTeamId: Output[String] = output.flatMap(_.ownerTeamId)
      def primaryBillingGroupId: Output[Option[String]] = output.flatMap(_.primaryBillingGroupId)
      def tenantId: Output[String] = output.flatMap(_.tenantId)
      def updateTime: Output[String] = output.flatMap(_.updateTime)

def account(using ctx: Context)(
  name: NonEmptyString,
  args: AccountArgs = AccountArgs(),
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[Account] = 
  ctx.registerResource[Account, AccountArgs]("aiven:index/account:Account", name, args, opts)

