package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AccountArgs private(
  name: Output[Option[String]],
  primaryBillingGroupId: Output[Option[String]]
) derives ArgsEncoder

object AccountArgs:
  def apply(
    name: Input.Optional[String] = None,
    primaryBillingGroupId: Input.Optional[String] = None
  )(using Context): AccountArgs =
    new AccountArgs(
      name = name.asOptionOutput(isSecret = false),
      primaryBillingGroupId = primaryBillingGroupId.asOptionOutput(isSecret = false)
    )
