package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AccountAuthentication private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  accountId: Output[String],
  authenticationId: Output[String],
  autoJoinTeamId: Output[Option[String]],
  createTime: Output[String],
  enabled: Output[Option[Boolean]],
  name: Output[String],
  samlAcsUrl: Output[String],
  samlCertificate: Output[Option[String]],
  samlDigestAlgorithm: Output[Option[String]],
  samlEntityId: Output[Option[String]],
  samlFieldMapping: Output[Option[besom.api.aiven.outputs.AccountAuthenticationSamlFieldMapping]],
  samlIdpLoginAllowed: Output[Option[Boolean]],
  samlIdpUrl: Output[Option[String]],
  samlMetadataUrl: Output[String],
  samlSignatureAlgorithm: Output[Option[String]],
  samlVariant: Output[Option[String]],
  `type`: Output[String],
  updateTime: Output[String]
) extends CustomResource derives ResourceDecoder

object AccountAuthentication:
  given outputOps: {} with
    extension(output: Output[AccountAuthentication])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def accountId: Output[String] = output.flatMap(_.accountId)
      def authenticationId: Output[String] = output.flatMap(_.authenticationId)
      def autoJoinTeamId: Output[Option[String]] = output.flatMap(_.autoJoinTeamId)
      def createTime: Output[String] = output.flatMap(_.createTime)
      def enabled: Output[Option[Boolean]] = output.flatMap(_.enabled)
      def name: Output[String] = output.flatMap(_.name)
      def samlAcsUrl: Output[String] = output.flatMap(_.samlAcsUrl)
      def samlCertificate: Output[Option[String]] = output.flatMap(_.samlCertificate)
      def samlDigestAlgorithm: Output[Option[String]] = output.flatMap(_.samlDigestAlgorithm)
      def samlEntityId: Output[Option[String]] = output.flatMap(_.samlEntityId)
      def samlFieldMapping: Output[Option[besom.api.aiven.outputs.AccountAuthenticationSamlFieldMapping]] = output.flatMap(_.samlFieldMapping)
      def samlIdpLoginAllowed: Output[Option[Boolean]] = output.flatMap(_.samlIdpLoginAllowed)
      def samlIdpUrl: Output[Option[String]] = output.flatMap(_.samlIdpUrl)
      def samlMetadataUrl: Output[String] = output.flatMap(_.samlMetadataUrl)
      def samlSignatureAlgorithm: Output[Option[String]] = output.flatMap(_.samlSignatureAlgorithm)
      def samlVariant: Output[Option[String]] = output.flatMap(_.samlVariant)
      def `type`: Output[String] = output.flatMap(_.`type`)
      def updateTime: Output[String] = output.flatMap(_.updateTime)

def accountAuthentication(using ctx: Context)(
  name: NonEmptyString,
  args: AccountAuthenticationArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AccountAuthentication] = 
  ctx.registerResource[AccountAuthentication, AccountAuthenticationArgs]("aiven:index/accountAuthentication:AccountAuthentication", name, args, opts)

