package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AccountAuthenticationArgs private(
  accountId: Output[String],
  autoJoinTeamId: Output[Option[String]],
  enabled: Output[Option[Boolean]],
  name: Output[Option[String]],
  samlCertificate: Output[Option[String]],
  samlDigestAlgorithm: Output[Option[String]],
  samlEntityId: Output[Option[String]],
  samlFieldMapping: Output[Option[besom.api.aiven.inputs.AccountAuthenticationSamlFieldMappingArgs]],
  samlIdpLoginAllowed: Output[Option[Boolean]],
  samlIdpUrl: Output[Option[String]],
  samlSignatureAlgorithm: Output[Option[String]],
  samlVariant: Output[Option[String]],
  `type`: Output[String]
) derives ArgsEncoder

object AccountAuthenticationArgs:
  def apply(
    accountId: Input[String],
    autoJoinTeamId: Input.Optional[String] = None,
    enabled: Input.Optional[Boolean] = None,
    name: Input.Optional[String] = None,
    samlCertificate: Input.Optional[String] = None,
    samlDigestAlgorithm: Input.Optional[String] = None,
    samlEntityId: Input.Optional[String] = None,
    samlFieldMapping: Input.Optional[besom.api.aiven.inputs.AccountAuthenticationSamlFieldMappingArgs] = None,
    samlIdpLoginAllowed: Input.Optional[Boolean] = None,
    samlIdpUrl: Input.Optional[String] = None,
    samlSignatureAlgorithm: Input.Optional[String] = None,
    samlVariant: Input.Optional[String] = None,
    `type`: Input[String]
  )(using Context): AccountAuthenticationArgs =
    new AccountAuthenticationArgs(
      accountId = accountId.asOutput(isSecret = false),
      autoJoinTeamId = autoJoinTeamId.asOptionOutput(isSecret = false),
      enabled = enabled.asOptionOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      samlCertificate = samlCertificate.asOptionOutput(isSecret = false),
      samlDigestAlgorithm = samlDigestAlgorithm.asOptionOutput(isSecret = false),
      samlEntityId = samlEntityId.asOptionOutput(isSecret = false),
      samlFieldMapping = samlFieldMapping.asOptionOutput(isSecret = false),
      samlIdpLoginAllowed = samlIdpLoginAllowed.asOptionOutput(isSecret = false),
      samlIdpUrl = samlIdpUrl.asOptionOutput(isSecret = false),
      samlSignatureAlgorithm = samlSignatureAlgorithm.asOptionOutput(isSecret = false),
      samlVariant = samlVariant.asOptionOutput(isSecret = false),
      `type` = `type`.asOutput(isSecret = false)
    )
